/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="InstanceStreamToBatchMaker", category="Flow", toolTipText="Converts an incoming instance stream into a batch dataset", iconPath="weka/gui/knowledgeflow/icons/InstanceStreamToBatchMaker.gif")
public class InstanceStreamToBatchMaker
extends BaseStep {
    private static final long serialVersionUID = 5461324282251111320L;
    protected boolean m_isReset;
    protected Instances m_structure;
    protected boolean m_hasStringAtts;

    @Override
    public void stepInit() throws WekaException {
        this.m_isReset = true;
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("instance");
        }
        return null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() > 0) {
            return Arrays.asList("dataSet", "trainingSet", "testSet");
        }
        return null;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        if (this.m_isReset) {
            this.m_isReset = false;
            if (data.getPrimaryPayload() == null) {
                throw new WekaException("We didn't receive any instances!");
            }
            this.getStepManager().logDetailed("Collecting instances...");
            Instance temp = (Instance)data.getPrimaryPayload();
            this.m_structure = new Instances(temp.dataset(), 0).stringFreeStructure();
            this.m_hasStringAtts = temp.dataset().checkForStringAttributes();
        }
        if (this.isStopRequested()) {
            this.getStepManager().interrupted();
            return;
        }
        if (!this.getStepManager().isStreamFinished(data)) {
            this.getStepManager().throughputUpdateStart();
            Instance inst = (Instance)data.getPrimaryPayload();
            if (this.m_hasStringAtts) {
                for (int i2 = 0; i2 < this.m_structure.numAttributes(); ++i2) {
                    if (!this.m_structure.attribute(i2).isString() || inst.isMissing(i2)) continue;
                    int index = this.m_structure.attribute(i2).addStringValue(inst.stringValue(i2));
                    inst.setValue(i2, (double)index);
                }
            }
            this.m_structure.add(inst);
            this.getStepManager().throughputUpdateEnd();
        } else {
            this.m_structure.compactify();
            this.getStepManager().logBasic("Emitting a batch of " + this.m_structure.numInstances() + " instances.");
            ArrayList<String> outCons = new ArrayList<String>(this.getStepManager().getOutgoingConnections().keySet());
            Data out = new Data((String)outCons.get(0), this.m_structure);
            out.setPayloadElement("aux_set_num", 1);
            out.setPayloadElement("aux_max_set_num", 1);
            if (!this.isStopRequested()) {
                this.getStepManager().outputData(out);
                this.getStepManager().finished();
            } else {
                this.getStepManager().interrupted();
            }
        }
    }

    @Override
    public Instances outputStructureForConnectionType(String connectionName) throws WekaException {
        if (this.getStepManager().numIncomingConnections() > 0) {
            return this.getStepManager().getIncomingStructureForConnectionType("instance");
        }
        return null;
    }
}

