/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.PluginManager;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.gui.beans.OffscreenChartRenderer;
import weka.gui.beans.WekaOffscreenChartRenderer;
import weka.gui.visualize.PlotData2D;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.DataCollector;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="ModelPerformanceChart", category="Visualization", toolTipText="Visualize performance charts (such as ROC).", iconPath="weka/gui/knowledgeflow/icons/ModelPerformanceChart.gif")
public class ModelPerformanceChart
extends BaseStep
implements DataCollector {
    private static final long serialVersionUID = 6166590810777938147L;
    protected List<PlotData2D> m_plots = new ArrayList<PlotData2D>();
    protected transient List<Instances> m_offscreenPlotData;
    protected transient List<String> m_thresholdSeriesTitles;
    protected transient OffscreenChartRenderer m_offscreenRenderer;
    protected String m_offscreenRendererName = "Weka Chart Renderer";
    protected String m_xAxis = "";
    protected String m_yAxis = "";
    protected String m_additionalOptions = "";
    protected String m_width = "500";
    protected String m_height = "400";
    protected boolean m_dataIsThresholdData;

    @OptionMetadata(displayName="X-axis attribute", description="Attribute name or /first, /last or /<index>", displayOrder=1)
    public void setOffscreenXAxis(String xAxis) {
        this.m_xAxis = xAxis;
    }

    public String getOffscreenXAxis() {
        return this.m_xAxis;
    }

    @OptionMetadata(displayName="Y-axis attribute", description="Attribute name or /first, /last or /<index>", displayOrder=2)
    public void setOffscreenYAxis(String yAxis) {
        this.m_yAxis = yAxis;
    }

    public String getOffscreenYAxis() {
        return this.m_yAxis;
    }

    @OptionMetadata(displayName="Chart width (pixels)", description="Width of the rendered chart", displayOrder=3)
    public void setOffscreenWidth(String width) {
        this.m_width = width;
    }

    public String getOffscreenWidth() {
        return this.m_width;
    }

    @OptionMetadata(displayName="Chart height (pixels)", description="Height of the rendered chart", displayOrder=4)
    public void setOffscreenHeight(String height) {
        this.m_height = height;
    }

    public String getOffscreenHeight() {
        return this.m_height;
    }

    @ProgrammaticProperty
    public void setOffscreenRendererName(String rendererName) {
        this.m_offscreenRendererName = rendererName;
        this.m_offscreenRenderer = null;
    }

    public String getOffscreenRendererName() {
        return this.m_offscreenRendererName;
    }

    @ProgrammaticProperty
    public void setOffscreenAdditionalOpts(String additional) {
        this.m_additionalOptions = additional;
    }

    public String getOffscreenAdditionalOpts() {
        return this.m_additionalOptions;
    }

    protected void setupOffscreenRenderer() {
        this.getStepManager().logDetailed("Initializing offscreen renderer: " + this.getOffscreenRendererName());
        if (this.m_offscreenRenderer == null) {
            if (this.m_offscreenRendererName == null || this.m_offscreenRendererName.length() == 0) {
                this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                return;
            }
            if (this.m_offscreenRendererName.equalsIgnoreCase("weka chart renderer")) {
                this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
            } else {
                try {
                    Object r = PluginManager.getPluginInstance("weka.gui.beans.OffscreenChartRenderer", this.m_offscreenRendererName);
                    if (r != null && r instanceof OffscreenChartRenderer) {
                        this.m_offscreenRenderer = (OffscreenChartRenderer)r;
                    } else {
                        this.getStepManager().logWarning("Offscreen renderer '" + this.getOffscreenRendererName() + "' is not available, using default weka chart renderer instead");
                        this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                    }
                }
                catch (Exception ex) {
                    this.getStepManager().logWarning("Offscreen renderer '" + this.getOffscreenRendererName() + "' is not available, using default weka chart renderer instead");
                    this.m_offscreenRenderer = new WekaOffscreenChartRenderer();
                }
            }
        }
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnections() == 0) {
            result.add("thresholdData");
            result.add("visualizableError");
        } else if (this.getStepManager().numIncomingConnectionsOfType("thresholdData") > 0) {
            result.add("thresholdData");
        }
        return result;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnections() > 0) {
            result.add("image");
        }
        return result;
    }

    protected BufferedImage addOffscreenThresholdPlot(PlotData2D thresholdD) throws WekaException {
        String[] optsParts;
        this.m_offscreenPlotData.add(thresholdD.getPlotInstances());
        this.m_thresholdSeriesTitles.add(thresholdD.getPlotName());
        ArrayList<String> options = new ArrayList<String>();
        String additional = "-color=/last";
        if (this.m_additionalOptions != null && this.m_additionalOptions.length() > 0) {
            additional = this.m_additionalOptions;
            additional = this.getStepManager().environmentSubstitute(additional);
        }
        for (String p : optsParts = additional.split(",")) {
            options.add(p.trim());
        }
        String xAxis = "False Positive Rate";
        if (this.m_xAxis != null && this.m_xAxis.length() > 0) {
            xAxis = this.m_xAxis;
            xAxis = this.getStepManager().environmentSubstitute(xAxis);
        }
        String yAxis = "True Positive Rate";
        if (this.m_yAxis != null && this.m_yAxis.length() > 0) {
            yAxis = this.m_yAxis;
            yAxis = this.getStepManager().environmentSubstitute(yAxis);
        }
        String width = this.m_width;
        String height = this.m_height;
        int defWidth = 500;
        int defHeight = 400;
        width = this.getStepManager().environmentSubstitute(width);
        height = this.getStepManager().environmentSubstitute(height);
        defWidth = Integer.parseInt(width);
        defHeight = Integer.parseInt(height);
        ArrayList<Instances> series = new ArrayList<Instances>();
        for (int i2 = 0; i2 < this.m_offscreenPlotData.size(); ++i2) {
            Instances temp = new Instances(this.m_offscreenPlotData.get(i2));
            temp.setRelationName(this.m_thresholdSeriesTitles.get(i2));
            series.add(temp);
        }
        try {
            return this.m_offscreenRenderer.renderXYLineChart(defWidth, defHeight, series, xAxis, yAxis, options);
        }
        catch (Exception ex) {
            throw new WekaException(ex);
        }
    }

    protected BufferedImage addOffscreenErrorPlot(PlotData2D plotData) throws WekaException {
        String[] optionsParts;
        Instances newInsts;
        ArrayList<Attribute> atts;
        Instances predictedI = plotData.getPlotInstances();
        if (predictedI.classAttribute().isNominal()) {
            atts = new ArrayList<Attribute>();
            for (int i2 = 0; i2 < predictedI.numAttributes(); ++i2) {
                atts.add((Attribute)predictedI.attribute(i2).copy());
            }
            atts.add(new Attribute("@@size@@"));
            newInsts = new Instances(predictedI.relationName(), atts, predictedI.numInstances());
            newInsts.setClassIndex(predictedI.classIndex());
            for (int i3 = 0; i3 < predictedI.numInstances(); ++i3) {
                double[] vals = new double[newInsts.numAttributes()];
                for (int j = 0; j < predictedI.numAttributes(); ++j) {
                    vals[j] = predictedI.instance(i3).value(j);
                }
                vals[vals.length - 1] = 2.0;
                DenseInstance ni = new DenseInstance(1.0, vals);
                newInsts.add(ni);
            }
            Instances[] classes = new Instances[newInsts.numClasses()];
            for (int i4 = 0; i4 < newInsts.numClasses(); ++i4) {
                classes[i4] = new Instances(newInsts, 0);
                classes[i4].setRelationName(newInsts.classAttribute().value(i4));
            }
            Instances errors = new Instances(newInsts, 0);
            int actualClass = newInsts.classIndex();
            for (int i5 = 0; i5 < newInsts.numInstances(); ++i5) {
                Instance current = newInsts.instance(i5);
                classes[(int)current.classValue()].add((Instance)current.copy());
                if (current.value(actualClass) == current.value(actualClass - 1)) continue;
                Instance toAdd = (Instance)current.copy();
                toAdd.setValue(toAdd.numAttributes() - 1, 5.0);
                double actualClassV = toAdd.value(actualClass);
                double predictedClassV = toAdd.value(actualClass - 1);
                toAdd.setValue(actualClass, predictedClassV);
                toAdd.setValue(actualClass - 1, actualClassV);
                errors.add(toAdd);
            }
            errors.setRelationName("Errors");
            this.m_offscreenPlotData.add(errors);
            for (Instances classe : classes) {
                this.m_offscreenPlotData.add(classe);
            }
        } else {
            atts = new ArrayList();
            for (int i6 = 0; i6 < predictedI.numAttributes(); ++i6) {
                atts.add((Attribute)predictedI.attribute(i6).copy());
            }
            atts.add(new Attribute("@@size@@"));
            newInsts = new Instances(predictedI.relationName(), atts, predictedI.numInstances());
            int[] shapeSizes = plotData.getShapeSize();
            for (int i7 = 0; i7 < predictedI.numInstances(); ++i7) {
                double[] vals = new double[newInsts.numAttributes()];
                for (int j = 0; j < predictedI.numAttributes(); ++j) {
                    vals[j] = predictedI.instance(i7).value(j);
                }
                vals[vals.length - 1] = shapeSizes[i7];
                DenseInstance ni = new DenseInstance(1.0, vals);
                newInsts.add(ni);
            }
            newInsts.setRelationName(predictedI.classAttribute().name());
            this.m_offscreenPlotData.add(newInsts);
        }
        ArrayList<String> options = new ArrayList<String>();
        String additional = "-color=" + predictedI.classAttribute().name() + ",-hasErrors";
        if (this.m_additionalOptions != null && this.m_additionalOptions.length() > 0) {
            additional = additional + "," + this.m_additionalOptions;
            additional = this.environmentSubstitute(additional);
        }
        for (String p : optionsParts = additional.split(",")) {
            options.add(p.trim());
        }
        options.add("-shapeSize=@@size@@");
        String xAxis = this.m_xAxis;
        xAxis = this.environmentSubstitute(xAxis);
        String yAxis = this.m_yAxis;
        yAxis = this.environmentSubstitute(yAxis);
        String width = this.m_width;
        String height = this.m_height;
        int defWidth = 500;
        int defHeight = 400;
        width = this.environmentSubstitute(width);
        height = this.environmentSubstitute(height);
        defWidth = Integer.parseInt(width);
        defHeight = Integer.parseInt(height);
        try {
            return this.m_offscreenRenderer.renderXYScatterPlot(defWidth, defHeight, this.m_offscreenPlotData, xAxis, yAxis, options);
        }
        catch (Exception e1) {
            throw new WekaException(e1);
        }
    }

    @Override
    public synchronized void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        PlotData2D errorD = (PlotData2D)data.getPayloadElement("visualizableError");
        PlotData2D thresholdD = (PlotData2D)data.getPayloadElement("thresholdData");
        this.getStepManager().logDetailed("Processing " + (errorD != null ? " error data " + errorD.getPlotName() : " threshold data " + thresholdD.getPlotName()));
        if (data.getConnectionName().equals("visualizableError")) {
            this.m_plots.clear();
            this.m_plots.add(errorD);
            this.m_dataIsThresholdData = false;
            if (this.getStepManager().numOutgoingConnectionsOfType("image") > 0) {
                this.setupOffscreenRenderer();
                this.m_offscreenPlotData = new ArrayList<Instances>();
                BufferedImage bi = this.addOffscreenErrorPlot(errorD);
                Data imageD = new Data("image");
                imageD.setPayloadElement("image", bi);
                this.getStepManager().outputData("image", imageD);
            }
        } else if (data.getConnectionName().equals("thresholdData")) {
            if (this.m_plots.size() == 0) {
                this.m_plots.add(thresholdD);
            } else {
                if (!this.m_plots.get(0).getPlotInstances().relationName().equals(thresholdD.getPlotInstances().relationName())) {
                    this.m_plots.clear();
                }
                this.m_plots.add(thresholdD);
            }
            this.m_dataIsThresholdData = true;
            if (this.getStepManager().numOutgoingConnectionsOfType("image") > 0) {
                this.setupOffscreenRenderer();
                if (this.m_offscreenPlotData == null || this.m_offscreenPlotData.size() == 0 || !this.m_offscreenPlotData.get(0).relationName().equals(thresholdD.getPlotInstances().relationName())) {
                    this.m_offscreenPlotData = new ArrayList<Instances>();
                    this.m_thresholdSeriesTitles = new ArrayList<String>();
                }
                BufferedImage bi = this.addOffscreenThresholdPlot(thresholdD);
                Data imageD = new Data("image");
                imageD.setPayloadElement("image", bi);
                imageD.setPayloadElement("aux_textTitle", thresholdD.getPlotName());
                this.getStepManager().outputData("image", imageD);
            }
        }
        this.getStepManager().finished();
    }

    @Override
    public Map<String, String> getInteractiveViewers() {
        LinkedHashMap<String, String> views = new LinkedHashMap<String, String>();
        if (this.m_plots.size() > 0) {
            views.put("Show chart", "weka.gui.knowledgeflow.steps.ModelPerformanceChartInteractiveView");
        }
        return views;
    }

    public List<PlotData2D> getPlots() {
        return this.m_plots;
    }

    public boolean isDataIsThresholdData() {
        return this.m_dataIsThresholdData;
    }

    public void clearPlotData() {
        this.m_plots.clear();
        if (this.m_offscreenPlotData != null) {
            this.m_offscreenPlotData.clear();
        }
    }

    @Override
    public Object retrieveData() {
        Object[] onAndOffScreen = new Object[]{this.m_plots, this.m_dataIsThresholdData};
        return onAndOffScreen;
    }

    @Override
    public void restoreData(Object data) throws WekaException {
        if (!(data instanceof Object[])) {
            throw new WekaException("Argument must be a three element array, where the first element holds a list of Plot2D objects, the second a list of Instances objects and the third a boolean - true if the data is threshold data");
        }
        this.m_plots = (List)((Object[])data)[0];
        this.m_dataIsThresholdData = (Boolean)((Object[])data)[1];
        this.m_offscreenPlotData = new ArrayList<Instances>();
    }

    @Override
    public void stepInit() throws WekaException {
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.ModelPerformanceChartStepEditorDialog";
    }
}

