/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weka.core.Attribute;
import weka.core.Environment;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionMetadata;
import weka.core.WekaException;
import weka.gui.FilePropertyMetadata;
import weka.gui.ProgrammaticProperty;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="Sorter", category="Tools", toolTipText="Sort instances in ascending or descending order according to the values of user-specified attributes. Instances can be sorted according to multiple attributes (defined in order). Handles datasets larger than can be fit into main memory via instance connections and specifying the in-memory buffer size. Implements a merge-sort by writing the sorted in-memory buffer to a file when full and then interleaving instances from the disk-based file(s) when the incoming stream has finished.", iconPath="weka/gui/knowledgeflow/icons/Sorter.gif")
public class Sorter
extends BaseStep {
    private static final long serialVersionUID = 3373283983192467264L;
    protected transient SortComparator m_sortComparator;
    protected transient List<InstanceHolder> m_incrementalBuffer;
    protected transient List<File> m_bufferFiles;
    protected String m_bufferSize = "10000";
    protected int m_bufferSizeI = 10000;
    protected Map<String, Integer> m_stringAttIndexes;
    protected String m_sortDetails;
    protected File m_tempDirectory = new File("");
    protected Instances m_connectedFormat;
    protected boolean m_isReset;
    protected boolean m_streaming;
    protected Data m_streamingData;

    public String getBufferSize() {
        return this.m_bufferSize;
    }

    @OptionMetadata(displayName="Size of in-mem streaming buffer", description="Number of instances to sort in memory before writing to a temp file (instance connections only)", displayOrder=1)
    public void setBufferSize(String buffSize) {
        this.m_bufferSize = buffSize;
    }

    @FilePropertyMetadata(fileChooserDialogType=0, directoriesOnly=true)
    @OptionMetadata(displayName="Directory for temp files", description="Where to store temporary files when spilling to disk", displayOrder=2)
    public void setTempDirectory(File tempDir) {
        this.m_tempDirectory = tempDir;
    }

    public File getTempDirectory() {
        return this.m_tempDirectory;
    }

    @ProgrammaticProperty
    public void setSortDetails(String sortDetails) {
        this.m_sortDetails = sortDetails;
    }

    public String getSortDetails() {
        return this.m_sortDetails;
    }

    @Override
    public void stepInit() throws WekaException {
        this.m_isReset = true;
        this.m_streaming = false;
        this.m_stringAttIndexes = new HashMap<String, Integer>();
        this.m_bufferFiles = new ArrayList<File>();
        this.m_streamingData = new Data("instance");
    }

    @Override
    public List<String> getIncomingConnectionTypes() {
        if (this.getStepManager().numIncomingConnections() == 0) {
            return Arrays.asList("instance", "dataSet", "trainingSet", "testSet");
        }
        return null;
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getStepManager().numIncomingConnectionsOfType("instance") > 0) {
            result.add("instance");
        }
        if (this.getStepManager().numIncomingConnectionsOfType("dataSet") > 0) {
            result.add("dataSet");
        }
        if (this.getStepManager().numIncomingConnectionsOfType("trainingSet") > 0) {
            result.add("trainingSet");
        }
        if (this.getStepManager().numIncomingConnectionsOfType("testSet") > 0) {
            result.add("testSet");
        }
        return result;
    }

    protected void init(Instances structure) {
        this.m_connectedFormat = structure;
        ArrayList<SortRule> sortRules = new ArrayList<SortRule>();
        if (this.m_sortDetails != null && this.m_sortDetails.length() > 0) {
            String[] sortParts;
            for (String s : sortParts = this.m_sortDetails.split("@@sort-rule@@")) {
                SortRule r = new SortRule(s.trim());
                r.init(this.getStepManager().getExecutionEnvironment().getEnvironmentVariables(), structure);
                sortRules.add(r);
            }
            this.m_sortComparator = new SortComparator(sortRules);
        }
        this.m_stringAttIndexes = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < structure.numAttributes(); ++i2) {
            if (!structure.attribute(i2).isString()) continue;
            this.m_stringAttIndexes.put(structure.attribute(i2).name(), new Integer(i2));
        }
        if (this.m_stringAttIndexes.size() == 0) {
            this.m_stringAttIndexes = null;
        }
        if (this.m_streaming) {
            String buffSize = this.environmentSubstitute(this.m_bufferSize);
            this.m_bufferSizeI = Integer.parseInt(buffSize);
            this.m_incrementalBuffer = new ArrayList<InstanceHolder>(this.m_bufferSizeI);
        }
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        if (this.m_isReset) {
            Instances structure;
            if (data.getConnectionName().equals("instance")) {
                Instance inst = (Instance)data.getPrimaryPayload();
                structure = new Instances(inst.dataset(), 0);
                this.m_streaming = true;
                this.getStepManager().logBasic("Starting streaming sort. Using streaming buffer size: " + this.m_bufferSizeI);
                this.m_isReset = false;
            } else {
                structure = (Instances)data.getPrimaryPayload();
                structure = new Instances(structure, 0);
            }
            this.init(structure);
        }
        if (this.m_streaming) {
            this.processIncremental(data);
        } else {
            this.processBatch(data);
        }
        if (this.isStopRequested()) {
            this.getStepManager().interrupted();
        } else if (!this.m_streaming) {
            this.getStepManager().finished();
        }
    }

    protected void processBatch(Data data) throws WekaException {
        this.getStepManager().processing();
        Instances insts = (Instances)data.getPrimaryPayload();
        this.getStepManager().logBasic("Sorting " + insts.relationName());
        ArrayList<InstanceHolder> instances = new ArrayList<InstanceHolder>();
        for (int i2 = 0; i2 < insts.numInstances(); ++i2) {
            InstanceHolder h = new InstanceHolder();
            h.m_instance = insts.instance(i2);
            instances.add(h);
        }
        Collections.sort(instances, this.m_sortComparator);
        Instances output = new Instances(insts, 0);
        for (int i3 = 0; i3 < instances.size(); ++i3) {
            output.add(((InstanceHolder)instances.get((int)i3)).m_instance);
        }
        Data outputD = new Data(data.getConnectionName(), output);
        outputD.setPayloadElement("aux_set_num", data.getPayloadElement("aux_set_num"));
        outputD.setPayloadElement("aux_max_set_num", data.getPayloadElement("aux_max_set_num"));
        this.getStepManager().outputData(outputD);
    }

    protected void processIncremental(Data data) throws WekaException {
        if (this.isStopRequested()) {
            return;
        }
        if (this.getStepManager().isStreamFinished(data)) {
            this.emitBufferedInstances();
        } else {
            this.getStepManager().throughputUpdateStart();
            InstanceHolder tempH = new InstanceHolder();
            tempH.m_instance = (Instance)data.getPrimaryPayload();
            tempH.m_fileNumber = -1;
            if (this.m_stringAttIndexes != null) {
                this.copyStringAttVals(tempH);
            }
            this.m_incrementalBuffer.add(tempH);
            if (this.m_incrementalBuffer.size() == this.m_bufferSizeI) {
                try {
                    this.sortBuffer(true);
                }
                catch (Exception ex) {
                    throw new WekaException(ex);
                }
            }
            this.getStepManager().throughputUpdateEnd();
        }
    }

    protected void emitBufferedInstances() throws WekaException {
        if (this.isStopRequested()) {
            return;
        }
        if (this.m_incrementalBuffer.size() > 0) {
            try {
                this.getStepManager().throughputUpdateStart();
                this.sortBuffer(false);
                this.getStepManager().throughputUpdateEnd();
            }
            catch (Exception ex) {
                throw new WekaException(ex);
            }
            if (this.m_bufferFiles.size() == 0) {
                this.getStepManager().logDetailed("Emitting in memory buffer");
                Instances newHeader = new Instances(this.m_incrementalBuffer.get((int)0).m_instance.dataset(), 0);
                for (int i2 = 0; i2 < this.m_incrementalBuffer.size(); ++i2) {
                    this.getStepManager().throughputUpdateStart();
                    InstanceHolder currentH = this.m_incrementalBuffer.get(i2);
                    currentH.m_instance.setDataset(newHeader);
                    if (this.m_stringAttIndexes != null) {
                        for (String attName : this.m_stringAttIndexes.keySet()) {
                            boolean setValToZero = newHeader.attribute(attName).numValues() > 0;
                            newHeader.attribute(attName).setStringValue(currentH.m_stringVals.get(attName));
                            if (!setValToZero) continue;
                            currentH.m_instance.setValue(newHeader.attribute(attName), 0.0);
                        }
                    }
                    if (this.isStopRequested()) {
                        return;
                    }
                    this.m_streamingData.setPayloadElement("instance", currentH.m_instance);
                    this.getStepManager().throughputUpdateEnd();
                    this.getStepManager().outputData(this.m_streamingData);
                    if (i2 != this.m_incrementalBuffer.size() - 1) continue;
                    this.m_streamingData.clearPayload();
                    this.getStepManager().throughputFinished(this.m_streamingData);
                }
                return;
            }
        }
        ArrayList<ObjectInputStream> inputStreams = new ArrayList<ObjectInputStream>();
        ArrayList<InstanceHolder> merger = new ArrayList<InstanceHolder>();
        Instances tempHeader = new Instances(this.m_connectedFormat, 0);
        if (this.m_incrementalBuffer.size() > 0) {
            InstanceHolder tempH = this.m_incrementalBuffer.remove(0);
            merger.add(tempH);
        }
        if (this.isStopRequested()) {
            return;
        }
        if (this.m_bufferFiles.size() > 0) {
            this.getStepManager().logDetailed("Merging temp files");
        }
        for (int i3 = 0; i3 < this.m_bufferFiles.size(); ++i3) {
            ObjectInputStream ois = null;
            try {
                FileInputStream fis = new FileInputStream(this.m_bufferFiles.get(i3));
                BufferedInputStream bis = new BufferedInputStream(fis, 50000);
                ois = new ObjectInputStream(bis);
                InstanceHolder tempH = (InstanceHolder)ois.readObject();
                if (tempH != null) {
                    inputStreams.add(ois);
                    tempH.m_fileNumber = i3;
                    merger.add(tempH);
                    continue;
                }
                ois.close();
                continue;
            }
            catch (Exception ex) {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (Exception e) {
                        throw new WekaException(e);
                    }
                }
                throw new WekaException(ex);
            }
        }
        Collections.sort(merger, this.m_sortComparator);
        int mergeCount = 0;
        do {
            if (this.isStopRequested()) {
                return;
            }
            InstanceHolder holder = (InstanceHolder)merger.remove(0);
            holder.m_instance.setDataset(tempHeader);
            if (this.m_stringAttIndexes != null) {
                for (String attName : this.m_stringAttIndexes.keySet()) {
                    boolean setValToZero = tempHeader.attribute(attName).numValues() > 1;
                    tempHeader.attribute(attName).setStringValue(holder.m_stringVals.get(attName));
                    if (!setValToZero) continue;
                    holder.m_instance.setValue(tempHeader.attribute(attName), 0.0);
                }
            }
            this.m_streamingData.setPayloadElement("instance", holder.m_instance);
            this.getStepManager().outputData(this.m_streamingData);
            this.getStepManager().throughputUpdateStart();
            if (++mergeCount % this.m_bufferSizeI == 0) {
                this.getStepManager().logDetailed("Merged " + mergeCount + " instances");
            }
            int smallest = holder.m_fileNumber;
            InstanceHolder nextH = null;
            if (smallest == -1) {
                if (this.m_incrementalBuffer.size() > 0) {
                    nextH = this.m_incrementalBuffer.remove(0);
                    nextH.m_fileNumber = -1;
                }
            } else {
                ObjectInputStream tis = (ObjectInputStream)inputStreams.get(smallest);
                try {
                    InstanceHolder tempH = (InstanceHolder)tis.readObject();
                    if (tempH == null) {
                        throw new Exception("end of buffer");
                    }
                    nextH = tempH;
                    nextH.m_fileNumber = smallest;
                }
                catch (Exception ex) {
                    try {
                        this.getStepManager().logDetailed("Closing temp file");
                        tis.close();
                    }
                    catch (Exception e) {
                        throw new WekaException(ex);
                    }
                    File file = this.m_bufferFiles.remove(smallest);
                    inputStreams.remove(smallest);
                    for (InstanceHolder h : merger) {
                        if (h.m_fileNumber == -1 || h.m_fileNumber <= smallest) continue;
                        --h.m_fileNumber;
                    }
                }
            }
            if (nextH != null) {
                int index = Collections.binarySearch(merger, nextH, this.m_sortComparator);
                if (index < 0) {
                    merger.add(index * -1 - 1, nextH);
                } else {
                    merger.add(index, nextH);
                }
                nextH = null;
            }
            this.getStepManager().throughputUpdateEnd();
        } while (merger.size() > 0 && !this.isStopRequested());
        if (!this.isStopRequested()) {
            this.m_streamingData.clearPayload();
            this.getStepManager().throughputFinished(this.m_streamingData);
        } else {
            for (ObjectInputStream is : inputStreams) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void sortBuffer(boolean write) throws Exception {
        File tempDir;
        this.getStepManager().logBasic("Sorting in memory buffer");
        Collections.sort(this.m_incrementalBuffer, this.m_sortComparator);
        if (!write) {
            return;
        }
        if (this.isStopRequested()) {
            return;
        }
        String tmpDir = this.m_tempDirectory.toString();
        File tempFile = File.createTempFile("Sorter", ".tmp");
        if (tmpDir != null && tmpDir.length() > 0 && (tempDir = new File(tmpDir = this.environmentSubstitute(tmpDir))).exists() && tempDir.canWrite()) {
            String filename = tempFile.getName();
            tempFile = new File(tmpDir + File.separator + filename);
            tempFile.deleteOnExit();
        }
        this.getStepManager().logDebug("Temp file: " + tempFile.toString());
        this.m_bufferFiles.add(tempFile);
        FileOutputStream fos = new FileOutputStream(tempFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos, 50000);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        this.getStepManager().logDetailed("Writing buffer to temp file " + this.m_bufferFiles.size() + ". Buffer contains " + this.m_incrementalBuffer.size() + " instances");
        for (int i2 = 0; i2 < this.m_incrementalBuffer.size(); ++i2) {
            InstanceHolder temp = this.m_incrementalBuffer.get(i2);
            temp.m_instance.setDataset(null);
            oos.writeObject(temp);
            if (i2 % (this.m_bufferSizeI / 10) != 0) continue;
            oos.reset();
        }
        bos.flush();
        oos.close();
        this.m_incrementalBuffer.clear();
    }

    private void copyStringAttVals(InstanceHolder holder) {
        for (String attName : this.m_stringAttIndexes.keySet()) {
            Attribute att = holder.m_instance.dataset().attribute(attName);
            String val = holder.m_instance.stringValue(att);
            if (holder.m_stringVals == null) {
                holder.m_stringVals = new HashMap<String, String>();
            }
            holder.m_stringVals.put(attName, val);
        }
    }

    @Override
    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.SorterStepEditorDialog";
    }

    public static class SortRule
    implements Comparator<InstanceHolder> {
        protected String m_attributeNameOrIndex;
        protected Attribute m_attribute;
        protected boolean m_descending;

        public SortRule(String att, boolean descending) {
            this.m_attributeNameOrIndex = att;
            this.m_descending = descending;
        }

        public SortRule() {
        }

        public SortRule(String setup) {
            this.parseFromInternal(setup);
        }

        protected void parseFromInternal(String setup) {
            String[] parts = setup.split("@@SR@@");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Malformed sort rule: " + setup);
            }
            this.m_attributeNameOrIndex = parts[0].trim();
            this.m_descending = parts[1].equalsIgnoreCase("Y");
        }

        public String toStringInternal() {
            return this.m_attributeNameOrIndex + "@@SR@@" + (this.m_descending ? "Y" : "N");
        }

        public String toString() {
            StringBuffer res = new StringBuffer();
            res.append("Attribute: " + this.m_attributeNameOrIndex + " - sort " + (this.m_descending ? "descending" : "ascending"));
            return res.toString();
        }

        public void setAttribute(String att) {
            this.m_attributeNameOrIndex = att;
        }

        public String getAttribute() {
            return this.m_attributeNameOrIndex;
        }

        public void setDescending(boolean d) {
            this.m_descending = d;
        }

        public boolean getDescending() {
            return this.m_descending;
        }

        public void init(Environment env, Instances structure) {
            String attNameI = this.m_attributeNameOrIndex;
            try {
                attNameI = env.substitute(attNameI);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (attNameI.equalsIgnoreCase("/first")) {
                this.m_attribute = structure.attribute(0);
            } else if (attNameI.equalsIgnoreCase("/last")) {
                this.m_attribute = structure.attribute(structure.numAttributes() - 1);
            } else {
                this.m_attribute = structure.attribute(attNameI);
                if (this.m_attribute == null) {
                    try {
                        int index = Integer.parseInt(attNameI);
                        this.m_attribute = structure.attribute(index);
                    }
                    catch (NumberFormatException n) {
                        throw new IllegalArgumentException("Unable to locate attribute " + attNameI + " as either a named attribute or as a valid attribute index");
                    }
                }
            }
        }

        @Override
        public int compare(InstanceHolder o1, InstanceHolder o2) {
            if (o1.m_instance.isMissing(this.m_attribute) && o2.m_instance.isMissing(this.m_attribute)) {
                return 0;
            }
            if (o1.m_instance.isMissing(this.m_attribute)) {
                return 1;
            }
            if (o2.m_instance.isMissing(this.m_attribute)) {
                return -1;
            }
            int cmp = 0;
            if (!this.m_attribute.isString() && !this.m_attribute.isRelationValued()) {
                double val1 = o1.m_instance.value(this.m_attribute);
                double val2 = o2.m_instance.value(this.m_attribute);
                cmp = Double.compare(val1, val2);
            } else if (this.m_attribute.isString()) {
                String val1 = o1.m_stringVals.get(this.m_attribute.name());
                String val2 = o2.m_stringVals.get(this.m_attribute.name());
                cmp = val1.compareTo(val2);
            } else {
                throw new IllegalArgumentException("Can't sort according to relation-valued attribute values!");
            }
            if (this.m_descending) {
                return -cmp;
            }
            return cmp;
        }
    }

    protected static class SortComparator
    implements Comparator<InstanceHolder> {
        protected List<SortRule> m_sortRules;

        public SortComparator(List<SortRule> sortRules) {
            this.m_sortRules = sortRules;
        }

        @Override
        public int compare(InstanceHolder o1, InstanceHolder o2) {
            int cmp = 0;
            for (SortRule sr : this.m_sortRules) {
                cmp = sr.compare(o1, o2);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }

    protected static class InstanceHolder
    implements Serializable {
        private static final long serialVersionUID = -3985730394250172995L;
        protected Instance m_instance;
        protected int m_fileNumber;
        protected Map<String, String> m_stringVals;

        protected InstanceHolder() {
        }
    }
}

