/*
 * Decompiled with CFR 0.152.
 */
package ai;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.PlayerActionGenerator;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.Pair;

public class BranchingFactorCalculatorLong {
    public static int DEBUG = 0;

    public static long branchingFactorUpperBound(GameState gs, int player) throws Exception {
        PlayerActionGenerator pag = new PlayerActionGenerator(gs, player);
        return pag.getSize();
    }

    public static long branchingFactor(GameState gs, int player) throws Exception {
        long n = 0L;
        PlayerActionGenerator pag = new PlayerActionGenerator(gs, player);
        while (pag.getNextAction(-1L) != null) {
            ++n;
        }
        return n;
    }

    public static long[] branchingFactorByResourceUsage(GameState gs, int player) throws Exception {
        long[] n = new long[gs.getPlayer(player).getResources() + 1];
        PlayerActionGenerator pag = new PlayerActionGenerator(gs, player);
        PlayerAction pa = null;
        do {
            if ((pa = pag.getNextAction(-1L)) == null) continue;
            int r = 0;
            for (Pair<Unit, UnitAction> tmp : pa.getActions()) {
                r += ((UnitAction)tmp.m_b).resourceUsage((Unit)tmp.m_a, gs.getPhysicalGameState()).getResourcesUsed(player);
            }
            int n2 = r;
            n[n2] = n[n2] + 1L;
        } while (pa != null);
        return n;
    }

    public static void addFootPrint(int[][] map, int ID, int x, int y) {
        if (map[x][y] == 0) {
            map[x][y] = ID;
        } else {
            int ID_to_remove = map[x][y];
            LinkedList<Integer> open_x = new LinkedList<Integer>();
            LinkedList<Integer> open_y = new LinkedList<Integer>();
            open_x.add(x);
            open_y.add(y);
            while (!open_x.isEmpty()) {
                x = (Integer)open_x.remove(0);
                if (map[x][y = ((Integer)open_y.remove(0)).intValue()] == ID) continue;
                map[x][y] = ID;
                if (x > 0 && map[x - 1][y] == ID_to_remove) {
                    open_x.add(0, x - 1);
                    open_y.add(0, y);
                }
                if (x < map.length - 1 && map[x + 1][y] == ID_to_remove) {
                    open_x.add(0, x + 1);
                    open_y.add(0, y);
                }
                if (y > 0 && map[x][y - 1] == ID_to_remove) {
                    open_x.add(0, x);
                    open_y.add(0, y - 1);
                }
                if (y >= map[0].length - 1 || map[x][y + 1] != ID_to_remove) continue;
                open_x.add(0, x);
                open_y.add(0, y + 1);
            }
        }
    }

    public static long branchingFactorByResourceUsageSeparatingFast(GameState gs, int player) throws Exception {
        int playerResources = gs.getPlayer(player).getResources();
        GameState gs2 = gs.clone();
        PhysicalGameState pgs2 = gs2.getPhysicalGameState();
        int[][] separation = new int[pgs2.getWidth()][pgs2.getHeight()];
        int ID = 1;
        for (Unit u : gs2.getUnits()) {
            if (u.getPlayer() != player || gs2.getUnitAction(u) != null) continue;
            List<UnitAction> ual = u.getUnitActions(gs2);
            BranchingFactorCalculatorLong.addFootPrint(separation, ID, u.getX(), u.getY());
            for (UnitAction ua : ual) {
                ResourceUsage ru = ua.resourceUsage(u, gs2.getPhysicalGameState());
                for (int pos : ru.getPositionsUsed()) {
                    int x = pos % pgs2.getWidth();
                    int y = pos / pgs2.getWidth();
                    BranchingFactorCalculatorLong.addFootPrint(separation, ID, x, y);
                }
            }
            ++ID;
        }
        LinkedList<Integer> areas = new LinkedList<Integer>();
        for (int i = 0; i < pgs2.getHeight(); ++i) {
            for (int j = 0; j < pgs2.getWidth(); ++j) {
                if (separation[j][i] == 0 || areas.contains(separation[j][i])) continue;
                areas.add(separation[j][i]);
            }
        }
        LinkedList<long[]> branchingOfSeparatedAreas = new LinkedList<long[]>();
        Iterator j = areas.iterator();
        while (j.hasNext()) {
            int area = (Integer)j.next();
            PlayerAction pa = new PlayerAction();
            LinkedList<Unit> unitsInArea = new LinkedList<Unit>();
            LinkedList<Unit> unitsNotInArea = new LinkedList<Unit>();
            for (Unit u : gs2.getUnits()) {
                if (u.getPlayer() != player || gs2.getUnitAction(u) != null) continue;
                if (separation[u.getX()][u.getY()] == area) {
                    unitsInArea.add(u);
                    continue;
                }
                unitsNotInArea.add(u);
                pa.addUnitAction(u, new UnitAction(0));
            }
            GameState gs3 = gs2.cloneIssue(pa).clone();
            long[] n = BranchingFactorCalculatorLong.branchingFactorByResourceUsageFastInternal(gs3, player);
            branchingOfSeparatedAreas.add(n);
        }
        if (branchingOfSeparatedAreas.isEmpty()) {
            return 1L;
        }
        long[] n = (long[])branchingOfSeparatedAreas.remove(0);
        for (long[] n2 : branchingOfSeparatedAreas) {
            long[] n_tmp = new long[playerResources + 1];
            for (int i = 0; i < playerResources + 1; ++i) {
                for (int j2 = 0; j2 < playerResources - i + 1; ++j2) {
                    int n3 = i + j2;
                    n_tmp[n3] = n_tmp[n3] + n2[i] * n[j2];
                }
            }
            n = n_tmp;
        }
        long branching = 0L;
        for (int i = 0; i < playerResources + 1; ++i) {
            branching += n[i];
        }
        return branching;
    }

    public static long branchingFactorByResourceUsageFast(GameState gs, int player) throws Exception {
        int playerResources = gs.getPlayer(player).getResources();
        long[] n = BranchingFactorCalculatorLong.branchingFactorByResourceUsageFastInternal(gs, player);
        long branching = 0L;
        for (int i = 0; i < playerResources + 1; ++i) {
            branching += n[i];
        }
        return branching;
    }

    public static long[] branchingFactorByResourceUsageFastInternal(GameState gs, int player) throws Exception {
        long[] n;
        GameState gs2 = gs.clone();
        PhysicalGameState pgs2 = gs2.getPhysicalGameState();
        int playerResources = gs2.getPlayer(player).getResources();
        LinkedList<Unit> unitsThatCannotBeSeparated = new LinkedList<Unit>();
        LinkedList<Unit> unitsToSeparate = new LinkedList<Unit>();
        LinkedList<long[]> branchingOfSeparatedUnits = new LinkedList<long[]>();
        PlayerAction pa = new PlayerAction();
        for (Unit u : gs2.getUnits()) {
            if (u.getPlayer() != player || gs2.getUnitAction(u) != null) continue;
            HashSet<Integer> positionsUsed = new HashSet<Integer>();
            int resourcesUsed = 0;
            for (Unit u2 : gs2.getUnits()) {
                if (u2 == u || u2.getPlayer() != player || gs2.getUnitAction(u2) != null) continue;
                List<UnitAction> ual = u2.getUnitActions(gs2);
                int maxResources = 0;
                for (UnitAction ua : ual) {
                    ResourceUsage ru = ua.resourceUsage(u2, pgs2);
                    positionsUsed.addAll(ru.getPositionsUsed());
                    maxResources = Math.max(maxResources, ru.getResourcesUsed(player));
                }
                resourcesUsed += maxResources;
            }
            if (DEBUG >= 1) {
                System.out.println("- " + u + " --------");
            }
            List<UnitAction> ual = u.getUnitActions(gs2);
            boolean positionConflict = false;
            long[] unitBranching = new long[playerResources + 1];
            for (UnitAction ua : ual) {
                ResourceUsage ru = ua.resourceUsage(u, pgs2);
                int n2 = ru.getResourcesUsed(player);
                unitBranching[n2] = unitBranching[n2] + 1L;
                for (Integer pos : ru.getPositionsUsed()) {
                    if (!positionsUsed.contains(pos)) continue;
                    positionConflict = true;
                }
            }
            if (!positionConflict) {
                unitsToSeparate.add(u);
                branchingOfSeparatedUnits.add(unitBranching);
                pa.addUnitAction(u, new UnitAction(0));
                if (DEBUG < 1) continue;
                System.out.println("  *** Separating unit " + u);
                continue;
            }
            unitsThatCannotBeSeparated.add(u);
        }
        gs2.issue(pa);
        if (!unitsThatCannotBeSeparated.isEmpty()) {
            n = BranchingFactorCalculatorLong.branchingFactorByResourceUsage(gs2, player);
            branchingOfSeparatedUnits.add(n);
        }
        n = (long[])branchingOfSeparatedUnits.remove(0);
        for (long[] n2 : branchingOfSeparatedUnits) {
            long[] n_tmp = new long[playerResources + 1];
            for (int i = 0; i < playerResources + 1; ++i) {
                for (int j = 0; j < playerResources - i + 1; ++j) {
                    int n3 = i + j;
                    n_tmp[n3] = n_tmp[n3] + n2[i] * n[j];
                }
            }
            n = n_tmp;
        }
        return n;
    }
}

