/*
 * Decompiled with CFR 0.152.
 */
package ai;

import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Sampler;

public class RandomBiasedAI
extends AI {
    static final double REGULAR_ACTION_WEIGHT = 1.0;
    static final double BIASED_ACTION_WEIGHT = 5.0;
    Random r = new Random();

    public RandomBiasedAI(UnitTypeTable utt) {
    }

    public RandomBiasedAI() {
    }

    @Override
    public void reset() {
    }

    @Override
    public AI clone() {
        return new RandomBiasedAI();
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        PlayerAction pa = new PlayerAction();
        if (!gs.canExecuteAnyAction(player)) {
            return pa;
        }
        for (Unit u : pgs.getUnits()) {
            UnitActionAssignment uaa = gs.getActionAssignment(u);
            if (uaa == null) continue;
            ResourceUsage ru = uaa.action.resourceUsage(u, pgs);
            pa.getResourceUsage().merge(ru);
        }
        for (Unit u : pgs.getUnits()) {
            if (u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            List<UnitAction> l = u.getUnitActions(gs);
            UnitAction none = null;
            int nActions = l.size();
            double[] distribution = new double[nActions];
            int i = 0;
            for (UnitAction a : l) {
                if (a.getType() == 0) {
                    none = a;
                }
                distribution[i] = a.getType() == 5 || a.getType() == 2 || a.getType() == 3 ? 5.0 : 1.0;
                ++i;
            }
            try {
                UnitAction ua = l.get(Sampler.weighted(distribution));
                if (ua.resourceUsage(u, pgs).consistentWith(pa.getResourceUsage(), gs)) {
                    ResourceUsage ru = ua.resourceUsage(u, pgs);
                    pa.getResourceUsage().merge(ru);
                    pa.addUnitAction(u, ua);
                    continue;
                }
                pa.addUnitAction(u, none);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                pa.addUnitAction(u, none);
            }
        }
        return pa;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return new ArrayList<ParameterSpecification>();
    }
}

