/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractTraceEntry;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class AbstractTrace {
    UnitTypeTable utt;
    List<AbstractTraceEntry> entries = new LinkedList<AbstractTraceEntry>();
    protected HashMap<Unit, AbstractAction> currentActions = new LinkedHashMap<Unit, AbstractAction>();

    public AbstractTrace(UnitTypeTable a_utt) {
        this.utt = a_utt;
    }

    public List<AbstractTraceEntry> getEntries() {
        return this.entries;
    }

    public UnitTypeTable getUnitTypeTable() {
        return this.utt;
    }

    public int getLength() {
        return this.entries.get(this.entries.size() - 1).getTime();
    }

    public void addEntry(AbstractTraceEntry te) {
        this.entries.add(te);
    }

    public AbstractAction getCurrentAbstractAction(Unit u) {
        return this.currentActions.get(u);
    }

    public AbstractAction setCurrentAbstractAction(Unit u, AbstractAction aa) {
        return this.currentActions.put(u, aa);
    }

    public void toxml(XMLWriter w) {
        w.tag(this.getClass().getName());
        this.utt.toxml(w);
        w.tag("entries");
        for (AbstractTraceEntry te : this.entries) {
            te.toxml(w);
        }
        w.tag("/entries");
        w.tag("/" + this.getClass().getName());
    }

    public AbstractTrace(Element e) throws Exception {
        this.utt = UnitTypeTable.fromXML(e.getChild(UnitTypeTable.class.getName()));
        Element entries_e = e.getChild("entries");
        for (Object o : entries_e.getChildren()) {
            Element entry_e = (Element)o;
            this.entries.add(new AbstractTraceEntry(entry_e, this.utt));
        }
    }

    public AbstractTrace(Element e, UnitTypeTable a_utt) throws Exception {
        this.utt = a_utt;
        Element entries_e = e.getChild("entries");
        for (Object o : entries_e.getChildren()) {
            Element entry_e = (Element)o;
            this.entries.add(new AbstractTraceEntry(entry_e, this.utt));
        }
    }
}

