/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractTrace;
import ai.abstraction.Train;
import java.util.LinkedList;
import java.util.List;
import org.jdom.Element;
import rts.PhysicalGameState;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;
import util.XMLWriter;

public class AbstractTraceEntry {
    int time;
    PhysicalGameState pgs;
    List<Pair<Unit, AbstractAction>> actions = new LinkedList<Pair<Unit, AbstractAction>>();

    public AbstractTraceEntry(PhysicalGameState a_pgs, int a_time) {
        this.pgs = a_pgs;
        this.time = a_time;
    }

    public void addAbstractAction(Unit u, AbstractAction a) {
        this.actions.add(new Pair<Unit, AbstractAction>(u, a));
    }

    public void addAbstractActionIfNew(Unit u, AbstractAction a, AbstractTrace trace) {
        if (!a.equals(trace.getCurrentAbstractAction(u))) {
            this.addAbstractAction(u, a);
            trace.setCurrentAbstractAction(u, a);
        } else if (a instanceof Train) {
            this.addAbstractAction(u, a);
            trace.setCurrentAbstractAction(u, a);
        }
    }

    public PhysicalGameState getPhysicalGameState() {
        return this.pgs;
    }

    public List<Pair<Unit, AbstractAction>> getActions() {
        return this.actions;
    }

    public int getTime() {
        return this.time;
    }

    public void toxml(XMLWriter w) {
        w.tagWithAttributes(this.getClass().getName(), "time = \"" + this.time + "\"");
        this.pgs.toxml(w);
        w.tag("abstractactions");
        for (Pair<Unit, AbstractAction> ua : this.actions) {
            w.tagWithAttributes("abstractaction", "unitID=\"" + ((Unit)ua.m_a).getID() + "\"");
            ((AbstractAction)ua.m_b).toxml(w);
            w.tag("/abstractaction");
        }
        w.tag("/abstractactions");
        w.tag("/" + this.getClass().getName());
    }

    public AbstractTraceEntry(Element e, UnitTypeTable utt) throws Exception {
        Element actions_e = e.getChild("abstractactions");
        this.time = Integer.parseInt(e.getAttributeValue("time"));
        Element pgs_e = e.getChild(PhysicalGameState.class.getName());
        this.pgs = PhysicalGameState.fromXML(pgs_e, utt);
        for (Object o : actions_e.getChildren()) {
            Element action_e = (Element)o;
            long ID = Long.parseLong(action_e.getAttributeValue("unitID"));
            AbstractAction a = AbstractAction.fromXML(action_e.getChild("abstractaction"), this.pgs, utt);
            Unit u = this.pgs.getUnit(ID);
            this.actions.add(new Pair<Unit, AbstractAction>(u, a));
        }
    }
}

