/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.Attack;
import ai.abstraction.Build;
import ai.abstraction.Harvest;
import ai.abstraction.Idle;
import ai.abstraction.Move;
import ai.abstraction.Train;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AIWithComputationBudget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import util.Pair;

public abstract class AbstractionLayerAIWait1
extends AIWithComputationBudget {
    public static boolean VERIFY_ACTION_CORRECTNESS = false;
    protected HashMap<Unit, AbstractAction> actions = new LinkedHashMap<Unit, AbstractAction>();
    protected PathFinding pf;
    protected GameState lastGameState;

    public AbstractionLayerAIWait1(PathFinding a_pf) {
        super(-1, -1);
        this.pf = a_pf;
    }

    public AbstractionLayerAIWait1(PathFinding a_pf, int timebudget, int cyclesbudget) {
        super(timebudget, cyclesbudget);
        this.pf = a_pf;
    }

    @Override
    public void reset() {
        this.actions.clear();
    }

    public PlayerAction translateActions(int player, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        PlayerAction pa = new PlayerAction();
        ArrayList<Pair<Unit, UnitAction>> desires = new ArrayList<Pair<Unit, UnitAction>>();
        this.lastGameState = gs;
        ArrayList<Unit> toDelete = new ArrayList<Unit>();
        ResourceUsage ru = new ResourceUsage();
        for (AbstractAction aa : this.actions.values()) {
            UnitAction unitAction;
            if (!pgs.getUnits().contains(aa.unit)) {
                toDelete.add(aa.unit);
                continue;
            }
            if (aa.completed(gs)) {
                toDelete.add(aa.unit);
                continue;
            }
            if (gs.getActionAssignment(aa.unit) != null || (unitAction = aa.execute(gs, ru)) == null) continue;
            if (VERIFY_ACTION_CORRECTNESS) {
                List<UnitAction> ual = aa.unit.getUnitActions(gs);
                if (ual.contains(unitAction)) {
                    desires.add(new Pair<Unit, UnitAction>(aa.unit, unitAction));
                }
            } else {
                desires.add(new Pair<Unit, UnitAction>(aa.unit, unitAction));
            }
            ru.merge(unitAction.resourceUsage(aa.unit, pgs));
        }
        for (Unit u : toDelete) {
            this.actions.remove(u);
        }
        ResourceUsage r = gs.getResourceUsage();
        pa.setResourceUsage(r);
        for (Pair pair : desires) {
            ResourceUsage r2 = ((UnitAction)pair.m_b).resourceUsage((Unit)pair.m_a, pgs);
            if (!pa.consistentWith(r2, gs)) continue;
            pa.addUnitAction((Unit)pair.m_a, (UnitAction)pair.m_b);
            pa.getResourceUsage().merge(r2);
        }
        pa.fillWithNones(gs, player, 1);
        return pa;
    }

    public AbstractAction getAbstractAction(Unit u) {
        return this.actions.get(u);
    }

    public void move(Unit u, int x, int y) {
        this.actions.put(u, new Move(u, x, y, this.pf));
    }

    public void train(Unit u, UnitType unit_type) {
        this.actions.put(u, new Train(u, unit_type));
    }

    public void build(Unit u, UnitType unit_type, int x, int y) {
        this.actions.put(u, new Build(u, unit_type, x, y, this.pf));
    }

    public void harvest(Unit u, Unit target, Unit base) {
        this.actions.put(u, new Harvest(u, target, base, this.pf));
    }

    public void attack(Unit u, Unit target) {
        this.actions.put(u, new Attack(u, target, this.pf));
    }

    public void idle(Unit u) {
        this.actions.put(u, new Idle(u));
    }

    public int findBuildingPosition(List<Integer> reserved, int desiredX, int desiredY, Player p, PhysicalGameState pgs) {
        boolean[][] free = pgs.getAllFree();
        for (int l = 1; l < Math.max(pgs.getHeight(), pgs.getWidth()); ++l) {
            block7: for (int side = 0; side < 4; ++side) {
                switch (side) {
                    case 0: {
                        int pos;
                        int x;
                        int dx;
                        int y = desiredY - l;
                        if (y < 0) continue block7;
                        for (dx = -l; dx <= l; ++dx) {
                            x = desiredX + dx;
                            if (x < 0 || x >= pgs.getWidth() || reserved.contains(pos = x + y * pgs.getWidth()) || !free[x][y]) continue;
                            return pos;
                        }
                        continue block7;
                    }
                    case 1: {
                        int dy;
                        int pos;
                        int y;
                        int x = desiredX + l;
                        if (x >= pgs.getWidth()) continue block7;
                        for (dy = -l; dy <= l; ++dy) {
                            y = desiredY + dy;
                            if (y < 0 || y >= pgs.getHeight() || reserved.contains(pos = x + y * pgs.getWidth()) || !free[x][y]) continue;
                            return pos;
                        }
                        continue block7;
                    }
                    case 2: {
                        int pos;
                        int x;
                        int dx;
                        int y = desiredY + l;
                        if (y >= pgs.getHeight()) continue block7;
                        for (dx = -l; dx <= l; ++dx) {
                            x = desiredX + dx;
                            if (x < 0 || x >= pgs.getWidth() || reserved.contains(pos = x + y * pgs.getWidth()) || !free[x][y]) continue;
                            return pos;
                        }
                        continue block7;
                    }
                    case 3: {
                        int dy;
                        int pos;
                        int y;
                        int x = desiredX - l;
                        if (x < 0) continue block7;
                        for (dy = -l; dy <= l; ++dy) {
                            y = desiredY + dy;
                            if (y < 0 || y >= pgs.getHeight() || reserved.contains(pos = x + y * pgs.getWidth()) || !free[x][y]) continue;
                            return pos;
                        }
                        continue block7;
                    }
                }
            }
        }
        return -1;
    }

    public boolean buildIfNotAlreadyBuilding(Unit u, UnitType type, int desiredX, int desiredY, List<Integer> reservedPositions, Player p, PhysicalGameState pgs) {
        AbstractAction action = this.getAbstractAction(u);
        if (!(action instanceof Build) || ((Build)action).type != type) {
            int pos = this.findBuildingPosition(reservedPositions, desiredX, desiredY, p, pgs);
            this.build(u, type, pos % pgs.getWidth(), pos / pgs.getWidth());
            reservedPositions.add(pos);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.pf + ")";
    }

    public PathFinding getPathFinding() {
        return this.pf;
    }

    public void setPathFinding(PathFinding a_pf) {
        this.pf = a_pf;
    }
}

