/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.XMLWriter;

public class Attack
extends AbstractAction {
    Unit target;
    PathFinding pf;

    public Attack(Unit u, Unit a_target, PathFinding a_pf) {
        super(u);
        this.target = a_target;
        this.pf = a_pf;
    }

    @Override
    public boolean completed(GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        return !pgs.getUnits().contains(this.target);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attack)) {
            return false;
        }
        Attack a = (Attack)o;
        return this.target.getID() == a.target.getID() && this.pf.getClass() == a.pf.getClass();
    }

    @Override
    public void toxml(XMLWriter w) {
        w.tagWithAttributes("Attack", "unitID=\"" + this.unit.getID() + "\" target=\"" + this.target.getID() + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\"");
        w.tag("/Attack");
    }

    @Override
    public UnitAction execute(GameState gs, ResourceUsage ru) {
        int dy;
        int dx = this.target.getX() - this.unit.getX();
        double d = Math.sqrt(dx * dx + (dy = this.target.getY() - this.unit.getY()) * dy);
        if (d <= (double)this.unit.getAttackRange()) {
            return new UnitAction(5, this.target.getX(), this.target.getY());
        }
        UnitAction move = this.pf.findPathToPositionInRange(this.unit, this.target.getX() + this.target.getY() * gs.getPhysicalGameState().getWidth(), this.unit.getAttackRange(), gs, ru);
        if (move != null && gs.isUnitActionAllowed(this.unit, move)) {
            return move;
        }
        return null;
    }
}

