/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.EconomyMilitaryRush;
import ai.abstraction.Harvest;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class EMRDeterministico
extends AbstractionLayerAI {
    Random r = new Random();
    protected UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;
    UnitType barracksType;
    UnitType rangedType;
    UnitType lightType;
    UnitType heavyType;
    int nWorkerBase = 6;

    public EMRDeterministico(UnitTypeTable a_utt) {
        this(a_utt, new AStarPathFinding());
    }

    public EMRDeterministico(UnitTypeTable a_utt, PathFinding a_pf) {
        super(a_pf);
        this.reset(a_utt);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(UnitTypeTable a_utt) {
        this.utt = a_utt;
        this.workerType = this.utt.getUnitType("Worker");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.rangedType = this.utt.getUnitType("Ranged");
        this.lightType = this.utt.getUnitType("Light");
        this.heavyType = this.utt.getUnitType("Heavy");
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Player p = gs.getPlayer(player);
        PlayerAction pa = new PlayerAction();
        for (Unit u : pgs.getUnits()) {
            if (u.getType() != this.baseType || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.baseBehavior(u, p, pgs);
        }
        for (Unit u : pgs.getUnits()) {
            if (u.getType() != this.barracksType || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.barracksBehavior(u, p, pgs);
        }
        ArrayList<Unit> workers = new ArrayList<Unit>();
        for (Unit u : pgs.getUnits()) {
            if (!u.getType().canHarvest || u.getPlayer() != player || u.getType() != this.workerType) continue;
            workers.add(u);
        }
        this.workersBehavior(workers, p, pgs);
        for (Unit u : pgs.getUnits()) {
            if (!u.getType().canAttack || u.getType().canHarvest || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.meleeUnitBehavior(u, p, gs);
        }
        return this.translateActions(player, gs);
    }

    @Override
    public AI clone() {
        return new EconomyMilitaryRush(this.utt, this.pf);
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("PathFinding", PathFinding.class, new AStarPathFinding()));
        return parameters;
    }

    public void baseBehavior(Unit u, Player p, PhysicalGameState pgs) {
        int nworkers = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() != this.workerType || u2.getPlayer() != p.getID()) continue;
            ++nworkers;
        }
        int nBases = 0;
        int nBarracks = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() == this.baseType && u2.getPlayer() == p.getID()) {
                ++nBases;
                continue;
            }
            if (u2.getType() != this.barracksType || u2.getPlayer() != p.getID()) continue;
            ++nBarracks;
        }
        int qtdWorkLim = nBarracks == 0 ? 4 : this.nWorkerBase * nBases;
        if (nworkers < qtdWorkLim && p.getResources() >= this.workerType.cost) {
            this.train(u, this.workerType);
        }
    }

    public void barracksBehavior(Unit u, Player p, PhysicalGameState pgs) {
        int nLight = 0;
        int nRanged = 0;
        int nHeavy = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() == this.lightType && u2.getPlayer() == p.getID()) {
                ++nLight;
            }
            if (u2.getType() == this.rangedType && u2.getPlayer() == p.getID()) {
                ++nRanged;
            }
            if (u2.getType() != this.heavyType || u2.getPlayer() != p.getID()) continue;
            ++nHeavy;
        }
        int sum = nLight + nHeavy + nRanged;
        if (sum % 3 == 0 && p.getResources() >= this.lightType.cost) {
            this.train(u, this.lightType);
        } else if (sum % 3 == 1 && p.getResources() >= this.rangedType.cost) {
            this.train(u, this.rangedType);
        } else if (sum % 3 == 2 && p.getResources() >= this.heavyType.cost) {
            this.train(u, this.heavyType);
        }
    }

    public void meleeUnitBehavior(Unit u, Player p, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit closestEnemy = null;
        int closestDistance = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getPlayer() < 0 || u2.getPlayer() == p.getID()) continue;
            int d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
            if (closestEnemy != null && d >= closestDistance) continue;
            closestEnemy = u2;
            closestDistance = d;
        }
        if (closestEnemy != null) {
            this.attack(u, closestEnemy);
        }
    }

    public void workersBehavior(List<Unit> workers, Player p, PhysicalGameState pgs) {
        ArrayList<Unit> otherResources;
        Unit u;
        int nbases = 0;
        int nbarracks = 0;
        int resourcesUsed = 0;
        int nArmyUnits = 0;
        ArrayList<Unit> freeWorkers = new ArrayList<Unit>(workers);
        if (workers.isEmpty()) {
            return;
        }
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() == this.baseType && u2.getPlayer() == p.getID()) {
                ++nbases;
            }
            if (u2.getType() == this.barracksType && u2.getPlayer() == p.getID()) {
                ++nbarracks;
            }
            if (u2.getType() != this.lightType && u2.getType() != this.rangedType && u2.getType() != this.heavyType || u2.getPlayer() != p.getID()) continue;
            ++nArmyUnits;
        }
        ArrayList<Integer> reservedPositions = new ArrayList<Integer>();
        if (nbases == 0 && !freeWorkers.isEmpty() && p.getResources() >= this.baseType.cost + resourcesUsed) {
            u = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u, this.baseType, u.getX(), u.getY(), reservedPositions, p, pgs);
            resourcesUsed += this.baseType.cost;
        }
        if (nbarracks == 0 && !freeWorkers.isEmpty()) {
            if (p.getResources() >= this.barracksType.cost + resourcesUsed) {
                u = (Unit)freeWorkers.remove(0);
                this.buildIfNotAlreadyBuilding(u, this.barracksType, u.getX(), u.getY(), reservedPositions, p, pgs);
                resourcesUsed += this.barracksType.cost;
            }
        } else if (nbarracks > 0 && !freeWorkers.isEmpty() && nArmyUnits > 2 && p.getResources() >= this.barracksType.cost + resourcesUsed) {
            u = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u, this.barracksType, u.getX(), u.getY(), reservedPositions, p, pgs);
            resourcesUsed += this.barracksType.cost;
        }
        if (nbarracks != 0 && !(otherResources = new ArrayList<Unit>(this.otherResourcePoint(p, pgs))).isEmpty() && !freeWorkers.isEmpty() && p.getResources() >= this.baseType.cost + resourcesUsed) {
            Unit u2 = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u2, this.baseType, ((Unit)otherResources.get(0)).getX() + 1, ((Unit)otherResources.get(0)).getY() + 1, reservedPositions, p, pgs);
            resourcesUsed += this.baseType.cost;
        }
        this.harvestWorkers(freeWorkers, p, pgs);
    }

    protected List<Unit> otherResourcePoint(Player p, PhysicalGameState pgs) {
        List<Unit> bases = this.getMyBases(p, pgs);
        HashSet<Unit> myResources = new HashSet<Unit>();
        HashSet<Unit> otherResources = new HashSet<Unit>();
        for (Unit base : bases) {
            ArrayList<Unit> closestUnits = new ArrayList<Unit>(pgs.getUnitsAround(base.getX(), base.getY(), 10));
            for (Unit closestUnit : closestUnits) {
                if (!closestUnit.getType().isResource) continue;
                myResources.add(closestUnit);
            }
        }
        for (Unit u2 : pgs.getUnits()) {
            if (!u2.getType().isResource || myResources.contains(u2)) continue;
            otherResources.add(u2);
        }
        return new ArrayList<Unit>(otherResources);
    }

    protected List<Unit> getMyBases(Player p, PhysicalGameState pgs) {
        ArrayList<Unit> bases = new ArrayList<Unit>();
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() != this.baseType || u2.getPlayer() != p.getID()) continue;
            bases.add(u2);
        }
        return bases;
    }

    protected void harvestWorkers(List<Unit> freeWorkers, Player p, PhysicalGameState pgs) {
        for (Unit u : freeWorkers) {
            int d;
            Unit closestBase = null;
            Unit closestResource = null;
            int closestDistance = 0;
            for (Unit u2 : pgs.getUnits()) {
                if (!u2.getType().isResource) continue;
                d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
                if (closestResource != null && d >= closestDistance) continue;
                closestResource = u2;
                closestDistance = d;
            }
            closestDistance = 0;
            for (Unit u2 : pgs.getUnits()) {
                if (!u2.getType().isStockpile || u2.getPlayer() != p.getID()) continue;
                d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
                if (closestBase != null && d >= closestDistance) continue;
                closestBase = u2;
                closestDistance = d;
            }
            if (closestResource == null || closestBase == null) continue;
            AbstractAction aa = this.getAbstractAction(u);
            if (aa instanceof Harvest) {
                Harvest h_aa = (Harvest)aa;
                if (h_aa.getTarget() == closestResource && h_aa.getBase() == closestBase) continue;
                this.harvest(u, closestResource, closestBase);
                continue;
            }
            this.harvest(u, closestResource, closestBase);
        }
    }
}

