/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.Harvest;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class EconomyRush
extends AbstractionLayerAI {
    Random r = new Random();
    protected UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;
    UnitType barracksType;
    UnitType rangedType;
    UnitType lightType;
    UnitType heavyType;
    int nWorkerBase = 4;
    int resourcesUsed;

    public EconomyRush(UnitTypeTable a_utt) {
        this(a_utt, new AStarPathFinding());
    }

    public EconomyRush(UnitTypeTable a_utt, PathFinding a_pf) {
        super(a_pf);
        this.reset(a_utt);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(UnitTypeTable a_utt) {
        this.utt = a_utt;
        this.workerType = this.utt.getUnitType("Worker");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.rangedType = this.utt.getUnitType("Ranged");
        this.lightType = this.utt.getUnitType("Light");
        this.heavyType = this.utt.getUnitType("Heavy");
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Player p = gs.getPlayer(player);
        PlayerAction pa = new PlayerAction();
        this.resourcesUsed = gs.getResourceUsage().getResourcesUsed(player);
        for (Unit u : pgs.getUnits()) {
            if (u.getType() != this.baseType || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.baseBehavior(u, p, pgs);
        }
        for (Unit u : pgs.getUnits()) {
            if (u.getType() != this.barracksType || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.barracksBehavior(u, p, pgs);
        }
        ArrayList<Unit> workers = new ArrayList<Unit>();
        for (Unit u : pgs.getUnits()) {
            if (!u.getType().canHarvest || u.getPlayer() != player || u.getType() != this.workerType) continue;
            workers.add(u);
        }
        this.workersBehavior(workers, p, pgs);
        for (Unit u : pgs.getUnits()) {
            if (!u.getType().canAttack || u.getType().canHarvest || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.meleeUnitBehavior(u, p, gs);
        }
        return this.translateActions(player, gs);
    }

    @Override
    public AI clone() {
        return new EconomyRush(this.utt, this.pf);
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("PathFinding", PathFinding.class, new AStarPathFinding()));
        return parameters;
    }

    public void baseBehavior(Unit u, Player p, PhysicalGameState pgs) {
        int nworkers = 0;
        for (Unit unit : pgs.getUnits()) {
            if (unit.getType() != this.workerType || unit.getPlayer() != p.getID()) continue;
            ++nworkers;
        }
        int nBases = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() != this.baseType || u2.getPlayer() != p.getID()) continue;
            ++nBases;
        }
        int n = this.nWorkerBase + nBases;
        if (nworkers < n && p.getResources() >= this.workerType.cost + this.resourcesUsed) {
            this.train(u, this.workerType);
            this.resourcesUsed += this.workerType.cost;
        }
    }

    public void barracksBehavior(Unit u, Player p, PhysicalGameState pgs) {
        int nLight = 0;
        int nRanged = 0;
        int nHeavy = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() == this.lightType && u.getPlayer() == p.getID()) {
                ++nLight;
            }
            if (u2.getType() == this.rangedType && u.getPlayer() == p.getID()) {
                ++nRanged;
            }
            if (u2.getType() != this.heavyType || u.getPlayer() != p.getID()) continue;
            ++nHeavy;
        }
        if (nLight == 0 && p.getResources() >= this.lightType.cost + this.resourcesUsed) {
            this.train(u, this.lightType);
            this.resourcesUsed += this.lightType.cost;
        } else if (nRanged == 0 && p.getResources() >= this.rangedType.cost + this.resourcesUsed) {
            this.train(u, this.rangedType);
            this.resourcesUsed += this.rangedType.cost;
        } else if (nHeavy == 0 && p.getResources() >= this.heavyType.cost + this.resourcesUsed) {
            this.train(u, this.heavyType);
            this.resourcesUsed += this.heavyType.cost;
        }
        if (p.getResources() >= this.baseType.cost && nLight != 0 && nRanged != 0 && nHeavy != 0) {
            int number = this.r.nextInt(3);
            switch (number) {
                case 0: {
                    if (p.getResources() < this.baseType.cost + this.lightType.cost) break;
                    this.train(u, this.lightType);
                    this.resourcesUsed += this.lightType.cost;
                    break;
                }
                case 1: {
                    if (p.getResources() < this.baseType.cost + this.rangedType.cost) break;
                    this.train(u, this.rangedType);
                    this.resourcesUsed += this.rangedType.cost;
                    break;
                }
                case 2: {
                    if (p.getResources() < this.baseType.cost + this.heavyType.cost) break;
                    this.train(u, this.heavyType);
                    this.resourcesUsed += this.heavyType.cost;
                }
            }
        }
    }

    public void meleeUnitBehavior(Unit u, Player p, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit closestEnemy = null;
        int closestDistance = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getPlayer() < 0 || u2.getPlayer() == p.getID()) continue;
            int d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
            if (closestEnemy != null && d >= closestDistance) continue;
            closestEnemy = u2;
            closestDistance = d;
        }
        if (closestEnemy != null) {
            this.attack(u, closestEnemy);
        }
    }

    public void workersBehavior(List<Unit> workers, Player p, PhysicalGameState pgs) {
        ArrayList<Unit> otherResources;
        Unit u;
        int nbases = 0;
        int nbarracks = 0;
        ArrayList<Unit> freeWorkers = new ArrayList<Unit>(workers);
        if (workers.isEmpty()) {
            return;
        }
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() == this.baseType && u2.getPlayer() == p.getID()) {
                ++nbases;
            }
            if (u2.getType() != this.barracksType || u2.getPlayer() != p.getID()) continue;
            ++nbarracks;
        }
        ArrayList<Integer> reservedPositions = new ArrayList<Integer>();
        if (nbases == 0 && !freeWorkers.isEmpty() && p.getResources() >= this.baseType.cost + this.resourcesUsed) {
            u = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u, this.baseType, u.getX(), u.getY(), reservedPositions, p, pgs);
            this.resourcesUsed += this.baseType.cost;
        }
        if (nbarracks == 0 && !freeWorkers.isEmpty() && p.getResources() >= this.barracksType.cost + this.resourcesUsed) {
            u = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u, this.barracksType, u.getX(), u.getY(), reservedPositions, p, pgs);
            this.resourcesUsed += this.barracksType.cost;
        }
        if (nbarracks != 0 && !(otherResources = new ArrayList<Unit>(this.otherResourcePoint(p, pgs))).isEmpty() && !freeWorkers.isEmpty() && p.getResources() >= this.baseType.cost + this.resourcesUsed) {
            Unit u2 = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u2, this.baseType, ((Unit)otherResources.get(0)).getX() - 1, ((Unit)otherResources.get(0)).getY() - 1, reservedPositions, p, pgs);
            this.resourcesUsed += this.baseType.cost;
        }
        this.harvestWorkers(freeWorkers, p, pgs);
    }

    protected List<Unit> otherResourcePoint(Player p, PhysicalGameState pgs) {
        List<Unit> bases = this.getMyBases(p, pgs);
        HashSet<Unit> myResources = new HashSet<Unit>();
        HashSet<Unit> otherResources = new HashSet<Unit>();
        for (Unit base : bases) {
            ArrayList<Unit> closestUnits = new ArrayList<Unit>(pgs.getUnitsAround(base.getX(), base.getY(), 10));
            for (Unit closestUnit : closestUnits) {
                if (!closestUnit.getType().isResource) continue;
                myResources.add(closestUnit);
            }
        }
        for (Unit u2 : pgs.getUnits()) {
            if (!u2.getType().isResource || myResources.contains(u2)) continue;
            otherResources.add(u2);
        }
        if (!bases.isEmpty()) {
            return this.getOrderedResources(new ArrayList<Unit>(otherResources), bases.get(0));
        }
        return new ArrayList<Unit>(otherResources);
    }

    protected List<Unit> getOrderedResources(List<Unit> resources, Unit base) {
        ArrayList<Unit> resReturn = new ArrayList<Unit>();
        HashMap<Integer, ArrayList> map = new HashMap<Integer, ArrayList>();
        for (Unit res : resources) {
            ArrayList nResourc;
            int d = Math.abs(res.getX() - base.getX()) + Math.abs(res.getY() - base.getY());
            if (map.containsKey(d)) {
                nResourc = (ArrayList)map.get(d);
                nResourc.add(res);
                continue;
            }
            nResourc = new ArrayList();
            nResourc.add(res);
            map.put(d, nResourc);
        }
        ArrayList keysOrdered = new ArrayList(map.keySet());
        Collections.sort(keysOrdered);
        for (Integer key : keysOrdered) {
            resReturn.addAll((Collection)map.get(key));
        }
        return resReturn;
    }

    protected List<Unit> getMyBases(Player p, PhysicalGameState pgs) {
        ArrayList<Unit> bases = new ArrayList<Unit>();
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() != this.baseType || u2.getPlayer() != p.getID()) continue;
            bases.add(u2);
        }
        return bases;
    }

    protected void harvestWorkers(List<Unit> freeWorkers, Player p, PhysicalGameState pgs) {
        for (Unit u : freeWorkers) {
            int d;
            Unit closestBase = null;
            Unit closestResource = null;
            int closestDistance = 0;
            for (Unit u2 : pgs.getUnits()) {
                if (!u2.getType().isResource) continue;
                d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
                if (closestResource != null && d >= closestDistance) continue;
                closestResource = u2;
                closestDistance = d;
            }
            closestDistance = 0;
            for (Unit u2 : pgs.getUnits()) {
                if (!u2.getType().isStockpile || u2.getPlayer() != p.getID()) continue;
                d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
                if (closestBase != null && d >= closestDistance) continue;
                closestBase = u2;
                closestDistance = d;
            }
            if (closestResource == null || closestBase == null) continue;
            AbstractAction aa = this.getAbstractAction(u);
            if (aa instanceof Harvest) {
                Harvest h_aa = (Harvest)aa;
                if (h_aa.getTarget() == closestResource && h_aa.getBase() == closestBase) continue;
                this.harvest(u, closestResource, closestBase);
                continue;
            }
            this.harvest(u, closestResource, closestBase);
        }
    }
}

