/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.XMLWriter;

public class Harvest
extends AbstractAction {
    Unit target;
    Unit base;
    PathFinding pf;

    public Harvest(Unit u, Unit a_target, Unit a_base, PathFinding a_pf) {
        super(u);
        this.target = a_target;
        this.base = a_base;
        this.pf = a_pf;
    }

    public Unit getTarget() {
        return this.target;
    }

    public Unit getBase() {
        return this.base;
    }

    @Override
    public boolean completed(GameState gs) {
        if (this.unit.getResources() > 0) {
            return !gs.getPhysicalGameState().getUnits().contains(this.base);
        }
        return !gs.getPhysicalGameState().getUnits().contains(this.target);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Harvest)) {
            return false;
        }
        Harvest a = (Harvest)o;
        if (this.target == null && a.target != null) {
            return false;
        }
        if (this.target != null && a.target == null) {
            return false;
        }
        if (this.target != null && this.target.getID() != a.target.getID()) {
            return false;
        }
        if (this.base == null && a.base != null) {
            return false;
        }
        if (this.base != null && a.base == null) {
            return false;
        }
        if (this.base != null && this.base.getID() != a.base.getID()) {
            return false;
        }
        return this.pf.getClass() == a.pf.getClass();
    }

    @Override
    public void toxml(XMLWriter w) {
        w.tagWithAttributes("Harvest", "unitID=\"" + this.unit.getID() + "\" target=\"" + this.target.getID() + "\" base=\"" + this.base.getID() + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\"");
        w.tag("/Harvest");
    }

    @Override
    public UnitAction execute(GameState gs, ResourceUsage ru) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        if (this.unit.getResources() == 0) {
            if (this.target == null) {
                return null;
            }
            UnitAction move = this.pf.findPathToAdjacentPosition(this.unit, this.target.getX() + this.target.getY() * gs.getPhysicalGameState().getWidth(), gs, ru);
            if (move != null) {
                if (gs.isUnitActionAllowed(this.unit, move)) {
                    return move;
                }
                return null;
            }
            if (this.target.getX() == this.unit.getX() && this.target.getY() == this.unit.getY() - 1) {
                return new UnitAction(2, 0);
            }
            if (this.target.getX() == this.unit.getX() + 1 && this.target.getY() == this.unit.getY()) {
                return new UnitAction(2, 1);
            }
            if (this.target.getX() == this.unit.getX() && this.target.getY() == this.unit.getY() + 1) {
                return new UnitAction(2, 2);
            }
            if (this.target.getX() == this.unit.getX() - 1 && this.target.getY() == this.unit.getY()) {
                return new UnitAction(2, 3);
            }
        } else {
            if (this.base == null) {
                return null;
            }
            UnitAction move = this.pf.findPathToAdjacentPosition(this.unit, this.base.getX() + this.base.getY() * gs.getPhysicalGameState().getWidth(), gs, ru);
            if (move != null) {
                if (gs.isUnitActionAllowed(this.unit, move)) {
                    return move;
                }
                return null;
            }
            if (this.base.getX() == this.unit.getX() && this.base.getY() == this.unit.getY() - 1) {
                return new UnitAction(3, 0);
            }
            if (this.base.getX() == this.unit.getX() + 1 && this.base.getY() == this.unit.getY()) {
                return new UnitAction(3, 1);
            }
            if (this.base.getX() == this.unit.getX() && this.base.getY() == this.unit.getY() + 1) {
                return new UnitAction(3, 2);
            }
            if (this.base.getX() == this.unit.getX() - 1 && this.base.getY() == this.unit.getY()) {
                return new UnitAction(3, 3);
            }
        }
        return null;
    }
}

