/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.XMLWriter;

public class Idle
extends AbstractAction {
    public Idle(Unit u) {
        super(u);
    }

    @Override
    public boolean completed(GameState gs) {
        return false;
    }

    public boolean equals(Object o) {
        return o instanceof Idle;
    }

    @Override
    public void toxml(XMLWriter w) {
        w.tagWithAttributes("Idle", "unitID=\"" + this.unit.getID() + "\"");
        w.tag("/Idle");
    }

    @Override
    public UnitAction execute(GameState gs, ResourceUsage ru) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        if (!this.unit.getType().canAttack) {
            return null;
        }
        for (Unit target : pgs.getUnits()) {
            int dy;
            int dx;
            double d;
            if (target.getPlayer() == -1 || target.getPlayer() == this.unit.getPlayer() || !((d = Math.sqrt((dx = target.getX() - this.unit.getX()) * dx + (dy = target.getY() - this.unit.getY()) * dy)) <= (double)this.unit.getAttackRange())) continue;
            return new UnitAction(5, target.getX(), target.getY());
        }
        return null;
    }
}

