/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.Harvest;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class LightRush
extends AbstractionLayerAI {
    Random r = new Random();
    protected UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;
    UnitType barracksType;
    UnitType lightType;

    public LightRush(UnitTypeTable a_utt) {
        this(a_utt, new AStarPathFinding());
    }

    public LightRush(UnitTypeTable a_utt, PathFinding a_pf) {
        super(a_pf);
        this.reset(a_utt);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(UnitTypeTable a_utt) {
        this.utt = a_utt;
        this.workerType = this.utt.getUnitType("Worker");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.lightType = this.utt.getUnitType("Light");
    }

    @Override
    public AI clone() {
        return new LightRush(this.utt, this.pf);
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Player p = gs.getPlayer(player);
        for (Unit u : pgs.getUnits()) {
            if (u.getType() != this.baseType || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.baseBehavior(u, p, pgs);
        }
        for (Unit u : pgs.getUnits()) {
            if (u.getType() != this.barracksType || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.barracksBehavior(u, p, pgs);
        }
        for (Unit u : pgs.getUnits()) {
            if (!u.getType().canAttack || u.getType().canHarvest || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.meleeUnitBehavior(u, p, gs);
        }
        LinkedList<Unit> workers = new LinkedList<Unit>();
        for (Unit u : pgs.getUnits()) {
            if (!u.getType().canHarvest || u.getPlayer() != player) continue;
            workers.add(u);
        }
        this.workersBehavior(workers, p, gs);
        return this.translateActions(player, gs);
    }

    public void baseBehavior(Unit u, Player p, PhysicalGameState pgs) {
        int nworkers = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() != this.workerType || u2.getPlayer() != p.getID()) continue;
            ++nworkers;
        }
        if (nworkers < 1 && p.getResources() >= this.workerType.cost) {
            this.train(u, this.workerType);
        }
    }

    public void barracksBehavior(Unit u, Player p, PhysicalGameState pgs) {
        if (p.getResources() >= this.lightType.cost) {
            this.train(u, this.lightType);
        }
    }

    public void meleeUnitBehavior(Unit u, Player p, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit closestEnemy = null;
        int closestDistance = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getPlayer() < 0 || u2.getPlayer() == p.getID()) continue;
            int d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
            if (closestEnemy != null && d >= closestDistance) continue;
            closestEnemy = u2;
            closestDistance = d;
        }
        if (closestEnemy != null) {
            this.attack(u, closestEnemy);
        }
    }

    public void workersBehavior(List<Unit> workers, Player p, GameState gs) {
        Unit u;
        PhysicalGameState pgs = gs.getPhysicalGameState();
        int nbases = 0;
        int nbarracks = 0;
        int resourcesUsed = 0;
        LinkedList<Unit> freeWorkers = new LinkedList<Unit>(workers);
        if (workers.isEmpty()) {
            return;
        }
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() == this.baseType && u2.getPlayer() == p.getID()) {
                ++nbases;
            }
            if (u2.getType() != this.barracksType || u2.getPlayer() != p.getID()) continue;
            ++nbarracks;
        }
        LinkedList<Integer> reservedPositions = new LinkedList<Integer>();
        if (nbases == 0 && !freeWorkers.isEmpty() && p.getResources() >= this.baseType.cost + resourcesUsed) {
            u = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u, this.baseType, u.getX(), u.getY(), reservedPositions, p, pgs);
            resourcesUsed += this.baseType.cost;
        }
        if (nbarracks == 0 && p.getResources() >= this.barracksType.cost + resourcesUsed && !freeWorkers.isEmpty()) {
            u = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u, this.barracksType, u.getX(), u.getY(), reservedPositions, p, pgs);
            resourcesUsed += this.barracksType.cost;
        }
        LinkedList<Unit> stillFreeWorkers = new LinkedList<Unit>();
        for (Unit u2 : freeWorkers) {
            AbstractAction aa;
            int d;
            Unit closestBase = null;
            Unit closestResource = null;
            int closestDistance = 0;
            for (Unit u22 : pgs.getUnits()) {
                if (!u22.getType().isResource) continue;
                d = Math.abs(u22.getX() - u2.getX()) + Math.abs(u22.getY() - u2.getY());
                if (closestResource != null && d >= closestDistance) continue;
                closestResource = u22;
                closestDistance = d;
            }
            closestDistance = 0;
            for (Unit u22 : pgs.getUnits()) {
                if (!u22.getType().isStockpile || u22.getPlayer() != p.getID()) continue;
                d = Math.abs(u22.getX() - u2.getX()) + Math.abs(u22.getY() - u2.getY());
                if (closestBase != null && d >= closestDistance) continue;
                closestBase = u22;
                closestDistance = d;
            }
            boolean workerStillFree = true;
            if (u2.getResources() > 0) {
                if (closestBase != null) {
                    aa = this.getAbstractAction(u2);
                    if (aa instanceof Harvest) {
                        Harvest h_aa = (Harvest)aa;
                        if (h_aa.base != closestBase) {
                            this.harvest(u2, null, closestBase);
                        }
                    } else {
                        this.harvest(u2, null, closestBase);
                    }
                    workerStillFree = false;
                }
            } else if (closestResource != null && closestBase != null) {
                aa = this.getAbstractAction(u2);
                if (aa instanceof Harvest) {
                    Harvest h_aa = (Harvest)aa;
                    if (h_aa.target != closestResource || h_aa.base != closestBase) {
                        this.harvest(u2, closestResource, closestBase);
                    }
                } else {
                    this.harvest(u2, closestResource, closestBase);
                }
                workerStillFree = false;
            }
            if (!workerStillFree) continue;
            stillFreeWorkers.add(u2);
        }
        for (Unit u2 : stillFreeWorkers) {
            this.meleeUnitBehavior(u2, p, gs);
        }
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("PathFinding", PathFinding.class, new AStarPathFinding()));
        return parameters;
    }
}

