/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.XMLWriter;

public class Move
extends AbstractAction {
    int x;
    int y;
    PathFinding pf;

    public Move(Unit u, int a_x, int a_y, PathFinding a_pf) {
        super(u);
        this.x = a_x;
        this.y = a_y;
        this.pf = a_pf;
    }

    @Override
    public boolean completed(GameState gs) {
        return this.unit.getX() == this.x && this.unit.getY() == this.y;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Move)) {
            return false;
        }
        Move a = (Move)o;
        return this.x == a.x && this.y == a.y && this.pf.getClass() == a.pf.getClass();
    }

    @Override
    public void toxml(XMLWriter w) {
        w.tagWithAttributes("Move", "unitID=\"" + this.unit.getID() + "\" x=\"" + this.x + "\" y=\"" + this.y + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\"");
        w.tag("/Move");
    }

    @Override
    public UnitAction execute(GameState gs, ResourceUsage ru) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        UnitAction move = this.pf.findPath(this.unit, this.x + this.y * pgs.getWidth(), gs, ru);
        if (move != null && gs.isUnitActionAllowed(this.unit, move)) {
            return move;
        }
        return null;
    }
}

