/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import util.XMLWriter;

public class Train
extends AbstractAction {
    UnitType type;
    boolean completed = false;

    public Train(Unit u, UnitType a_type) {
        super(u);
        this.type = a_type;
    }

    @Override
    public boolean completed(GameState pgs) {
        return this.completed;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Train)) {
            return false;
        }
        Train a = (Train)o;
        return this.type == a.type;
    }

    @Override
    public void toxml(XMLWriter w) {
        w.tagWithAttributes("Train", "unitID=\"" + this.unit.getID() + "\" type=\"" + this.type.name + "\"");
        w.tag("/Train");
    }

    @Override
    public UnitAction execute(GameState gs, ResourceUsage ru) {
        UnitAction ua;
        int score;
        PhysicalGameState pgs = gs.getPhysicalGameState();
        int x = this.unit.getX();
        int y = this.unit.getY();
        int best_direction = -1;
        int best_score = -1;
        if (y > 0 && gs.free(x, y - 1) && ((score = this.score(x, y - 1, this.type, this.unit.getPlayer(), pgs)) > best_score || best_direction == -1)) {
            best_score = score;
            best_direction = 0;
        }
        if (x < pgs.getWidth() - 1 && gs.free(x + 1, y) && ((score = this.score(x + 1, y, this.type, this.unit.getPlayer(), pgs)) > best_score || best_direction == -1)) {
            best_score = score;
            best_direction = 1;
        }
        if (y < pgs.getHeight() - 1 && gs.free(x, y + 1) && ((score = this.score(x, y + 1, this.type, this.unit.getPlayer(), pgs)) > best_score || best_direction == -1)) {
            best_score = score;
            best_direction = 2;
        }
        if (x > 0 && gs.free(x - 1, y) && ((score = this.score(x - 1, y, this.type, this.unit.getPlayer(), pgs)) > best_score || best_direction == -1)) {
            best_score = score;
            best_direction = 3;
        }
        this.completed = true;
        if (best_direction != -1 && gs.isUnitActionAllowed(this.unit, ua = new UnitAction(4, best_direction, this.type))) {
            return ua;
        }
        return null;
    }

    public int score(int x, int y, UnitType type, int player, PhysicalGameState pgs) {
        int distance = 0;
        boolean first = true;
        if (type.canHarvest) {
            for (Unit u : pgs.getUnits()) {
                if (!u.getType().isResource) continue;
                int d = Math.abs(u.getX() - x) + Math.abs(u.getY() - y);
                if (!first && d >= distance) continue;
                distance = d;
                first = false;
            }
        } else {
            for (Unit u : pgs.getUnits()) {
                if (u.getPlayer() < 0 || u.getPlayer() == player) continue;
                int d = Math.abs(u.getX() - x) + Math.abs(u.getY() - y);
                if (!first && d >= distance) continue;
                distance = d;
                first = false;
            }
        }
        return -distance;
    }
}

