/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.Harvest;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class WorkerDefense
extends AbstractionLayerAI {
    Random r = new Random();
    protected UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;
    UnitType barracks;

    public WorkerDefense(UnitTypeTable a_utt) {
        this(a_utt, new AStarPathFinding());
    }

    public WorkerDefense(UnitTypeTable a_utt, PathFinding a_pf) {
        super(a_pf);
        this.reset(a_utt);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(UnitTypeTable a_utt) {
        this.utt = a_utt;
        if (this.utt != null) {
            this.workerType = this.utt.getUnitType("Worker");
            this.baseType = this.utt.getUnitType("Base");
            this.barracks = this.utt.getUnitType("Barracks");
        }
    }

    @Override
    public AI clone() {
        return new WorkerDefense(this.utt, this.pf);
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Player p = gs.getPlayer(player);
        PlayerAction pa = new PlayerAction();
        for (Unit u : pgs.getUnits()) {
            if (u.getType() != this.baseType || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.baseBehavior(u, p, pgs);
        }
        for (Unit u : pgs.getUnits()) {
            if (!u.getType().canAttack || u.getType().canHarvest || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.meleeUnitBehavior(u, p, gs);
        }
        LinkedList<Unit> workers = new LinkedList<Unit>();
        for (Unit u : pgs.getUnits()) {
            if (!u.getType().canHarvest || u.getPlayer() != player) continue;
            workers.add(u);
        }
        this.workersBehavior(workers, p, gs);
        return this.translateActions(player, gs);
    }

    public void baseBehavior(Unit u, Player p, PhysicalGameState pgs) {
        if (p.getResources() >= this.workerType.cost) {
            this.train(u, this.workerType);
        }
    }

    public void meleeUnitBehavior(Unit u, Player p, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit closestEnemy = null;
        Object closestMeleeEnemy = null;
        int closestDistance = 0;
        boolean enemyDistance = false;
        int mybase = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getPlayer() >= 0 && u2.getPlayer() != p.getID()) {
                int d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
                if (closestEnemy != null && d >= closestDistance) continue;
                closestEnemy = u2;
                closestDistance = d;
                continue;
            }
            if (u2.getPlayer() != p.getID() || u2.getType() != this.baseType) continue;
            mybase = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
        }
        if (closestEnemy != null && (closestDistance < pgs.getHeight() / 2 || mybase < pgs.getHeight() / 2)) {
            this.attack(u, closestEnemy);
        } else {
            this.attack(u, null);
        }
    }

    public void workersBehavior(List<Unit> workers, Player p, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        int nbases = 0;
        int resourcesUsed = 0;
        Unit harvestWorker = null;
        LinkedList<Unit> freeWorkers = new LinkedList<Unit>(workers);
        if (workers.isEmpty()) {
            return;
        }
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() != this.baseType || u2.getPlayer() != p.getID()) continue;
            ++nbases;
        }
        LinkedList<Integer> reservedPositions = new LinkedList<Integer>();
        if (nbases == 0 && !freeWorkers.isEmpty() && p.getResources() >= this.baseType.cost + resourcesUsed) {
            Unit u = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u, this.baseType, u.getX(), u.getY(), reservedPositions, p, pgs);
            resourcesUsed += this.baseType.cost;
        }
        if (freeWorkers.size() > 0) {
            harvestWorker = (Unit)freeWorkers.remove(0);
        }
        if (harvestWorker != null) {
            int d;
            Unit closestBase = null;
            Unit closestResource = null;
            int closestDistance = 0;
            for (Unit u2 : pgs.getUnits()) {
                if (!u2.getType().isResource) continue;
                d = Math.abs(u2.getX() - harvestWorker.getX()) + Math.abs(u2.getY() - harvestWorker.getY());
                if (closestResource != null && d >= closestDistance) continue;
                closestResource = u2;
                closestDistance = d;
            }
            closestDistance = 0;
            for (Unit u2 : pgs.getUnits()) {
                if (!u2.getType().isStockpile || u2.getPlayer() != p.getID()) continue;
                d = Math.abs(u2.getX() - harvestWorker.getX()) + Math.abs(u2.getY() - harvestWorker.getY());
                if (closestBase != null && d >= closestDistance) continue;
                closestBase = u2;
                closestDistance = d;
            }
            if (closestResource != null && closestBase != null) {
                AbstractAction aa = this.getAbstractAction(harvestWorker);
                if (aa instanceof Harvest) {
                    Harvest h_aa = (Harvest)aa;
                    if (h_aa.getTarget() != closestResource || h_aa.getBase() != closestBase) {
                        this.harvest(harvestWorker, closestResource, closestBase);
                    }
                } else {
                    this.harvest(harvestWorker, closestResource, closestBase);
                }
            }
        }
        for (Unit u : freeWorkers) {
            this.meleeUnitBehavior(u, p, gs);
        }
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("PathFinding", PathFinding.class, new AStarPathFinding()));
        return parameters;
    }
}

