/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.cRush;

import ai.abstraction.AbstractAction;
import ai.abstraction.Attack;
import ai.abstraction.pathfinding.PathFinding;
import java.util.List;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;
import util.XMLWriter;

public class CRanged_Tactic
extends AbstractAction {
    Unit target;
    PathFinding pf;
    Unit home;
    Unit enemyBase;
    UnitType workerType;
    UnitType rangedType;
    UnitType heavyType;
    UnitType baseType;
    UnitType barracksType;
    UnitType resourceType;
    UnitType lightType;
    UnitTypeTable utt;
    Player p;

    public CRanged_Tactic(Unit u, Unit a_target, Unit h, Unit eb, PathFinding a_pf, UnitTypeTable ut, Player pl) {
        super(u);
        this.target = a_target;
        this.pf = a_pf;
        this.home = h;
        this.utt = ut;
        this.p = pl;
        this.workerType = this.utt.getUnitType("Worker");
        this.rangedType = this.utt.getUnitType("Ranged");
        this.heavyType = this.utt.getUnitType("Heavy");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.resourceType = this.utt.getUnitType("Resource");
        this.lightType = this.utt.getUnitType("Light");
        this.enemyBase = eb;
    }

    @Override
    public boolean completed(GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        return !pgs.getUnits().contains(this.target);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attack)) {
            return false;
        }
        CRanged_Tactic a = (CRanged_Tactic)o;
        return this.target.getID() == a.target.getID() && this.pf.getClass() == a.pf.getClass();
    }

    @Override
    public void toxml(XMLWriter w) {
        w.tagWithAttributes("Attack", "unitID=\"" + this.getUnit().getID() + "\" target=\"" + this.target.getID() + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\"");
        w.tag("/Attack");
    }

    @Override
    public UnitAction execute(GameState gs, ResourceUsage ru) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit unit = this.getUnit();
        boolean timeToAttack = false;
        if (this.home == null) {
            this.home = unit;
        }
        if (this.enemyBase == null) {
            this.enemyBase = this.target;
        }
        double rd = 0.0;
        if (this.home != null) {
            rd = this.distance(unit, this.home);
        }
        double d = this.distance(unit, this.target);
        List<Unit> gameUnites = pgs.getUnits();
        int nEnemyBases = 0;
        int enemyAttackUnits = 0;
        int enemyWorkers = 0;
        int cutoffTime = 5000;
        if (pgs.getWidth() * pgs.getHeight() > 3000) {
            cutoffTime = 15000;
        }
        for (Unit u2 : gameUnites) {
            if (u2 != null && u2.getPlayer() != this.p.getID() && u2.getType() == this.baseType) {
                ++nEnemyBases;
            }
            if (u2 != null && u2.getPlayer() != this.p.getID() && (u2.getType() == this.rangedType || u2.getType() == this.heavyType || u2.getType() == this.lightType)) {
                ++enemyAttackUnits;
            }
            if (u2 == null || u2.getPlayer() == this.p.getID() || u2.getType() != this.workerType) continue;
            ++enemyWorkers;
        }
        if ((enemyWorkers < 2 * nEnemyBases || nEnemyBases == 0) && enemyAttackUnits == 0) {
            timeToAttack = true;
        }
        if (gs.getTime() > cutoffTime) {
            timeToAttack = true;
        }
        Unit ally = this.nearestRangedAlly(this.enemyBase, gameUnites, gs);
        double ad = 0.0;
        if (ally != null) {
            ad = this.distance(ally, this.target);
        }
        if (unit.getType() == this.workerType) {
            UnitAction move = null;
            if (d <= (double)unit.getAttackRange()) {
                return new UnitAction(5, this.target.getX(), this.target.getY());
            }
            if (timeToAttack) {
                move = this.pf.findPathToPositionInRange(unit, this.target.getX() + this.target.getY() * gs.getPhysicalGameState().getWidth(), unit.getAttackRange(), gs, ru);
            } else if (ally != null) {
                move = d > ad ? this.pf.findPathToPositionInRange(unit, this.target.getX() + this.target.getY() * gs.getPhysicalGameState().getWidth(), unit.getAttackRange(), gs, ru) : this.pf.findPathToPositionInRange(unit, ally.getX() + ally.getY() * gs.getPhysicalGameState().getWidth(), unit.getAttackRange(), gs, ru);
                if (move == null) {
                    move = this.pf.findPathToPositionInRange(unit, ally.getX() - 1 + ally.getY() * gs.getPhysicalGameState().getWidth(), unit.getAttackRange() + 1, gs, ru);
                }
                if (move == null) {
                    move = this.pf.findPathToPositionInRange(unit, this.target.getX() + this.target.getY() * gs.getPhysicalGameState().getWidth(), unit.getAttackRange(), gs, ru);
                }
            } else {
                move = this.pf.findPathToPositionInRange(unit, this.target.getX() + this.target.getY() * gs.getPhysicalGameState().getWidth(), unit.getAttackRange(), gs, ru);
            }
            if (move != null && gs.isUnitActionAllowed(unit, move)) {
                return move;
            }
            return null;
        }
        if (d <= (double)unit.getAttackRange()) {
            return new UnitAction(5, this.target.getX(), this.target.getY());
        }
        if (ally == null || ally.getID() == unit.getID()) {
            UnitAction move = null;
            if (timeToAttack && this.target.getType() == this.baseType) {
                move = this.pf.findPathToPositionInRange(unit, this.target.getX() + this.target.getY() * gs.getPhysicalGameState().getWidth(), unit.getAttackRange(), gs, ru);
            } else if (rd < 5.0 || this.distance(unit, this.enemyBase) > this.distance(this.home, this.enemyBase)) {
                move = this.pf.findPathToPositionInRange(unit, this.enemyBase.getX() + this.enemyBase.getY() * gs.getPhysicalGameState().getWidth(), unit.getAttackRange(), gs, ru);
            }
            if (move != null && gs.isUnitActionAllowed(unit, move)) {
                return move;
            }
            return null;
        }
        if (timeToAttack) {
            if (d <= (double)(unit.getAttackRange() - 1) && rd > 2.0 && unit.getMoveTime() < this.target.getMoveTime()) {
                UnitAction move = this.pf.findPathToPositionInRange(unit, this.home.getX() + this.home.getY() * gs.getPhysicalGameState().getWidth(), this.getUnit().getAttackRange(), gs, ru);
                if (move != null && gs.isUnitActionAllowed(unit, move)) {
                    return move;
                }
                return null;
            }
            if (d <= (double)unit.getAttackRange()) {
                return new UnitAction(5, this.target.getX(), this.target.getY());
            }
            UnitAction move = this.pf.findPathToPositionInRange(unit, this.target.getX() + this.target.getY() * gs.getPhysicalGameState().getWidth(), this.getUnit().getAttackRange(), gs, ru);
            if (move != null && gs.isUnitActionAllowed(unit, move)) {
                return move;
            }
            return null;
        }
        Unit atUp = pgs.getUnitAt(ally.getX(), ally.getY() - 1);
        Unit atUpLeft = pgs.getUnitAt(ally.getX() - 1, ally.getY() - 1);
        Unit atLeft = pgs.getUnitAt(ally.getX() - 1, ally.getY());
        Unit atDown = pgs.getUnitAt(ally.getX(), ally.getY() + 1);
        Unit atDownRight = pgs.getUnitAt(ally.getX() + 1, ally.getY() + 1);
        Unit atRight = pgs.getUnitAt(ally.getX() + 1, ally.getY());
        boolean positionFound = false;
        if (this.distanceWithoutUnits(ally.getX(), ally.getY() + 1, this.enemyBase.getX(), this.enemyBase.getY()) > this.distance(ally, this.enemyBase)) {
            while (!positionFound) {
                if (atDown != null && unit != atDown && atDownRight != null && unit != atDownRight && atRight != null && unit != atRight) {
                    ally = atRight;
                } else {
                    positionFound = true;
                }
                atDown = pgs.getUnitAt(ally.getX(), ally.getY() + 1);
                atDownRight = pgs.getUnitAt(ally.getX() + 1, ally.getY() + 1);
                atRight = pgs.getUnitAt(ally.getX() + 1, ally.getY());
                if (atDown != null && atDownRight != null && atRight != null) continue;
                positionFound = true;
            }
        } else {
            while (!positionFound) {
                if (atUp != null && unit != atUp && atUpLeft != null && unit != atUpLeft && atLeft != null && unit != atLeft) {
                    ally = atLeft;
                } else {
                    positionFound = true;
                }
                atUp = pgs.getUnitAt(ally.getX(), ally.getY() - 1);
                atUpLeft = pgs.getUnitAt(ally.getX() - 1, ally.getY() - 1);
                atLeft = pgs.getUnitAt(ally.getX() - 1, ally.getY());
                if (atUp != null && atUpLeft != null && atLeft != null) continue;
                positionFound = true;
            }
        }
        return this.squareMove(gs, ru, ally);
    }

    public double distance(Unit a, Unit b) {
        if (a == null || b == null) {
            return 0.0;
        }
        int dx = b.getX() - a.getX();
        int dy = b.getY() - a.getY();
        double toReturn = Math.sqrt(dx * dx + dy * dy);
        return toReturn;
    }

    public double distanceWithoutUnits(int xa, int ya, int xb, int yb) {
        int dx = xb - xa;
        int dy = yb - ya;
        double toReturn = Math.sqrt(dx * dx + dy * dy);
        return toReturn;
    }

    public UnitAction squareMove(GameState gs, ResourceUsage ru, Unit targetUnit) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit unit = this.getUnit();
        Unit ally = targetUnit;
        Unit atUp = pgs.getUnitAt(ally.getX(), ally.getY() - 1);
        Unit atUpLeft = pgs.getUnitAt(ally.getX() - 1, ally.getY() - 1);
        Unit atLeft = pgs.getUnitAt(ally.getX() - 1, ally.getY());
        Unit atDown = pgs.getUnitAt(ally.getX(), ally.getY() + 1);
        Unit atDownRight = pgs.getUnitAt(ally.getX() + 1, ally.getY() + 1);
        Unit atRight = pgs.getUnitAt(ally.getX() + 1, ally.getY());
        UnitAction moveToUp = this.pf.findPath(unit, ally.getX() + (ally.getY() - 1) * gs.getPhysicalGameState().getWidth(), gs, ru);
        UnitAction moveToUpLeft = this.pf.findPath(unit, ally.getX() - 1 + (ally.getY() - 1) * gs.getPhysicalGameState().getWidth(), gs, ru);
        UnitAction moveToLeft = this.pf.findPath(unit, ally.getX() - 1 + ally.getY() * gs.getPhysicalGameState().getWidth(), gs, ru);
        UnitAction moveToDown = this.pf.findPath(unit, ally.getX() + (ally.getY() + 1) * gs.getPhysicalGameState().getWidth(), gs, ru);
        UnitAction moveToDownRight = this.pf.findPath(unit, ally.getX() + 1 + (ally.getY() + 1) * gs.getPhysicalGameState().getWidth(), gs, ru);
        UnitAction moveToRight = this.pf.findPath(unit, ally.getX() + 1 + ally.getY() * gs.getPhysicalGameState().getWidth(), gs, ru);
        if (this.distanceWithoutUnits(ally.getX(), ally.getY() + 1, this.enemyBase.getX(), this.enemyBase.getY()) > this.distance(ally, this.enemyBase)) {
            UnitAction move = null;
            if (unit == atDown || unit == atDownRight || unit == atRight) {
                return null;
            }
            if (atDown == null) {
                move = moveToDown;
            } else if (atRight == null) {
                move = moveToRight;
            } else if (atDownRight == null) {
                move = moveToDownRight;
            }
            if (move != null && gs.isUnitActionAllowed(unit, move)) {
                return move;
            }
            return null;
        }
        UnitAction move = null;
        if (unit == atUp || unit == atUpLeft || unit == atLeft) {
            return null;
        }
        if (atUp == null) {
            move = moveToUp;
        } else if (atLeft == null) {
            move = moveToLeft;
        } else if (atUpLeft == null) {
            move = moveToUpLeft;
        }
        if (move != null && gs.isUnitActionAllowed(unit, move)) {
            return move;
        }
        return null;
    }

    public Unit farthestRangedAlly(Unit start, List<Unit> unites, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit farthestUnit = null;
        double farthestDistance = 0.0;
        for (Unit u2 : unites) {
            int dy;
            int dx;
            double d;
            if (u2.getType() != this.rangedType || u2.getPlayer() != this.p.getID() || this.home == null || !((d = Math.sqrt((dx = start.getX() - u2.getX()) * dx + (dy = start.getY() - u2.getY()) * dy)) > farthestDistance)) continue;
            farthestDistance = d;
            farthestUnit = u2;
        }
        return farthestUnit;
    }

    public Unit nearestRangedAlly(Unit start, List<Unit> unites, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit nearestUnit = null;
        double nearestDistance = -1.0;
        if (start != null) {
            for (Unit u2 : unites) {
                int dy;
                int dx;
                double d;
                if (u2 == null || u2.getPlayer() != this.p.getID() || u2.getType() != this.rangedType || !((d = Math.sqrt((dx = start.getX() - u2.getX()) * dx + (dy = start.getY() - u2.getY()) * dy)) < nearestDistance) && nearestDistance != -1.0) continue;
                nearestDistance = d;
                nearestUnit = u2;
            }
        }
        return nearestUnit;
    }
}

