/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.cRush;

import ai.abstraction.AbstractAction;
import ai.abstraction.AbstractionLayerAI;
import ai.abstraction.Harvest;
import ai.abstraction.cRush.RangedAttack;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class CRush_V1
extends AbstractionLayerAI {
    Random r = new Random();
    protected UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;
    UnitType barracksType;
    UnitType rangedType;
    UnitType heavyType;
    UnitType lightType;
    boolean buildingRacks = false;
    int resourcesUsed = 0;

    public CRush_V1(UnitTypeTable a_utt) {
        this(a_utt, new AStarPathFinding());
    }

    public CRush_V1(UnitTypeTable a_utt, PathFinding a_pf) {
        super(a_pf);
        this.reset(a_utt);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(UnitTypeTable a_utt) {
        this.utt = a_utt;
        this.workerType = this.utt.getUnitType("Worker");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.rangedType = this.utt.getUnitType("Ranged");
        this.lightType = this.utt.getUnitType("Light");
    }

    @Override
    public AI clone() {
        return new CRush_V1(this.utt, this.pf);
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Player p = gs.getPlayer(player);
        boolean isRush = false;
        if (pgs.getWidth() * pgs.getHeight() <= 144) {
            isRush = true;
        }
        LinkedList<Unit> workers = new LinkedList<Unit>();
        for (Unit u : pgs.getUnits()) {
            if (!u.getType().canHarvest || u.getPlayer() != player) continue;
            workers.add(u);
        }
        if (isRush) {
            this.rushWorkersBehavior(workers, p, pgs, gs);
        } else {
            this.workersBehavior(workers, p, pgs, gs);
        }
        for (Unit u : pgs.getUnits()) {
            if (u.getType() != this.baseType || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            if (isRush) {
                this.rushBaseBehavior(u, p, pgs);
                continue;
            }
            this.baseBehavior(u, p, pgs);
        }
        for (Unit u : pgs.getUnits()) {
            if (u.getType() != this.barracksType || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            this.barracksBehavior(u, p, pgs);
        }
        for (Unit u : pgs.getUnits()) {
            if (!u.getType().canAttack || u.getType().canHarvest || u.getPlayer() != player || gs.getActionAssignment(u) != null) continue;
            if (u.getType() == this.rangedType) {
                this.rangedUnitBehavior(u, p, gs);
                continue;
            }
            this.meleeUnitBehavior(u, p, gs);
        }
        return this.translateActions(player, gs);
    }

    public void baseBehavior(Unit u, Player p, PhysicalGameState pgs) {
        int nbases = 0;
        int nbarracks = 0;
        int nworkers = 0;
        int resources = p.getResources();
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() == this.workerType && u2.getPlayer() == p.getID()) {
                ++nworkers;
            }
            if (u2.getType() == this.barracksType && u2.getPlayer() == p.getID()) {
                ++nbarracks;
            }
            if (u2.getType() != this.baseType || u2.getPlayer() != p.getID()) continue;
            ++nbases;
        }
        if (nworkers < nbases + 1 && p.getResources() >= this.workerType.cost) {
            this.train(u, this.workerType);
        }
        if (this.resourcesUsed != this.barracksType.cost * nbarracks) {
            resources -= this.barracksType.cost;
        }
        if (this.buildingRacks && resources >= this.workerType.cost + this.rangedType.cost) {
            this.train(u, this.workerType);
        }
    }

    public void barracksBehavior(Unit u, Player p, PhysicalGameState pgs) {
        if (p.getResources() >= this.rangedType.cost) {
            this.train(u, this.rangedType);
        }
    }

    public void meleeUnitBehavior(Unit u, Player p, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit closestEnemy = null;
        int closestDistance = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getPlayer() < 0 || u2.getPlayer() == p.getID()) continue;
            int d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
            if (closestEnemy != null && d >= closestDistance) continue;
            closestEnemy = u2;
            closestDistance = d;
        }
        if (closestEnemy != null) {
            this.attack(u, closestEnemy);
        }
    }

    public void rangedUnitBehavior(Unit u, Player p, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit closestEnemy = null;
        Unit closestRacks = null;
        int closestDistance = 0;
        for (Unit u2 : pgs.getUnits()) {
            int d;
            if (u2.getPlayer() >= 0 && u2.getPlayer() != p.getID()) {
                d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
                if (closestEnemy == null || d < closestDistance) {
                    closestEnemy = u2;
                    closestDistance = d;
                }
            }
            if (u2.getType() != this.barracksType || u2.getPlayer() != p.getID()) continue;
            d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
            if (closestRacks != null && d >= closestDistance) continue;
            closestRacks = u2;
            closestDistance = d;
        }
        if (closestEnemy != null) {
            this.rangedAttack(u, closestEnemy, closestRacks);
        }
    }

    public void workersBehavior(List<Unit> workers, Player p, PhysicalGameState pgs, GameState gs) {
        int nbases = 0;
        int nbarracks = 0;
        int nworkers = 0;
        this.resourcesUsed = 0;
        LinkedList<Unit> freeWorkers = new LinkedList<Unit>();
        LinkedList<Unit> battleWorkers = new LinkedList<Unit>();
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() == this.baseType && u2.getPlayer() == p.getID()) {
                ++nbases;
            }
            if (u2.getType() == this.barracksType && u2.getPlayer() == p.getID()) {
                ++nbarracks;
            }
            if (u2.getType() != this.workerType || u2.getPlayer() != p.getID()) continue;
            ++nworkers;
        }
        if (workers.size() > nbases + 1) {
            for (int n = 0; n < nbases + 1; ++n) {
                freeWorkers.add(workers.get(0));
                workers.remove(0);
            }
            battleWorkers.addAll(workers);
        } else {
            freeWorkers.addAll(workers);
        }
        if (workers.isEmpty()) {
            return;
        }
        LinkedList<Integer> reservedPositions = new LinkedList<Integer>();
        if (nbases == 0 && !freeWorkers.isEmpty() && p.getResources() >= this.baseType.cost) {
            Unit u = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u, this.baseType, u.getX(), u.getY(), reservedPositions, p, pgs);
        }
        if (nbarracks == 0 && !freeWorkers.isEmpty() && nworkers > 1 && p.getResources() >= this.barracksType.cost) {
            int resources = p.getResources();
            Unit u = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u, this.barracksType, u.getX(), u.getY(), reservedPositions, p, pgs);
            this.resourcesUsed += this.barracksType.cost;
            this.buildingRacks = true;
        } else {
            this.resourcesUsed = this.barracksType.cost * nbarracks;
        }
        if (nbarracks > 1) {
            this.buildingRacks = true;
        }
        for (Unit u : battleWorkers) {
            this.meleeUnitBehavior(u, p, gs);
        }
        for (Unit u : freeWorkers) {
            int d;
            Unit closestBase = null;
            Unit closestResource = null;
            int closestDistance = 0;
            for (Unit u2 : pgs.getUnits()) {
                if (!u2.getType().isResource) continue;
                d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
                if (closestResource != null && d >= closestDistance) continue;
                closestResource = u2;
                closestDistance = d;
            }
            closestDistance = 0;
            for (Unit u2 : pgs.getUnits()) {
                if (!u2.getType().isStockpile || u2.getPlayer() != p.getID()) continue;
                d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
                if (closestBase != null && d >= closestDistance) continue;
                closestBase = u2;
                closestDistance = d;
            }
            if (closestResource == null || closestBase == null) continue;
            AbstractAction aa = this.getAbstractAction(u);
            if (aa instanceof Harvest) {
                Harvest h_aa = (Harvest)aa;
                if (h_aa.getTarget() == closestResource && h_aa.getBase() == closestBase) continue;
                this.harvest(u, closestResource, closestBase);
                continue;
            }
            this.harvest(u, closestResource, closestBase);
        }
    }

    public void rushBaseBehavior(Unit u, Player p, PhysicalGameState pgs) {
        if (p.getResources() >= this.workerType.cost) {
            this.train(u, this.workerType);
        }
    }

    public void rushWorkersBehavior(List<Unit> workers, Player p, PhysicalGameState pgs, GameState gs) {
        int nbases = 0;
        int nworkers = 0;
        this.resourcesUsed = 0;
        LinkedList<Unit> freeWorkers = new LinkedList<Unit>();
        LinkedList<Unit> battleWorkers = new LinkedList<Unit>();
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getType() == this.baseType && u2.getPlayer() == p.getID()) {
                ++nbases;
            }
            if (u2.getType() != this.workerType || u2.getPlayer() != p.getID()) continue;
            ++nworkers;
        }
        if (p.getResources() == 0) {
            battleWorkers.addAll(workers);
        } else if (workers.size() > nbases) {
            for (int n = 0; n < nbases; ++n) {
                freeWorkers.add(workers.get(0));
                workers.remove(0);
            }
            battleWorkers.addAll(workers);
        } else {
            freeWorkers.addAll(workers);
        }
        if (workers.isEmpty()) {
            return;
        }
        LinkedList<Integer> reservedPositions = new LinkedList<Integer>();
        if (nbases == 0 && !freeWorkers.isEmpty() && p.getResources() >= this.baseType.cost) {
            Unit u = (Unit)freeWorkers.remove(0);
            this.buildIfNotAlreadyBuilding(u, this.baseType, u.getX(), u.getY(), reservedPositions, p, pgs);
        }
        for (Unit u : battleWorkers) {
            this.meleeUnitBehavior(u, p, gs);
        }
        for (Unit u : freeWorkers) {
            int d;
            Unit closestBase = null;
            Unit closestResource = null;
            int closestDistance = 0;
            for (Unit u2 : pgs.getUnits()) {
                if (!u2.getType().isResource) continue;
                d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
                if (closestResource != null && d >= closestDistance) continue;
                closestResource = u2;
                closestDistance = d;
            }
            closestDistance = 0;
            for (Unit u2 : pgs.getUnits()) {
                if (!u2.getType().isStockpile || u2.getPlayer() != p.getID()) continue;
                d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
                if (closestBase != null && d >= closestDistance) continue;
                closestBase = u2;
                closestDistance = d;
            }
            if (closestResource == null || closestBase == null) continue;
            AbstractAction aa = this.getAbstractAction(u);
            if (aa instanceof Harvest) {
                Harvest h_aa = (Harvest)aa;
                if (h_aa.getTarget() == closestResource && h_aa.getBase() == closestBase) continue;
                this.harvest(u, closestResource, closestBase);
                continue;
            }
            this.harvest(u, closestResource, closestBase);
        }
    }

    public void rangedAttack(Unit u, Unit target, Unit racks) {
        this.actions.put(u, new RangedAttack(u, target, racks, this.pf));
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("PathFinding", PathFinding.class, new AStarPathFinding()));
        return parameters;
    }
}

