/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.cRush;

import ai.abstraction.AbstractAction;
import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import util.XMLWriter;

public class RangedAttack
extends AbstractAction {
    Unit target;
    PathFinding pf;
    Unit racks;
    UnitType workerType;
    UnitType rangedType;
    UnitType heavyType;

    public RangedAttack(Unit u, Unit a_target, Unit r, PathFinding a_pf) {
        super(u);
        this.target = a_target;
        this.pf = a_pf;
        this.racks = r;
    }

    @Override
    public boolean completed(GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        return !pgs.getUnits().contains(this.target);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RangedAttack)) {
            return false;
        }
        RangedAttack a = (RangedAttack)o;
        return this.target.getID() == a.target.getID() && this.pf.getClass() == a.pf.getClass() && this.racks.getID() == a.racks.getID();
    }

    @Override
    public void toxml(XMLWriter w) {
        w.tagWithAttributes("RangedAttack", "unitID=\"" + this.getUnit().getID() + "\" target=\"" + this.target.getID() + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\" racks=\"" + this.racks.getID() + "\"");
        w.tag("/RangedAttack");
    }

    @Override
    public UnitAction execute(GameState gs, ResourceUsage ru) {
        int dy;
        int dx;
        double d;
        int rdx = 0;
        int rdy = 0;
        double rd = 0.0;
        if (this.racks != null) {
            rdx = this.racks.getX() - this.getUnit().getX();
            rdy = this.racks.getY() - this.getUnit().getY();
            rd = Math.sqrt(rdx * rdx + rdy * rdy);
        }
        if ((d = Math.sqrt((dx = this.target.getX() - this.getUnit().getX()) * dx + (dy = this.target.getY() - this.getUnit().getY()) * dy)) <= (double)(this.getUnit().getAttackRange() - 1) && rd > 2.0 && this.getUnit().getMoveTime() < this.target.getMoveTime()) {
            UnitAction move = this.pf.findPathToPositionInRange(this.getUnit(), this.racks.getX() + this.racks.getY() * gs.getPhysicalGameState().getWidth(), this.getUnit().getAttackRange(), gs, ru);
            if (move != null && gs.isUnitActionAllowed(this.getUnit(), move)) {
                return move;
            }
            return null;
        }
        if (d <= (double)this.getUnit().getAttackRange()) {
            return new UnitAction(5, this.target.getX(), this.target.getY());
        }
        UnitAction move = this.pf.findPathToPositionInRange(this.getUnit(), this.target.getX() + this.target.getY() * gs.getPhysicalGameState().getWidth(), this.getUnit().getAttackRange(), gs, ru);
        if (move != null && gs.isUnitActionAllowed(this.getUnit(), move)) {
            return move;
        }
        return null;
    }
}

