/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.partialobservability;

import ai.abstraction.HeavyRush;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.core.AI;
import rts.GameState;
import rts.PartiallyObservableGameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.units.Unit;
import rts.units.UnitTypeTable;

public class POHeavyRush
extends HeavyRush {
    public POHeavyRush(UnitTypeTable a_utt) {
        this(a_utt, new AStarPathFinding());
    }

    public POHeavyRush(UnitTypeTable a_utt, PathFinding a_pf) {
        super(a_utt, a_pf);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public AI clone() {
        return new POHeavyRush(this.utt, this.pf);
    }

    @Override
    public void meleeUnitBehavior(Unit u, Player p, GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit closestEnemy = null;
        int closestDistance = 0;
        for (Unit u2 : pgs.getUnits()) {
            if (u2.getPlayer() < 0 || u2.getPlayer() == p.getID()) continue;
            int d = Math.abs(u2.getX() - u.getX()) + Math.abs(u2.getY() - u.getY());
            if (closestEnemy != null && d >= closestDistance) continue;
            closestEnemy = u2;
            closestDistance = d;
        }
        if (closestEnemy != null) {
            this.attack(u, closestEnemy);
        } else if (gs instanceof PartiallyObservableGameState) {
            PartiallyObservableGameState pogs = (PartiallyObservableGameState)gs;
            int closest_x = 0;
            int closest_y = 0;
            closestDistance = -1;
            for (int i = 0; i < pgs.getHeight(); ++i) {
                for (int j = 0; j < pgs.getWidth(); ++j) {
                    if (pogs.observable(j, i)) continue;
                    int d = (u.getX() - j) * (u.getX() - j) + (u.getY() - i) * (u.getY() - i);
                    if (closestDistance != -1 && d >= closestDistance) continue;
                    closest_x = j;
                    closest_y = i;
                    closestDistance = d;
                }
            }
            if (closestDistance != -1) {
                this.move(u, closest_x, closest_y);
            }
        }
    }
}

