/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.pathfinding;

import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;

public class AStarPathFinding
extends PathFinding {
    public static int iterations = 0;
    public static int accumlength = 0;
    Boolean[][] free;
    int[] closed;
    int[] open;
    int[] heuristic;
    int[] parents;
    int[] cost;
    int[] inOpenOrClosed;
    int openinsert = 0;

    @Override
    public UnitAction findPath(Unit start, int targetpos, GameState gs, ResourceUsage ru) {
        return this.findPathToPositionInRange(start, targetpos, 0, gs, ru);
    }

    @Override
    public UnitAction findPathToPositionInRange(Unit start, int targetpos, int range, GameState gs, ResourceUsage ru) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        int w = pgs.getWidth();
        int h = pgs.getHeight();
        if (this.free == null || this.free.length < w * h) {
            this.free = new Boolean[w][h];
            this.closed = new int[w * h];
            this.open = new int[w * h];
            this.heuristic = new int[w * h];
            this.parents = new int[w * h];
            this.inOpenOrClosed = new int[w * h];
            this.cost = new int[w * h];
        }
        int i = 0;
        for (int y = 0; y < h; ++y) {
            int x = 0;
            while (x < w) {
                this.free[x][y] = null;
                this.closed[i] = -1;
                this.inOpenOrClosed[i] = 0;
                ++x;
                ++i;
            }
        }
        if (ru != null) {
            for (int pos : ru.getPositionsUsed()) {
                this.free[pos % w][pos / w] = false;
            }
        }
        int targetx = targetpos % w;
        int targety = targetpos / w;
        int sq_range = range * range;
        int startPos = start.getY() * w + start.getX();
        assert (targetx >= 0);
        assert (targetx < w);
        assert (targety >= 0);
        assert (targety < h);
        assert (start.getX() >= 0);
        assert (start.getX() < w);
        assert (start.getY() >= 0);
        assert (start.getY() < h);
        this.openinsert = 0;
        this.open[this.openinsert] = startPos;
        this.heuristic[this.openinsert] = this.manhattanDistance(start.getX(), start.getY(), targetx, targety);
        this.parents[this.openinsert] = startPos;
        this.inOpenOrClosed[startPos] = 1;
        this.cost[startPos] = 0;
        ++this.openinsert;
        while (this.openinsert > 0) {
            ++iterations;
            --this.openinsert;
            int pos = this.open[this.openinsert];
            int parent = this.parents[this.openinsert];
            if (this.closed[pos] != -1) continue;
            this.closed[pos] = parent;
            int x = pos % w;
            int y = pos / w;
            if ((x - targetx) * (x - targetx) + (y - targety) * (y - targety) <= sq_range) {
                int last = pos;
                while (parent != pos) {
                    last = pos;
                    pos = parent;
                    parent = this.closed[pos];
                    ++accumlength;
                }
                if (last == pos + w) {
                    return new UnitAction(1, 2);
                }
                if (last == pos - 1) {
                    return new UnitAction(1, 3);
                }
                if (last == pos - w) {
                    return new UnitAction(1, 0);
                }
                if (last == pos + 1) {
                    return new UnitAction(1, 1);
                }
                return null;
            }
            if (y > 0 && this.inOpenOrClosed[pos - w] == 0) {
                if (this.free[x][y - 1] == null) {
                    this.free[x][y - 1] = gs.free(x, y - 1);
                }
                assert (this.free[x][y - 1] != null);
                if (this.free[x][y - 1].booleanValue()) {
                    this.addToOpen(x, y - 1, pos - w, pos, this.manhattanDistance(x, y - 1, targetx, targety));
                }
            }
            if (x < pgs.getWidth() - 1 && this.inOpenOrClosed[pos + 1] == 0) {
                if (this.free[x + 1][y] == null) {
                    this.free[x + 1][y] = gs.free(x + 1, y);
                }
                assert (this.free[x + 1][y] != null);
                if (this.free[x + 1][y].booleanValue()) {
                    this.addToOpen(x + 1, y, pos + 1, pos, this.manhattanDistance(x + 1, y, targetx, targety));
                }
            }
            if (y < pgs.getHeight() - 1 && this.inOpenOrClosed[pos + w] == 0) {
                if (this.free[x][y + 1] == null) {
                    this.free[x][y + 1] = gs.free(x, y + 1);
                }
                assert (this.free[x][y + 1] != null);
                if (this.free[x][y + 1].booleanValue()) {
                    this.addToOpen(x, y + 1, pos + w, pos, this.manhattanDistance(x, y + 1, targetx, targety));
                }
            }
            if (x <= 0 || this.inOpenOrClosed[pos - 1] != 0) continue;
            if (this.free[x - 1][y] == null) {
                this.free[x - 1][y] = gs.free(x - 1, y);
            }
            assert (this.free[x - 1][y] != null);
            if (!this.free[x - 1][y].booleanValue()) continue;
            this.addToOpen(x - 1, y, pos - 1, pos, this.manhattanDistance(x - 1, y, targetx, targety));
        }
        return null;
    }

    @Override
    public UnitAction findPathToAdjacentPosition(Unit start, int targetpos, GameState gs, ResourceUsage ru) {
        return this.findPathToPositionInRange(start, targetpos, 1, gs, ru);
    }

    @Override
    public boolean pathExists(Unit start, int targetpos, GameState gs, ResourceUsage ru) {
        return start.getPosition(gs.getPhysicalGameState()) == targetpos || this.findPath(start, targetpos, gs, ru) != null;
    }

    @Override
    public boolean pathToPositionInRangeExists(Unit start, int targetpos, int range, GameState gs, ResourceUsage ru) {
        int x = targetpos % gs.getPhysicalGameState().getWidth();
        int y = targetpos / gs.getPhysicalGameState().getWidth();
        int d = (x - start.getX()) * (x - start.getX()) + (y - start.getY()) * (y - start.getY());
        return d <= range * range || this.findPathToPositionInRange(start, targetpos, range, gs, ru) != null;
    }

    void addToOpen(int x, int y, int newPos, int oldPos, int h) {
        this.cost[newPos] = this.cost[oldPos] + 1;
        for (int i = this.openinsert - 1; i >= 0; --i) {
            if (this.heuristic[i] + this.cost[this.open[i]] < h + this.cost[newPos]) continue;
            for (int j = this.openinsert; j >= i + 1; --j) {
                this.open[j] = this.open[j - 1];
                this.heuristic[j] = this.heuristic[j - 1];
                this.parents[j] = this.parents[j - 1];
            }
            this.open[i + 1] = newPos;
            this.heuristic[i + 1] = h;
            this.parents[i + 1] = oldPos;
            ++this.openinsert;
            this.inOpenOrClosed[newPos] = 1;
            return;
        }
        for (int j = this.openinsert; j >= 1; --j) {
            this.open[j] = this.open[j - 1];
            this.heuristic[j] = this.heuristic[j - 1];
            this.parents[j] = this.parents[j - 1];
        }
        this.open[0] = newPos;
        this.heuristic[0] = h;
        this.parents[0] = oldPos;
        ++this.openinsert;
        this.inOpenOrClosed[newPos] = 1;
    }

    int manhattanDistance(int x, int y, int x2, int y2) {
        return Math.abs(x - x2) + Math.abs(y - y2);
    }

    public int findDistToPositionInRange(Unit start, int targetpos, int range, GameState gs, ResourceUsage ru) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        int w = pgs.getWidth();
        int h = pgs.getHeight();
        if (this.free == null || this.free.length < w * h) {
            this.free = new Boolean[pgs.getWidth()][pgs.getHeight()];
            this.closed = new int[pgs.getWidth() * pgs.getHeight()];
            this.open = new int[pgs.getWidth() * pgs.getHeight()];
            this.heuristic = new int[pgs.getWidth() * pgs.getHeight()];
            this.parents = new int[pgs.getWidth() * pgs.getHeight()];
            this.inOpenOrClosed = new int[pgs.getWidth() * pgs.getHeight()];
            this.cost = new int[pgs.getWidth() * pgs.getHeight()];
        }
        int i = 0;
        for (int y = 0; y < pgs.getHeight(); ++y) {
            int x = 0;
            while (x < w) {
                this.free[x][y] = null;
                this.closed[i] = -1;
                this.inOpenOrClosed[i] = 0;
                ++x;
                ++i;
            }
        }
        if (ru != null) {
            for (int pos : ru.getPositionsUsed()) {
                this.free[pos % w][pos / w] = false;
            }
        }
        int targetx = targetpos % w;
        int targety = targetpos / w;
        int sq_range = range * range;
        int startPos = start.getY() * w + start.getX();
        assert (targetx >= 0);
        assert (targetx < w);
        assert (targety >= 0);
        assert (targety < h);
        assert (start.getX() >= 0);
        assert (start.getX() < w);
        assert (start.getY() >= 0);
        assert (start.getY() < h);
        this.openinsert = 0;
        this.open[this.openinsert] = startPos;
        this.heuristic[this.openinsert] = this.manhattanDistance(start.getX(), start.getY(), targetx, targety);
        this.parents[this.openinsert] = startPos;
        this.inOpenOrClosed[startPos] = 1;
        this.cost[startPos] = 0;
        ++this.openinsert;
        while (this.openinsert > 0) {
            ++iterations;
            --this.openinsert;
            int pos = this.open[this.openinsert];
            int parent = this.parents[this.openinsert];
            if (this.closed[pos] != -1) continue;
            this.closed[pos] = parent;
            int x = pos % w;
            int y = pos / w;
            if ((x - targetx) * (x - targetx) + (y - targety) * (y - targety) <= sq_range) {
                int temp = 0;
                while (parent != pos) {
                    pos = parent;
                    parent = this.closed[pos];
                    ++accumlength;
                    ++temp;
                }
                return temp;
            }
            if (y > 0 && this.inOpenOrClosed[pos - w] == 0) {
                if (this.free[x][y - 1] == null) {
                    this.free[x][y - 1] = gs.free(x, y - 1);
                }
                assert (this.free[x][y - 1] != null);
                if (this.free[x][y - 1].booleanValue()) {
                    this.addToOpen(x, y - 1, pos - w, pos, this.manhattanDistance(x, y - 1, targetx, targety));
                }
            }
            if (x < pgs.getWidth() - 1 && this.inOpenOrClosed[pos + 1] == 0) {
                if (this.free[x + 1][y] == null) {
                    this.free[x + 1][y] = gs.free(x + 1, y);
                }
                assert (this.free[x + 1][y] != null);
                if (this.free[x + 1][y].booleanValue()) {
                    this.addToOpen(x + 1, y, pos + 1, pos, this.manhattanDistance(x + 1, y, targetx, targety));
                }
            }
            if (y < pgs.getHeight() - 1 && this.inOpenOrClosed[pos + w] == 0) {
                if (this.free[x][y + 1] == null) {
                    this.free[x][y + 1] = gs.free(x, y + 1);
                }
                assert (this.free[x][y + 1] != null);
                if (this.free[x][y + 1].booleanValue()) {
                    this.addToOpen(x, y + 1, pos + w, pos, this.manhattanDistance(x, y + 1, targetx, targety));
                }
            }
            if (x <= 0 || this.inOpenOrClosed[pos - 1] != 0) continue;
            if (this.free[x - 1][y] == null) {
                this.free[x - 1][y] = gs.free(x - 1, y);
            }
            assert (this.free[x - 1][y] != null);
            if (!this.free[x - 1][y].booleanValue()) continue;
            this.addToOpen(x - 1, y, pos - 1, pos, this.manhattanDistance(x - 1, y, targetx, targety));
        }
        return -1;
    }
}

