/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.pathfinding;

import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;

public class BFSPathFinding
extends PathFinding {
    public static int iterations = 0;
    public static int accumlength = 0;
    Boolean[][] free;
    int[] closed;
    int[] open;
    int[] inOpenOrClosed;
    int[] parents;
    int openinsert = 0;
    int openremove = 0;

    @Override
    public UnitAction findPath(Unit start, int targetpos, GameState gs, ResourceUsage ru) {
        return this.findPathToPositionInRange(start, targetpos, 0, gs, ru);
    }

    @Override
    public UnitAction findPathToPositionInRange(Unit start, int targetpos, int range, GameState gs, ResourceUsage ru) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        int w = pgs.getWidth();
        int h = pgs.getHeight();
        if (this.free == null || this.free.length < w * h) {
            this.free = new Boolean[pgs.getWidth()][pgs.getHeight()];
            this.closed = new int[pgs.getWidth() * pgs.getHeight()];
            this.open = new int[pgs.getWidth() * pgs.getHeight()];
            this.inOpenOrClosed = new int[pgs.getWidth() * pgs.getHeight()];
            this.parents = new int[pgs.getWidth() * pgs.getHeight()];
        }
        int i = 0;
        for (int y = 0; y < pgs.getHeight(); ++y) {
            int x = 0;
            while (x < w) {
                this.free[x][y] = null;
                this.closed[i] = -1;
                this.inOpenOrClosed[i] = 0;
                ++x;
                ++i;
            }
        }
        if (ru != null) {
            for (int pos : ru.getPositionsUsed()) {
                this.free[pos % w][pos / w] = false;
            }
        }
        int targetx = targetpos % w;
        int targety = targetpos / w;
        int sq_range = range * range;
        int startPos = start.getY() * w + start.getX();
        this.openinsert = 0;
        this.openremove = 0;
        this.open[this.openinsert] = startPos;
        this.parents[this.openinsert] = startPos;
        this.inOpenOrClosed[startPos] = 1;
        ++this.openinsert;
        while (this.openinsert != this.openremove) {
            ++iterations;
            int pos = this.open[this.openremove];
            int parent = this.parents[this.openremove];
            ++this.openremove;
            if (this.openremove >= this.open.length) {
                this.openremove = 0;
            }
            if (this.closed[pos] != -1) continue;
            this.closed[pos] = parent;
            int x = pos % w;
            int y = pos / w;
            if ((x - targetx) * (x - targetx) + (y - targety) * (y - targety) <= sq_range) {
                int last = pos;
                while (parent != pos) {
                    last = pos;
                    pos = parent;
                    parent = this.closed[pos];
                    ++accumlength;
                }
                if (last == pos + w) {
                    return new UnitAction(1, 2);
                }
                if (last == pos - 1) {
                    return new UnitAction(1, 3);
                }
                if (last == pos - w) {
                    return new UnitAction(1, 0);
                }
                if (last == pos + 1) {
                    return new UnitAction(1, 1);
                }
                return null;
            }
            if (y > 0 && this.inOpenOrClosed[pos - w] == 0) {
                if (this.free[x][y - 1] == null) {
                    this.free[x][y - 1] = gs.free(x, y - 1);
                }
                if (this.free[x][y - 1].booleanValue()) {
                    this.open[this.openinsert] = pos - w;
                    this.parents[this.openinsert] = pos;
                    ++this.openinsert;
                    if (this.openinsert >= this.open.length) {
                        this.openinsert = 0;
                    }
                    this.inOpenOrClosed[pos - w] = 1;
                }
            }
            if (x < pgs.getWidth() - 1 && this.inOpenOrClosed[pos + 1] == 0) {
                if (this.free[x + 1][y] == null) {
                    this.free[x + 1][y] = gs.free(x + 1, y);
                }
                if (this.free[x + 1][y].booleanValue()) {
                    this.open[this.openinsert] = pos + 1;
                    this.parents[this.openinsert] = pos;
                    ++this.openinsert;
                    if (this.openinsert >= this.open.length) {
                        this.openinsert = 0;
                    }
                    this.inOpenOrClosed[pos + 1] = 1;
                }
            }
            if (y < pgs.getHeight() - 1 && this.inOpenOrClosed[pos + w] == 0) {
                if (this.free[x][y + 1] == null) {
                    this.free[x][y + 1] = gs.free(x, y + 1);
                }
                if (this.free[x][y + 1].booleanValue()) {
                    this.open[this.openinsert] = pos + w;
                    this.parents[this.openinsert] = pos;
                    ++this.openinsert;
                    if (this.openinsert >= this.open.length) {
                        this.openinsert = 0;
                    }
                    this.inOpenOrClosed[pos + w] = 1;
                }
            }
            if (x <= 0 || this.inOpenOrClosed[pos - 1] != 0) continue;
            if (this.free[x - 1][y] == null) {
                this.free[x - 1][y] = gs.free(x - 1, y);
            }
            if (!this.free[x - 1][y].booleanValue()) continue;
            this.open[this.openinsert] = pos - 1;
            this.parents[this.openinsert] = pos;
            ++this.openinsert;
            if (this.openinsert >= this.open.length) {
                this.openinsert = 0;
            }
            this.inOpenOrClosed[pos - 1] = 1;
        }
        return null;
    }

    @Override
    public UnitAction findPathToAdjacentPosition(Unit start, int targetpos, GameState gs, ResourceUsage ru) {
        return this.findPathToPositionInRange(start, targetpos, 1, gs, ru);
    }

    @Override
    public boolean pathExists(Unit start, int targetpos, GameState gs, ResourceUsage ru) {
        return start.getPosition(gs.getPhysicalGameState()) == targetpos || this.findPath(start, targetpos, gs, ru) != null;
    }

    @Override
    public boolean pathToPositionInRangeExists(Unit start, int targetpos, int range, GameState gs, ResourceUsage ru) {
        int x = targetpos % gs.getPhysicalGameState().getWidth();
        int y = targetpos / gs.getPhysicalGameState().getWidth();
        int d = (x - start.getX()) * (x - start.getX()) + (y - start.getY()) * (y - start.getY());
        return d <= range * range || this.findPathToPositionInRange(start, targetpos, range, gs, ru) != null;
    }
}

