/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.pathfinding;

import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.Pair;

public class FloodFillPathFinding
extends PathFinding {
    PathFinding altPF = new AStarPathFinding();
    private static final int ALT_THRESHOLD = 0;
    HashMap<Integer, int[][]> cache = new HashMap();
    boolean[][] free;
    int[][] distances;
    int w;
    int h;
    int lastFrame = -1;

    @Override
    public boolean pathExists(Unit start, int targetpos, GameState gs, ResourceUsage ru) {
        return start.getPosition(gs.getPhysicalGameState()) == targetpos || this.findPath(start, targetpos, gs, ru) != null;
    }

    @Override
    public boolean pathToPositionInRangeExists(Unit start, int targetpos, int range, GameState gs, ResourceUsage ru) {
        int x = targetpos % gs.getPhysicalGameState().getWidth();
        int y = targetpos / gs.getPhysicalGameState().getWidth();
        int d = (x - start.getX()) * (x - start.getX()) + (y - start.getY()) * (y - start.getY());
        return d <= range * range || this.findPathToPositionInRange(start, targetpos, range, gs, ru) != null;
    }

    @Override
    public UnitAction findPath(Unit start, int targetpos, GameState gs, ResourceUsage ru) {
        return this.findPathToPositionInRange(start, targetpos, 0, gs, ru);
    }

    private boolean bounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.w && y < this.h;
    }

    private void doFloodFill(int x, int y, GameState gs, int finalX, int finalY) {
        assert (this.distances[x][y] != Integer.MAX_VALUE);
        boolean[][] gsFree = gs.getAllFree();
        ArrayList<Pair<Integer, Integer>> fringe = new ArrayList<Pair<Integer, Integer>>(this.h * this.w);
        fringe.add(new Pair<Integer, Integer>(x, y));
        boolean reached = false;
        for (int index = 0; index < fringe.size(); ++index) {
            x = (Integer)((Pair)fringe.get((int)index)).m_a;
            y = (Integer)((Pair)fringe.get((int)index)).m_b;
            int nextX = x - 1;
            int nextY = y;
            if (nextX == finalX && nextY == finalY) {
                reached = true;
            }
            if (this.bounds(nextX, nextY) && this.distances[nextX][nextY] == Integer.MAX_VALUE && this.free[nextX][nextY] && gsFree[nextX][nextY]) {
                this.distances[nextX][nextY] = this.distances[x][y] + 1;
                fringe.add(new Pair<Integer, Integer>(nextX, nextY));
            }
            nextX = x;
            nextY = y - 1;
            if (nextX == finalX && nextY == finalY) {
                reached = true;
            }
            if (this.bounds(nextX, nextY) && this.distances[nextX][nextY] == Integer.MAX_VALUE && this.free[nextX][nextY] && gsFree[nextX][nextY]) {
                this.distances[nextX][nextY] = this.distances[x][y] + 1;
                fringe.add(new Pair<Integer, Integer>(nextX, nextY));
            }
            nextX = x + 1;
            nextY = y;
            if (nextX == finalX && nextY == finalY) {
                reached = true;
            }
            if (this.bounds(nextX, nextY) && this.distances[nextX][nextY] == Integer.MAX_VALUE && this.free[nextX][nextY] && gsFree[nextX][nextY]) {
                this.distances[nextX][nextY] = this.distances[x][y] + 1;
                fringe.add(new Pair<Integer, Integer>(nextX, nextY));
            }
            nextX = x;
            nextY = y + 1;
            if (nextX == finalX && nextY == finalY) {
                reached = true;
            }
            if (this.bounds(nextX, nextY) && this.distances[nextX][nextY] == Integer.MAX_VALUE && this.free[nextX][nextY] && gsFree[nextX][nextY]) {
                this.distances[nextX][nextY] = this.distances[x][y] + 1;
                fringe.add(new Pair<Integer, Integer>(nextX, nextY));
            }
            if (reached) break;
        }
    }

    private UnitAction calculateDistances(Unit start, int targetpos, int range, GameState gs, ResourceUsage ru) {
        int x = targetpos % this.w;
        int y = targetpos / this.w;
        if (Math.abs(start.getX() - x) + Math.abs(start.getY() - y) <= 0) {
            return this.altPF.findPathToPositionInRange(start, targetpos, range, gs, ru);
        }
        for (int[] row : this.distances = new int[this.w][this.h]) {
            Arrays.fill(row, Integer.MAX_VALUE);
        }
        this.distances[x][y] = 0;
        this.doFloodFill(x, y, gs, start.getX(), start.getY());
        this.cache.put(targetpos, this.distances);
        return this.getAction(start);
    }

    private void initFree(GameState gs, ResourceUsage ru) {
        if (this.free == null || this.free.length < this.w || this.free[0].length < this.h) {
            this.free = new boolean[this.w][this.h];
        }
        for (boolean[] row : this.free) {
            Arrays.fill(row, true);
        }
        if (ru != null) {
            Object object = ru.getPositionsUsed().iterator();
            while (object.hasNext()) {
                int pos = (Integer)object.next();
                this.free[pos % this.w][pos / this.w] = false;
            }
        }
    }

    private UnitAction getAction(Unit start) {
        int x = start.getX();
        int y = start.getY();
        int[] dists = new int[]{this.bounds(x - 1, y) ? this.distances[x - 1][y] : Integer.MAX_VALUE, this.bounds(x, y - 1) ? this.distances[x][y - 1] : Integer.MAX_VALUE, this.bounds(x + 1, y) ? this.distances[x + 1][y] : Integer.MAX_VALUE, this.bounds(x, y + 1) ? this.distances[x][y + 1] : Integer.MAX_VALUE};
        int index = 0;
        int min = dists[0];
        for (int i = 1; i < dists.length; ++i) {
            if (dists[i] >= min) continue;
            index = i;
            min = dists[i];
        }
        if (min == Integer.MAX_VALUE) {
            return null;
        }
        switch (index) {
            case 0: {
                return new UnitAction(1, 3);
            }
            case 1: {
                return new UnitAction(1, 0);
            }
            case 2: {
                return new UnitAction(1, 1);
            }
            case 3: {
                return new UnitAction(1, 2);
            }
        }
        return null;
    }

    @Override
    public UnitAction findPathToPositionInRange(Unit start, int targetpos, int range, GameState gs, ResourceUsage ru) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        this.w = pgs.getWidth();
        this.h = pgs.getHeight();
        int x = targetpos % this.w;
        int y = targetpos / this.w;
        if ((start.getX() - x) * (start.getX() - x) + (start.getY() - y) * (start.getY() - y) <= range * range) {
            return null;
        }
        if (gs.getTime() < this.lastFrame) {
            this.cache.clear();
        }
        this.lastFrame = gs.getTime();
        this.initFree(gs, ru);
        if (this.cache.containsKey(targetpos)) {
            this.distances = this.cache.get(targetpos);
            UnitAction action = this.getAction(start);
            if (action != null) {
                ResourceUsage r = action.resourceUsage(start, pgs);
                for (int pos : r.getPositionsUsed()) {
                    if (this.free[pos % this.w][pos / this.w] && gs.free(pos % this.w, pos / this.w)) continue;
                    this.cache.remove(targetpos);
                    return this.calculateDistances(start, targetpos, range, gs, ru);
                }
            } else {
                this.cache.remove(targetpos);
                return this.calculateDistances(start, targetpos, range, gs, ru);
            }
            return action;
        }
        return this.calculateDistances(start, targetpos, range, gs, ru);
    }

    @Override
    public UnitAction findPathToAdjacentPosition(Unit start, int targetpos, GameState gs, ResourceUsage ru) {
        return this.findPathToPositionInRange(start, targetpos, 1, gs, ru);
    }
}

