/*
 * Decompiled with CFR 0.152.
 */
package ai.abstraction.pathfinding;

import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;

public class GreedyPathFinding
extends PathFinding {
    @Override
    public UnitAction findPath(Unit start, int targetpos, GameState gs, ResourceUsage ru) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        int w = pgs.getWidth();
        int[] dx = new int[]{0, 1, 0, -1};
        int[] dy = new int[]{-1, 0, 1, 0};
        int x1 = start.getX();
        int y1 = start.getY();
        int x2 = targetpos % pgs.getWidth();
        int y2 = targetpos / pgs.getWidth();
        int min_d = (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
        int direction = -1;
        for (int i = 0; i < dx.length; ++i) {
            int x = x1 + dx[i];
            int y = y1 + dy[i];
            if (x < 0 || x >= pgs.getWidth() || y < 0 || y >= pgs.getHeight() || !gs.free(x, y) || ru != null && ru.getPositionsUsed().contains(x + y * w)) continue;
            int d = (x2 - x) * (x2 - x) + (y2 - y) * (y2 - y);
            if (direction != -1 && d >= min_d) continue;
            min_d = d;
            direction = i;
        }
        if (direction == -1) {
            return null;
        }
        return new UnitAction(1, direction);
    }

    @Override
    public UnitAction findPathToPositionInRange(Unit start, int targetpos, int range, GameState gs, ResourceUsage ru) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        int w = pgs.getWidth();
        int[] dx = new int[]{0, 1, 0, -1};
        int[] dy = new int[]{-1, 0, 1, 0};
        int x1 = start.getX();
        int y1 = start.getY();
        int x2 = targetpos % pgs.getWidth();
        int y2 = targetpos / pgs.getWidth();
        int min_d = (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
        int direction = -1;
        if (min_d <= range) {
            return null;
        }
        for (int i = 0; i < dx.length; ++i) {
            int x = x1 + dx[i];
            int y = y1 + dy[i];
            if (x < 0 || x >= pgs.getWidth() || y < 0 || y >= pgs.getHeight() || !gs.free(x, y) || ru != null && ru.getPositionsUsed().contains(x + y * w)) continue;
            int d = (x2 - x) * (x2 - x) + (y2 - y) * (y2 - y);
            if (direction != -1 && d >= min_d) continue;
            min_d = d;
            direction = i;
        }
        if (direction == -1) {
            return null;
        }
        return new UnitAction(1, direction);
    }

    @Override
    public UnitAction findPathToAdjacentPosition(Unit start, int targetpos, GameState gs, ResourceUsage ru) {
        return this.findPathToPositionInRange(start, targetpos, 1, gs, ru);
    }

    @Override
    public boolean pathExists(Unit start, int targetpos, GameState gs, ResourceUsage ru) {
        return start.getPosition(gs.getPhysicalGameState()) == targetpos || this.findPath(start, targetpos, gs, ru) != null;
    }

    @Override
    public boolean pathToPositionInRangeExists(Unit start, int targetpos, int range, GameState gs, ResourceUsage ru) {
        int x = targetpos % gs.getPhysicalGameState().getWidth();
        int y = targetpos / gs.getPhysicalGameState().getWidth();
        int d = (x - start.getX()) * (x - start.getX()) + (y - start.getY()) * (y - start.getY());
        return d <= range * range || this.findPathToPositionInRange(start, targetpos, range, gs, ru) != null;
    }
}

