/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn;

import ai.abstraction.WorkerRush;
import ai.ahtn.domain.DomainDefinition;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.domain.PredefinedOperators;
import ai.ahtn.domain.Term;
import ai.ahtn.planner.AdversarialBoundedDepthPlannerAlphaBeta;
import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import ai.evaluation.EvaluationFunction;
import ai.evaluation.SimpleSqrtEvaluationFunction3;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitTypeTable;
import util.Pair;

public class AHTNAI
extends AIWithComputationBudget {
    public static int DEBUG = 0;
    String domainFileName;
    DomainDefinition dd;
    EvaluationFunction ef;
    AI playoutAI;
    public int PLAYOUT_LOOKAHEAD = 100;
    List<MethodDecomposition> actionsBeingExecuted;

    public AHTNAI(UnitTypeTable utt) throws Exception {
        this("data/ahtn/microrts-ahtn-definition-flexible-single-target-portfolio.lisp", 100, -1, 100, new SimpleSqrtEvaluationFunction3(), new WorkerRush(utt));
    }

    public AHTNAI(String a_domainFileName, int available_time, int max_playouts, int playoutLookahead, EvaluationFunction a_ef, AI a_playoutAI) throws Exception {
        super(available_time, max_playouts);
        this.domainFileName = a_domainFileName;
        this.dd = DomainDefinition.fromLispFile(this.domainFileName);
        this.PLAYOUT_LOOKAHEAD = playoutLookahead;
        this.ef = a_ef;
        this.playoutAI = a_playoutAI;
        this.actionsBeingExecuted = new LinkedList<MethodDecomposition>();
    }

    @Override
    public void reset() {
        this.actionsBeingExecuted = new LinkedList<MethodDecomposition>();
        AdversarialBoundedDepthPlannerAlphaBeta.clearStatistics();
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        Term goal1 = Term.fromString("(destroy-player " + player + " " + (1 - player) + ")");
        Term goal2 = Term.fromString("(destroy-player " + (1 - player) + " " + player + ")");
        if (gs.canExecuteAnyAction(player)) {
            Pair<MethodDecomposition, MethodDecomposition> plan = AdversarialBoundedDepthPlannerAlphaBeta.getBestPlanIterativeDeepening(goal1, goal2, player, this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.PLAYOUT_LOOKAHEAD, gs, this.dd, this.ef, this.playoutAI);
            PlayerAction pa = new PlayerAction();
            if (plan != null) {
                LinkedList l;
                MethodDecomposition toExecute = (MethodDecomposition)plan.m_a;
                LinkedList linkedList = l = toExecute != null ? toExecute.convertToOperatorList() : new LinkedList();
                if (DEBUG >= 1) {
                    List<Object> l2 = plan.m_b != null ? ((MethodDecomposition)plan.m_b).convertToOperatorList() : new LinkedList();
                    System.out.println("---- ---- ---- ----");
                    System.out.println(gs);
                    System.out.println("Max plan:");
                    for (Object a : l) {
                        System.out.println("  " + ((Pair)a).m_a + ": " + ((Pair)a).m_b);
                    }
                    System.out.println("Min plan:");
                    for (Object a : l2) {
                        System.out.println("  " + ((Pair)a).m_a + ": " + ((Pair)a).m_b);
                    }
                }
                if (DEBUG >= 2) {
                    System.out.println("Detailed Max plan:");
                    ((MethodDecomposition)plan.m_a).printDetailed();
                }
                this.actionsBeingExecuted.clear();
                while (!l.isEmpty()) {
                    Pair tmp = (Pair)l.remove(0);
                    if (((Integer)tmp.m_a).intValue() != gs.getTime()) break;
                    List actions2 = (List)tmp.m_b;
                    for (Term action : actions2) {
                        MethodDecomposition md = new MethodDecomposition(action);
                        this.actionsBeingExecuted.add(md);
                    }
                }
            }
            if (DEBUG >= 1) {
                System.out.println("Actions being executed:");
                for (MethodDecomposition md : this.actionsBeingExecuted) {
                    System.out.println("    " + md.getTerm());
                }
            }
            LinkedList<MethodDecomposition> toDelete = new LinkedList<MethodDecomposition>();
            for (MethodDecomposition md : this.actionsBeingExecuted) {
                if (PredefinedOperators.execute(md, gs, pa)) {
                    toDelete.add(md);
                }
                for (Pair<Unit, UnitAction> ua : pa.getActions()) {
                    if (gs.getUnit(((Unit)ua.m_a).getID()) != null) continue;
                    pa.removeUnitAction((Unit)ua.m_a, (UnitAction)ua.m_b);
                }
            }
            this.actionsBeingExecuted.removeAll(toDelete);
            if (DEBUG >= 1) {
                System.out.println("Result in the following unit actions:");
                System.out.println("    " + pa);
            }
            pa.fillWithNones(gs, player, 10);
            return pa;
        }
        return new PlayerAction();
    }

    @Override
    public AI clone() {
        try {
            return new AHTNAI(this.domainFileName, this.TIME_BUDGET, this.ITERATIONS_BUDGET, this.PLAYOUT_LOOKAHEAD, this.ef, this.playoutAI);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.domainFileName + ", " + this.TIME_BUDGET + ", " + this.ITERATIONS_BUDGET + ", " + this.PLAYOUT_LOOKAHEAD + ", " + this.ef + ", " + this.playoutAI + ")";
    }

    @Override
    public String statisticsString() {
        return "Max depth: " + AdversarialBoundedDepthPlannerAlphaBeta.max_iterative_deepening_depth + ", Average depth: " + AdversarialBoundedDepthPlannerAlphaBeta.average_iterative_deepening_depth / (double)AdversarialBoundedDepthPlannerAlphaBeta.n_iterative_deepening_runs + ", Max tree leaves: " + AdversarialBoundedDepthPlannerAlphaBeta.max_tree_leaves + ", Average tree leaves: " + AdversarialBoundedDepthPlannerAlphaBeta.average_tree_leaves / (double)AdversarialBoundedDepthPlannerAlphaBeta.n_trees + ", Max tree nodes: " + AdversarialBoundedDepthPlannerAlphaBeta.max_tree_nodes + ", Average tree nodes: " + AdversarialBoundedDepthPlannerAlphaBeta.average_tree_nodes / (double)AdversarialBoundedDepthPlannerAlphaBeta.n_trees + ", Max tree depth: " + AdversarialBoundedDepthPlannerAlphaBeta.max_tree_depth + ", Average tree depth: " + AdversarialBoundedDepthPlannerAlphaBeta.average_tree_depth / (double)AdversarialBoundedDepthPlannerAlphaBeta.n_trees + ", Max time depth: " + AdversarialBoundedDepthPlannerAlphaBeta.max_time_depth + ", Average time depth: " + AdversarialBoundedDepthPlannerAlphaBeta.average_time_depth / (double)AdversarialBoundedDepthPlannerAlphaBeta.n_trees;
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        ArrayList<ParameterSpecification> parameters = new ArrayList<ParameterSpecification>();
        parameters.add(new ParameterSpecification("DomainFileName", String.class, "data/ahtn/microrts-ahtn-definition-flexible-single-target-portfolio.lisp"));
        parameters.add(new ParameterSpecification("TimeBudget", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("IterationsBudget", Integer.TYPE, -1));
        parameters.add(new ParameterSpecification("PlayoutLookahead", Integer.TYPE, 100));
        parameters.add(new ParameterSpecification("PlayoutAI", AI.class, this.playoutAI));
        parameters.add(new ParameterSpecification("EvaluationFunction", EvaluationFunction.class, new SimpleSqrtEvaluationFunction3()));
        return parameters;
    }

    public String getDomainFileName() {
        return this.domainFileName;
    }

    public void setDomainFileName(String a_domainFileName) throws Exception {
        this.domainFileName = a_domainFileName;
        this.dd = DomainDefinition.fromLispFile(this.domainFileName);
    }

    public int getPlayoutLookahead() {
        return this.PLAYOUT_LOOKAHEAD;
    }

    public void setPlayoutLookahead(int a_pla) {
        this.PLAYOUT_LOOKAHEAD = a_pla;
    }

    public AI getPlayoutAI() {
        return this.playoutAI;
    }

    public void setPlayoutAI(AI a_poAI) {
        this.playoutAI = a_poAI;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.ef;
    }

    public void setEvaluationFunction(EvaluationFunction a_ef) {
        this.ef = a_ef;
    }
}

