/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.PredefinedPredicates;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.Term;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rts.GameState;

public class Clause {
    public static int DEBUG = 0;
    public static final int CLAUSE_TERM = 0;
    public static final int CLAUSE_AND = 1;
    public static final int CLAUSE_OR = 2;
    public static final int CLAUSE_NOT = 3;
    public static final int CLAUSE_TRUE = 4;
    public static final int CLAUSE_FALSE = 5;
    int type = 1;
    Term term;
    Clause[] clauses;
    List<List<Binding>> matches_left;
    int matches_current;
    int matches_previous;
    List<Binding> matches_l;
    Clause[] matches_resolved;
    int[] matches_trail;

    public static Clause fromLispElement(LispElement e) throws Exception {
        LispElement head = e.children.get(0);
        switch (head.element) {
            case "and": {
                Clause c = new Clause();
                c.type = 1;
                c.clauses = new Clause[e.children.size() - 1];
                for (int i = 0; i < e.children.size() - 1; ++i) {
                    c.clauses[i] = Clause.fromLispElement(e.children.get(i + 1));
                }
                return c;
            }
            case "or": {
                Clause c = new Clause();
                c.type = 2;
                c.clauses = new Clause[e.children.size() - 1];
                for (int i = 0; i < e.children.size() - 1; ++i) {
                    c.clauses[i] = Clause.fromLispElement(e.children.get(i + 1));
                }
                return c;
            }
            case "not": {
                Clause c = new Clause();
                c.type = 3;
                c.clauses = new Clause[1];
                c.clauses[0] = Clause.fromLispElement(e.children.get(1));
                return c;
            }
            case "true": {
                Clause c = new Clause();
                c.type = 4;
                return c;
            }
            case "false": {
                Clause c = new Clause();
                c.type = 5;
                return c;
            }
        }
        Clause c = new Clause();
        c.type = 0;
        c.term = Term.fromLispElement(e);
        return c;
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return this.term.toString();
            }
            case 1: {
                StringBuilder sb = new StringBuilder();
                sb.append("(and");
                for (Clause clause : this.clauses) {
                    sb.append(" ");
                    sb.append(clause);
                }
                sb.append(")");
                return sb.toString();
            }
            case 2: {
                StringBuilder sb = new StringBuilder();
                sb.append("(or");
                for (Clause clause : this.clauses) {
                    sb.append(" ");
                    sb.append(clause);
                }
                sb.append(")");
                return sb.toString();
            }
            case 3: {
                StringBuilder sb = new StringBuilder();
                sb.append("(not");
                for (Clause clause : this.clauses) {
                    sb.append(" ");
                    sb.append(clause);
                }
                sb.append(")");
                return sb.toString();
            }
            case 4: {
                return "(true)";
            }
            case 5: {
                return "(false)";
            }
        }
        return null;
    }

    public Clause resolve(List<Binding> l, GameState gs) throws Exception {
        if (l.isEmpty()) {
            return this;
        }
        Clause c = new Clause();
        c.type = this.type;
        if (this.term != null) {
            c.term = this.term.resolve(l, gs);
        }
        if (this.clauses != null) {
            c.clauses = new Clause[this.clauses.length];
            for (int i = 0; i < this.clauses.length; ++i) {
                c.clauses[i] = this.clauses[i].resolve(l, gs);
            }
        } else {
            c.clauses = null;
        }
        return c;
    }

    public Clause clone() {
        Clause c = new Clause();
        c.type = this.type;
        if (this.term != null) {
            c.term = this.term.clone();
        }
        if (this.clauses != null) {
            c.clauses = new Clause[this.clauses.length];
            for (int i = 0; i < this.clauses.length; ++i) {
                c.clauses[i] = this.clauses[i].clone();
            }
        } else {
            c.clauses = null;
        }
        return c;
    }

    public void renameVariables(int renamingIndex) {
        if (this.term != null) {
            this.term.renameVariables(renamingIndex);
        }
        if (this.clauses != null) {
            for (Clause clause : this.clauses) {
                clause.renameVariables(renamingIndex);
            }
        }
    }

    public void applyBindings(List<Binding> l) throws Exception {
        if (l.isEmpty()) {
            return;
        }
        if (this.term != null) {
            this.term.applyBindings(l);
        }
        if (this.clauses != null) {
            for (Clause clause : this.clauses) {
                clause.applyBindings(l);
            }
        }
    }

    public List<Binding> firstMatch(GameState gs) throws Exception {
        if (DEBUG >= 1) {
            System.out.println("Clause.firstMatch");
        }
        switch (this.type) {
            case 0: {
                this.matches_left = PredefinedPredicates.allMatches(this.term, gs);
                if (this.matches_left.isEmpty()) {
                    return null;
                }
                return this.matches_left.remove(0);
            }
            case 1: {
                this.matches_left = new ArrayList<List<Binding>>();
                this.matches_current = 0;
                this.matches_previous = -1;
                this.matches_l = new ArrayList<Binding>();
                this.matches_resolved = new Clause[this.clauses.length];
                this.matches_trail = new int[this.clauses.length];
                block8: while (true) {
                    List<Binding> l2;
                    if (DEBUG >= 1) {
                        System.out.println("Clause.firstMatch(AND): current = " + this.matches_current + " (previous: " + this.matches_previous + ")");
                    }
                    Clause c = this.clauses[this.matches_current];
                    if (this.matches_previous < this.matches_current) {
                        this.matches_resolved[this.matches_current] = c;
                        if (this.matches_l != null) {
                            this.matches_resolved[this.matches_current] = c.resolve(this.matches_l, gs);
                        }
                        if (DEBUG >= 1) {
                            System.out.println("Clause.firstMatch(AND): resolved clause = " + this.matches_resolved[this.matches_current]);
                        }
                        l2 = this.matches_resolved[this.matches_current].firstMatch(gs);
                        if (DEBUG >= 1) {
                            System.out.println("Clause.firstMatch(AND): match = " + l2);
                        }
                    } else {
                        l2 = this.matches_resolved[this.matches_current].nextMatch(gs);
                        if (DEBUG >= 1) {
                            System.out.println("Clause.firstMatch(AND): match = " + l2);
                        }
                    }
                    this.matches_previous = this.matches_current--;
                    if (l2 == null) {
                        if (this.matches_current < 0) {
                            this.matches_left = null;
                            return null;
                        }
                        while (true) {
                            if (this.matches_l.size() <= this.matches_trail[this.matches_current]) continue block8;
                            this.matches_l.remove(this.matches_l.size() - 1);
                        }
                    }
                    this.matches_trail[this.matches_current] = this.matches_l.size();
                    this.matches_l.addAll(l2);
                    ++this.matches_current;
                    if (this.matches_current >= this.clauses.length) break;
                }
                return this.matches_l;
            }
            case 2: {
                this.matches_left = new ArrayList<List<Binding>>();
                this.matches_current = 0;
                while (this.matches_current < this.clauses.length) {
                    List<Binding> l = this.clauses[this.matches_current].firstMatch(gs);
                    if (l != null) {
                        return l;
                    }
                    ++this.matches_current;
                }
                this.matches_left = null;
                return null;
            }
            case 3: {
                List<Binding> l = this.clauses[0].firstMatch(gs);
                this.matches_left = new ArrayList<List<Binding>>();
                if (l == null) {
                    return new ArrayList<Binding>();
                }
                return null;
            }
            case 4: {
                this.matches_left = new ArrayList<List<Binding>>();
                return new ArrayList<Binding>();
            }
            case 5: {
                this.matches_left = new ArrayList<List<Binding>>();
                return null;
            }
        }
        return null;
    }

    public List<Binding> nextMatch(GameState gs) throws Exception {
        if (DEBUG >= 1) {
            System.out.println("Clause.nextMatch");
        }
        if (this.matches_left == null) {
            return this.firstMatch(gs);
        }
        switch (this.type) {
            case 0: {
                if (this.matches_left.isEmpty()) {
                    this.matches_left = null;
                    return null;
                }
                return this.matches_left.remove(0);
            }
            case 1: {
                if (this.matches_current >= this.clauses.length) {
                    --this.matches_current;
                    while (this.matches_l.size() > this.matches_trail[this.matches_current]) {
                        this.matches_l.remove(this.matches_l.size() - 1);
                    }
                }
                block9: while (true) {
                    List<Binding> l2;
                    Clause c = this.clauses[this.matches_current];
                    if (this.matches_previous < this.matches_current) {
                        this.matches_resolved[this.matches_current] = c;
                        if (this.matches_l != null) {
                            this.matches_resolved[this.matches_current] = c.resolve(this.matches_l, gs);
                        }
                        l2 = this.matches_resolved[this.matches_current].firstMatch(gs);
                    } else {
                        l2 = this.matches_resolved[this.matches_current].nextMatch(gs);
                    }
                    this.matches_previous = this.matches_current--;
                    if (l2 == null) {
                        if (this.matches_current < 0) {
                            this.matches_left = null;
                            return null;
                        }
                        while (true) {
                            if (this.matches_l.size() <= this.matches_trail[this.matches_current]) continue block9;
                            this.matches_l.remove(this.matches_l.size() - 1);
                        }
                    }
                    this.matches_trail[this.matches_current] = this.matches_l.size();
                    this.matches_l.addAll(l2);
                    ++this.matches_current;
                    if (this.matches_current >= this.clauses.length) break;
                }
                return this.matches_l;
            }
            case 2: {
                while (this.matches_current < this.clauses.length) {
                    List<Binding> l = this.clauses[this.matches_current].nextMatch(gs);
                    if (l != null) {
                        return l;
                    }
                    ++this.matches_current;
                }
                this.matches_left = null;
                return null;
            }
            case 3: {
                this.matches_left = null;
                return null;
            }
            case 4: {
                this.matches_left = null;
                return null;
            }
            case 5: {
                this.matches_left = null;
                return null;
            }
        }
        return null;
    }

    public void countVariableAppearances(HashMap<Symbol, Integer> appearances) throws Exception {
        if (this.term != null) {
            this.term.countVariableAppearances(appearances);
        }
        if (this.clauses != null) {
            for (Clause c : this.clauses) {
                c.countVariableAppearances(appearances);
            }
        }
    }

    public void replaceSingletonsByWildcards(List<Symbol> singletons) throws Exception {
        if (this.term != null) {
            this.term.replaceSingletonsByWildcards(singletons);
        }
        if (this.clauses != null) {
            for (Clause c : this.clauses) {
                c.replaceSingletonsByWildcards(singletons);
            }
        }
    }
}

