/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.HTNMethod;
import ai.ahtn.domain.HTNOperator;
import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.LispParser.LispParser;
import ai.ahtn.domain.Symbol;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class DomainDefinition {
    public static int DEBUG = 0;
    String name;
    List<HTNOperator> operators = new LinkedList<HTNOperator>();
    List<HTNMethod> methods = new LinkedList<HTNMethod>();
    HashMap<Symbol, List<HTNMethod>> methodsPerGoal = new HashMap();

    public List<HTNOperator> getOperators() {
        return this.operators;
    }

    public List<HTNMethod> getMethods() {
        return this.methods;
    }

    public void addMethod(HTNMethod m) {
        this.methods.add(m);
        Symbol goal = m.head.getFunctor();
        List<HTNMethod> l = this.methodsPerGoal.get(goal);
        if (l == null) {
            l = new LinkedList<HTNMethod>();
            this.methodsPerGoal.put(goal, l);
        }
        l.add(m);
    }

    public static DomainDefinition fromLispFile(String fileName) throws Exception {
        List<LispElement> l = LispParser.parseLispFile(fileName);
        if (DEBUG >= 1) {
            for (LispElement e : l) {
                System.out.println(e);
            }
        }
        if (l.isEmpty()) {
            return null;
        }
        return DomainDefinition.fromLispElement(l.get(0));
    }

    public static DomainDefinition fromLispElement(LispElement e) throws Exception {
        DomainDefinition dd = new DomainDefinition();
        if (e.children.size() != 3) {
            throw new Exception("Lisp domain definition does not have 3 arguments");
        }
        LispElement defdomain = e.children.get(0);
        if (defdomain.element == null || !defdomain.element.equals("defdomain")) {
            throw new Exception("Lisp domain definition does not start by 'defdomain'");
        }
        LispElement name_e = e.children.get(1);
        if (name_e.element == null) {
            throw new Exception("second parameter of defdomain is not a domain name");
        }
        dd.name = name_e.element;
        LispElement rest_e = e.children.get(2);
        if (rest_e.children == null) {
            throw new Exception("third parameter of defdomain is not a list");
        }
        for (LispElement def_e : rest_e.children) {
            if (def_e.children != null && def_e.children.size() > 0) {
                LispElement head = def_e.children.get(0);
                if (head.element != null && head.element.equals(":operator")) {
                    HTNOperator op = HTNOperator.fromLispElement(def_e);
                    dd.operators.add(op);
                    continue;
                }
                if (head.element != null && head.element.equals(":method")) {
                    HTNMethod m = HTNMethod.fromLispElement(def_e);
                    dd.addMethod(m);
                    continue;
                }
                throw new Exception("Element in domain definition is not an operator nor method");
            }
            throw new Exception("Element in domain definition is not an operator nor method");
        }
        for (HTNMethod m : dd.getMethods()) {
            List<Symbol> l;
            if (DEBUG >= 1 && !(l = m.findSingletons()).isEmpty()) {
                System.out.println("Singletons in '" + m.getName() + "': " + l);
            }
            m.replaceSingletonsByWildcards();
        }
        return dd;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Domain: ").append(this.name).append("\n").append("Operators:\n");
        for (HTNOperator op : this.operators) {
            sb.append("  ").append(op).append("\n");
        }
        sb.append("Methods:\n");
        for (HTNMethod m : this.methods) {
            sb.append("  ").append(m).append("\n");
        }
        return sb.toString();
    }

    public List<HTNMethod> getMethodsForGoal(Symbol functor) {
        return this.methodsPerGoal.get(functor);
    }
}

