/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.Parameter;
import ai.ahtn.domain.PredefinedFunctions;
import ai.ahtn.domain.Term;
import java.util.List;
import rts.GameState;

public class Function
extends Term
implements Parameter {
    public static int DEBUG = 0;

    public static Function fromLispElement(LispElement e) throws Exception {
        Term t = Term.fromLispElement(e);
        Function f = new Function();
        f.functor = t.functor;
        f.parameters = t.parameters;
        return f;
    }

    @Override
    public List<Binding> match(int v) {
        System.err.println("Function.match not implemented yet");
        return null;
    }

    @Override
    public List<Binding> match(String s) {
        System.err.println("Function.match not implemented yet");
        return null;
    }

    @Override
    public Term clone() {
        Function t = new Function();
        t.functor = this.functor;
        t.parameters = new Parameter[this.parameters.length];
        for (int i = 0; i < t.parameters.length; ++i) {
            t.parameters[i] = this.parameters[i].cloneParameter();
        }
        return t;
    }

    @Override
    public Parameter cloneParameter() {
        return (Function)this.clone();
    }

    @Override
    public Parameter resolveParameter(List<Binding> l, GameState gs) throws Exception {
        Function f = this;
        if (l != null && !l.isEmpty()) {
            f = new Function();
            f.functor = this.functor;
            f.parameters = new Parameter[this.parameters.length];
            for (int i = 0; i < f.parameters.length; ++i) {
                f.parameters[i] = this.parameters[i].resolveParameter(l, gs);
            }
        }
        if (f.isGround()) {
            Parameter p = PredefinedFunctions.evaluate(f, gs);
            if (DEBUG >= 1) {
                System.out.println("Function.resolveParameter: " + this + " -> " + p);
            }
            return p;
        }
        return f;
    }

    @Override
    public Parameter applyBindingsParameter(List<Binding> l) throws Exception {
        Function f = this;
        if (!l.isEmpty()) {
            f = new Function();
            f.functor = this.functor;
            f.parameters = new Parameter[this.parameters.length];
            for (int i = 0; i < f.parameters.length; ++i) {
                f.parameters[i] = this.parameters[i].applyBindingsParameter(l);
            }
        }
        return f;
    }
}

