/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.Term;
import ai.ahtn.planner.AdversarialChoicePoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rts.GameState;

public class HTNMethod {
    String name;
    Term head;
    MethodDecomposition method;

    public HTNMethod(String n, Term h, MethodDecomposition m) {
        this.name = n;
        this.head = h;
        this.method = m;
    }

    public String getName() {
        return this.name;
    }

    public Term getHead() {
        return this.head;
    }

    public MethodDecomposition getDecomposition() {
        return this.method;
    }

    public HTNMethod clone() {
        HTNMethod c = new HTNMethod(this.name, this.head.clone(), this.method.clone());
        return c;
    }

    public HTNMethod cloneTrackingDescendants(MethodDecomposition[] descendantsToTrack, MethodDecomposition[] newDescendants) {
        HTNMethod c = new HTNMethod(this.name, this.head.clone(), this.method.cloneTrackingDescendants(descendantsToTrack, newDescendants));
        return c;
    }

    public void renameVariables(int renamingIndex) {
        this.head.renameVariables(renamingIndex);
        this.method.renameVariables(renamingIndex);
    }

    public void applyBindings(List<Binding> l) throws Exception {
        this.head.applyBindings(l);
        this.method.applyBindings(l);
    }

    public static HTNMethod fromLispElement(LispElement e) throws Exception {
        LispElement name_e = e.children.get(1);
        LispElement head_e = e.children.get(2);
        LispElement method_e = e.children.get(3);
        String name = name_e.element;
        Term head = Term.fromLispElement(head_e);
        MethodDecomposition m = MethodDecomposition.fromLispElement(method_e);
        return new HTNMethod(name, head, m);
    }

    public void replaceSingletonsByWildcards() throws Exception {
        List<Symbol> singletons = this.findSingletons();
        this.head.replaceSingletonsByWildcards(singletons);
        this.method.replaceSingletonsByWildcards(singletons);
    }

    public List<Symbol> findSingletons() throws Exception {
        HashMap<Symbol, Integer> appearances = new HashMap<Symbol, Integer>();
        this.countVariableAppearances(appearances);
        ArrayList<Symbol> l = new ArrayList<Symbol>();
        for (Symbol v : appearances.keySet()) {
            if (appearances.get(v) != 1) continue;
            l.add(v);
        }
        return l;
    }

    public void countVariableAppearances(HashMap<Symbol, Integer> appearances) throws Exception {
        this.head.countVariableAppearances(appearances);
        this.method.countVariableAppearances(appearances);
    }

    public String toString() {
        return "method(" + this.name + "): " + this.head + ", decomposition: " + this.method;
    }

    public int executionCycle(GameState gs, List<MethodDecomposition> actions2, List<MethodDecomposition> choicePoints) {
        return this.method.executionCycle(gs, actions2, choicePoints);
    }

    public int executionCycle(GameState gs, List<MethodDecomposition> actions2, List<MethodDecomposition> choicePoints, AdversarialChoicePoint previous_cp) {
        return this.method.executionCycle(gs, actions2, choicePoints, previous_cp);
    }
}

