/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain.LispParser;

import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.LispParser.LispTokenizer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;

public class LispParser {
    public static int DEBUG = 0;

    public static List<LispElement> parseString(String s) throws Exception {
        BufferedReader br = new BufferedReader(new StringReader(s));
        return LispParser.parseLisp(br);
    }

    public static List<LispElement> parseLispFile(String fileName) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        return LispParser.parseLisp(br);
    }

    public static List<LispElement> parseLisp(BufferedReader br) throws Exception {
        LinkedList<LispElement> l = new LinkedList<LispElement>();
        LinkedList<LispElement> stack = new LinkedList<LispElement>();
        LispTokenizer lt = new LispTokenizer(br);
        String token = lt.nextToken();
        while (token != null) {
            if (DEBUG >= 1) {
                System.out.println("next token: " + token);
            }
            if (token.equals("(")) {
                stack.add(0, new LispElement());
            } else if (token.equals(")")) {
                LispElement e = (LispElement)stack.remove(0);
                if (stack.isEmpty()) {
                    l.add(e);
                } else {
                    ((LispElement)stack.get((int)0)).children.add(e);
                }
            } else if (stack.isEmpty()) {
                l.add(new LispElement(token));
            } else {
                ((LispElement)stack.get((int)0)).children.add(new LispElement(token));
            }
            token = lt.nextToken();
        }
        return l;
    }
}

