/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain.LispParser;

import java.io.BufferedReader;

public class LispTokenizer {
    BufferedReader br;
    int nextCharacter = -1;

    public LispTokenizer(BufferedReader a_br) {
        this.br = a_br;
    }

    public int nextCharacter() throws Exception {
        if (this.nextCharacter == -1) {
            return this.br.read();
        }
        int tmp = this.nextCharacter;
        this.nextCharacter = -1;
        return tmp;
    }

    public String nextToken() throws Exception {
        int c;
        if (!this.br.ready()) {
            return null;
        }
        StringBuilder currentToken = null;
        while ((c = this.nextCharacter()) != -1) {
            if (c == 59) {
                this.br.readLine();
                if (currentToken != null) {
                    return currentToken.toString();
                }
            } else if (c == 32 || c == 10 || c == 13 || c == 9) {
                if (currentToken != null) {
                    return currentToken.toString();
                }
            } else {
                if (c == 40 || c == 41) {
                    if (currentToken == null) {
                        return "" + (char)c;
                    }
                    this.nextCharacter = c;
                    return currentToken.toString();
                }
                if (currentToken == null) {
                    currentToken = new StringBuilder("" + (char)c);
                } else {
                    currentToken.append((char)c);
                }
                if (currentToken.length() >= 2 && currentToken.toString().endsWith("#|")) {
                    currentToken = new StringBuilder(currentToken.substring(0, currentToken.length() - 2));
                    int previous = -1;
                    while (this.br.ready() && (c = this.nextCharacter()) != -1 && (c != 35 || previous != 124)) {
                        previous = c;
                    }
                    if (currentToken.length() == 0) {
                        currentToken = null;
                    } else {
                        return currentToken.toString();
                    }
                }
            }
            if (this.br.ready()) continue;
        }
        return currentToken.toString();
    }
}

