/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.Clause;
import ai.ahtn.domain.HTNMethod;
import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.Term;
import ai.ahtn.planner.AdversarialChoicePoint;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import rts.GameState;
import util.Pair;

public class MethodDecomposition {
    public static int DEBUG = 0;
    public static final int METHOD_CONDITION = 0;
    public static final int METHOD_OPERATOR = 1;
    public static final int METHOD_METHOD = 2;
    public static final int METHOD_SEQUENCE = 3;
    public static final int METHOD_PARALLEL = 4;
    public static final int METHOD_NON_BRANCHING_CONDITION = 5;
    public static final int EXECUTION_SUCCESS = 0;
    public static final int EXECUTION_FAILURE = 1;
    public static final int EXECUTION_ACTION_ISSUE = 2;
    public static final int EXECUTION_WAITING_FOR_ACTION = 3;
    public static final int EXECUTION_CHOICE_POINT = 4;
    protected int type = 0;
    protected Clause clause;
    protected Term term;
    protected MethodDecomposition[] subelements;
    HTNMethod method;
    int executionState = 0;
    int operatorExecutingState = 0;
    List<MethodDecomposition> operatorsBeingExecuted;
    Term updatedTerm;
    int updatedTermCycle = -1;

    public MethodDecomposition() {
    }

    public MethodDecomposition(Term t, HTNMethod m) {
        this.type = 2;
        this.term = t;
        this.method = m;
    }

    public MethodDecomposition(Term t) {
        this.type = 1;
        this.term = t;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int a_type) {
        this.type = a_type;
    }

    public Clause getClause() {
        return this.clause;
    }

    public Term getTerm() {
        return this.term;
    }

    public Term getUpdatedTerm() {
        return this.updatedTerm;
    }

    public void setUpdatedTerm(Term ut) {
        this.updatedTerm = ut;
    }

    public int getUpdatedTermCycle() {
        return this.updatedTermCycle;
    }

    public void setUpdatedTermCycle(int utc) {
        this.updatedTermCycle = utc;
    }

    public HTNMethod getMethod() {
        return this.method;
    }

    public MethodDecomposition[] getSubparts() {
        return this.subelements;
    }

    public void setSubparts(MethodDecomposition[] se) {
        this.subelements = se;
    }

    public int getExecutionState() {
        return this.executionState;
    }

    public int getOperatorExecutingState() {
        return this.operatorExecutingState;
    }

    public List<MethodDecomposition> getOperatorsBeingExecuted() {
        return this.operatorsBeingExecuted;
    }

    public void setOperatorsBeingExecuted(List<MethodDecomposition> l) {
        this.operatorsBeingExecuted = l;
    }

    public void setOperatorExecutingState(int s) {
        this.operatorExecutingState = s;
    }

    public void setMethod(HTNMethod m) {
        this.method = m;
    }

    public void setExecutionState(int es) {
        this.executionState = es;
    }

    public static MethodDecomposition fromLispElement(LispElement e) throws Exception {
        LispElement head = e.children.get(0);
        switch (head.element) {
            case ":condition": {
                MethodDecomposition d = new MethodDecomposition();
                d.type = 0;
                d.clause = Clause.fromLispElement(e.children.get(1));
                return d;
            }
            case ":!condition": {
                MethodDecomposition d = new MethodDecomposition();
                d.type = 5;
                d.clause = Clause.fromLispElement(e.children.get(1));
                return d;
            }
            case ":operator": {
                MethodDecomposition d = new MethodDecomposition();
                d.type = 1;
                d.term = Term.fromLispElement(e.children.get(1));
                return d;
            }
            case ":method": {
                MethodDecomposition d = new MethodDecomposition();
                d.type = 2;
                d.term = Term.fromLispElement(e.children.get(1));
                return d;
            }
            case ":sequence": {
                MethodDecomposition d = new MethodDecomposition();
                d.type = 3;
                d.subelements = new MethodDecomposition[e.children.size() - 1];
                for (int i = 0; i < e.children.size() - 1; ++i) {
                    d.subelements[i] = MethodDecomposition.fromLispElement(e.children.get(i + 1));
                }
                return d;
            }
            case ":parallel": {
                MethodDecomposition d = new MethodDecomposition();
                d.type = 4;
                d.subelements = new MethodDecomposition[e.children.size() - 1];
                for (int i = 0; i < e.children.size() - 1; ++i) {
                    d.subelements[i] = MethodDecomposition.fromLispElement(e.children.get(i + 1));
                }
                return d;
            }
        }
        throw new Exception("unrecognized method decomposition!: " + head.element);
    }

    public String toString() {
        switch (this.type) {
            case 0: {
                return "(:condition " + this.clause + ")";
            }
            case 5: {
                return "(:!condition " + this.clause + ")";
            }
            case 1: {
                if (this.updatedTerm != null) {
                    return "(:operator " + this.updatedTerm + ")";
                }
                return "(:operator " + this.term + ")";
            }
            case 2: {
                if (this.method == null) {
                    return "(:method " + this.term + ")";
                }
                return "(" + this.method + ")";
            }
            case 3: {
                StringBuilder sb = new StringBuilder();
                sb.append("(:sequence");
                for (MethodDecomposition subelement : this.subelements) {
                    sb.append(" ");
                    sb.append(subelement);
                }
                sb.append(")");
                return sb.toString();
            }
            case 4: {
                StringBuilder sb = new StringBuilder();
                sb.append("(:parallel");
                for (MethodDecomposition subelement : this.subelements) {
                    sb.append(" ");
                    sb.append(subelement);
                }
                sb.append(")");
                return sb.toString();
            }
        }
        return null;
    }

    public void printDetailed() {
        this.printDetailed(0);
    }

    public void printDetailed(int tabs) {
        int j;
        for (j = 0; j < tabs; ++j) {
            System.out.print("  ");
        }
        switch (this.type) {
            case 0: {
                System.out.println(this.hashCode() + " - " + this.executionState + " - (:condition " + this.clause + ")");
                break;
            }
            case 5: {
                System.out.println(this.hashCode() + " - " + this.executionState + " - (:!condition " + this.clause + ")");
                break;
            }
            case 1: {
                if (this.updatedTerm != null) {
                    System.out.println(this.hashCode() + " - " + this.executionState + " - (:operator " + this.updatedTerm + ")");
                    break;
                }
                System.out.println(this.hashCode() + " - " + this.executionState + " - (:operator " + this.term + ")");
                break;
            }
            case 2: {
                if (this.method != null) {
                    System.out.println(this.hashCode() + " - " + this.executionState + " - (:method " + this.method.head + ")");
                    for (j = 0; j < tabs; ++j) {
                        System.out.print("  ");
                    }
                    System.out.println("Decomposition:");
                    this.method.getDecomposition().printDetailed(tabs + 1);
                    break;
                }
                System.out.println(this.hashCode() + " - " + this.executionState + " - (:method " + this.term + ")");
                break;
            }
            case 3: {
                System.out.println(this.hashCode() + " - " + this.executionState + " - (:sequence");
                for (MethodDecomposition subelement : this.subelements) {
                    subelement.printDetailed(tabs + 1);
                }
                for (int j2 = 0; j2 < tabs; ++j2) {
                    System.out.print("  ");
                }
                System.out.println(")");
                break;
            }
            case 4: {
                System.out.println(this.hashCode() + " - " + this.executionState + " - (:parallel");
                for (MethodDecomposition subelement : this.subelements) {
                    subelement.printDetailed(tabs + 1);
                }
                for (int j3 = 0; j3 < tabs; ++j3) {
                    System.out.print("  ");
                }
                System.out.println(")");
            }
        }
    }

    public List<MethodDecomposition> getLeaves() {
        ArrayList<MethodDecomposition> l = new ArrayList<MethodDecomposition>();
        if (this.subelements == null) {
            if (this.method != null) {
                l.addAll(this.method.getDecomposition().getLeaves());
            } else {
                l.add(this);
            }
        } else {
            for (MethodDecomposition md : this.subelements) {
                l.addAll(md.getLeaves());
            }
        }
        return l;
    }

    public MethodDecomposition clone() {
        MethodDecomposition c = new MethodDecomposition();
        c.type = this.type;
        if (this.clause != null) {
            c.clause = this.clause.clone();
        }
        if (this.term != null) {
            c.term = this.term.clone();
        }
        if (this.updatedTerm != null) {
            c.updatedTerm = this.updatedTerm.clone();
        }
        c.updatedTermCycle = this.updatedTermCycle;
        c.executionState = this.executionState;
        c.operatorExecutingState = this.operatorExecutingState;
        if (this.subelements != null) {
            c.subelements = new MethodDecomposition[this.subelements.length];
            for (int i = 0; i < this.subelements.length; ++i) {
                c.subelements[i] = this.subelements[i].clone();
            }
        }
        if (this.method != null) {
            c.method = this.method.clone();
        }
        return c;
    }

    public MethodDecomposition cloneTrackingDescendants(MethodDecomposition[] descendantsToTrack, MethodDecomposition[] newDescendants) {
        int i;
        MethodDecomposition c = new MethodDecomposition();
        for (i = 0; i < descendantsToTrack.length; ++i) {
            if (descendantsToTrack[i] != this) continue;
            newDescendants[i] = c;
        }
        c.type = this.type;
        if (this.clause != null) {
            c.clause = this.clause.clone();
        }
        if (this.term != null) {
            c.term = this.term.clone();
        }
        if (this.updatedTerm != null) {
            c.updatedTerm = this.updatedTerm.clone();
        }
        c.updatedTermCycle = this.updatedTermCycle;
        c.executionState = this.executionState;
        c.operatorExecutingState = this.operatorExecutingState;
        if (this.subelements != null) {
            c.subelements = new MethodDecomposition[this.subelements.length];
            for (i = 0; i < this.subelements.length; ++i) {
                c.subelements[i] = this.subelements[i].cloneTrackingDescendants(descendantsToTrack, newDescendants);
            }
        }
        if (this.method != null) {
            c.method = this.method.cloneTrackingDescendants(descendantsToTrack, newDescendants);
        }
        return c;
    }

    public void renameVariables(int renamingIndex) {
        if (this.clause != null) {
            this.clause.renameVariables(renamingIndex);
        }
        if (this.term != null) {
            this.term.renameVariables(renamingIndex);
        }
        if (this.updatedTerm != null) {
            this.updatedTerm.renameVariables(renamingIndex);
        }
        if (this.subelements != null) {
            for (MethodDecomposition subelement : this.subelements) {
                subelement.renameVariables(renamingIndex);
            }
        }
        if (this.method != null) {
            this.method.renameVariables(renamingIndex);
        }
    }

    public void applyBindings(List<Binding> l) throws Exception {
        if (this.clause != null) {
            this.clause.applyBindings(l);
        }
        if (this.term != null) {
            this.term.applyBindings(l);
        }
        if (this.updatedTerm != null) {
            this.updatedTerm.applyBindings(l);
        }
        if (this.subelements != null) {
            for (MethodDecomposition subelement : this.subelements) {
                subelement.applyBindings(l);
            }
        }
        if (this.method != null) {
            this.method.applyBindings(l);
        }
    }

    public void executionReset() {
        this.executionState = 0;
        this.operatorExecutingState = 0;
        this.operatorsBeingExecuted = null;
        if (this.subelements != null) {
            for (MethodDecomposition subelement : this.subelements) {
                subelement.executionReset();
            }
        }
        if (this.method != null) {
            this.method.getDecomposition().executionReset();
        }
    }

    public int executionCycle(GameState gs, List<MethodDecomposition> actions2, List<MethodDecomposition> choicePoints) {
        switch (this.type) {
            case 0: 
            case 5: {
                if (this.executionState == 0) {
                    choicePoints.add(this);
                    return 4;
                }
                if (this.executionState == 1) {
                    return 0;
                }
                return 1;
            }
            case 1: {
                if (this.executionState == 0) {
                    actions2.add(this);
                    return 2;
                }
                if (this.executionState == 1) {
                    return 3;
                }
                return 0;
            }
            case 2: {
                if (this.method == null) {
                    choicePoints.add(this);
                    return 4;
                }
                return this.method.executionCycle(gs, actions2, choicePoints);
            }
            case 3: {
                int tmp;
                while (true) {
                    if (this.executionState >= this.subelements.length) {
                        return 0;
                    }
                    tmp = this.subelements[this.executionState].executionCycle(gs, actions2, choicePoints);
                    if (tmp != 0) break;
                    ++this.executionState;
                }
                return tmp;
            }
            case 4: {
                boolean allSuccess = true;
                boolean anyActionIssue = false;
                for (MethodDecomposition subelement : this.subelements) {
                    int tmp = subelement.executionCycle(gs, actions2, choicePoints);
                    if (tmp == 2) {
                        anyActionIssue = true;
                    }
                    if (tmp == 4 || tmp == 1) {
                        return tmp;
                    }
                    if (tmp == 0) continue;
                    allSuccess = false;
                }
                if (allSuccess) {
                    return 0;
                }
                if (anyActionIssue) {
                    return 2;
                }
                return 3;
            }
        }
        return 0;
    }

    public int executionCycle(GameState gs, List<MethodDecomposition> actions2, List<MethodDecomposition> choicePoints, AdversarialChoicePoint previous_cp) {
        switch (this.type) {
            case 0: 
            case 5: {
                if (this.executionState == 0) {
                    choicePoints.add(this);
                    return 4;
                }
                if (this.executionState == 1) {
                    return 0;
                }
                return 1;
            }
            case 1: {
                if (this.executionState == 0) {
                    previous_cp.captureExecutionStateNonRecursive(this);
                    actions2.add(this);
                    return 2;
                }
                if (this.executionState == 1) {
                    return 3;
                }
                return 0;
            }
            case 2: {
                if (this.method == null) {
                    choicePoints.add(this);
                    return 4;
                }
                return this.method.executionCycle(gs, actions2, choicePoints, previous_cp);
            }
            case 3: {
                int tmp;
                while (true) {
                    if (this.executionState >= this.subelements.length) {
                        return 0;
                    }
                    tmp = this.subelements[this.executionState].executionCycle(gs, actions2, choicePoints, previous_cp);
                    if (tmp != 0) break;
                    previous_cp.captureExecutionStateNonRecursive(this);
                    ++this.executionState;
                }
                return tmp;
            }
            case 4: {
                boolean allSuccess = true;
                boolean anyActionIssue = false;
                for (MethodDecomposition subelement : this.subelements) {
                    int tmp = subelement.executionCycle(gs, actions2, choicePoints, previous_cp);
                    if (tmp == 2) {
                        anyActionIssue = true;
                    }
                    if (tmp == 4 || tmp == 1) {
                        return tmp;
                    }
                    if (tmp == 0) continue;
                    allSuccess = false;
                }
                if (allSuccess) {
                    return 0;
                }
                if (anyActionIssue) {
                    return 2;
                }
                return 3;
            }
        }
        return 0;
    }

    public List<Pair<Integer, List<Term>>> convertToOperatorList() throws Exception {
        ArrayList<Pair<Integer, List<Term>>> l = new ArrayList<Pair<Integer, List<Term>>>();
        this.convertToOperatorList(l);
        l.sort(new Comparator<Pair<Integer, List<Term>>>(){

            @Override
            public int compare(Pair<Integer, List<Term>> o1, Pair<Integer, List<Term>> o2) {
                return Integer.compare((Integer)o1.m_a, (Integer)o2.m_a);
            }
        });
        return l;
    }

    public void convertToOperatorList(List<Pair<Integer, List<Term>>> l) throws Exception {
        switch (this.type) {
            case 0: {
                return;
            }
            case 5: {
                return;
            }
            case 1: {
                if (this.updatedTerm == null) break;
                if (l.isEmpty()) {
                    Pair tmp = new Pair(this.updatedTermCycle, new ArrayList());
                    ((List)tmp.m_b).add(this.updatedTerm);
                    l.add(tmp);
                    break;
                }
                Pair<Integer, List<Term>> tmp = l.get(l.size() - 1);
                if ((Integer)tmp.m_a == this.updatedTermCycle) {
                    ((List)tmp.m_b).add(this.updatedTerm);
                    break;
                }
                tmp = new Pair(this.updatedTermCycle, new ArrayList());
                ((List)tmp.m_b).add(this.updatedTerm);
                l.add(tmp);
                break;
            }
            case 2: {
                if (this.method == null) break;
                this.method.getDecomposition().convertToOperatorList(l);
                break;
            }
            case 3: 
            case 4: {
                if (this.subelements == null) break;
                for (MethodDecomposition subelement : this.subelements) {
                    subelement.convertToOperatorList(l);
                }
                break;
            }
        }
    }

    public void countVariableAppearances(HashMap<Symbol, Integer> appearances) throws Exception {
        if (this.clause != null) {
            this.clause.countVariableAppearances(appearances);
        }
        if (this.term != null) {
            this.term.countVariableAppearances(appearances);
        }
        if (this.subelements != null) {
            for (MethodDecomposition md : this.subelements) {
                md.countVariableAppearances(appearances);
            }
        }
    }

    public void replaceSingletonsByWildcards(List<Symbol> singletons) throws Exception {
        if (this.clause != null) {
            this.clause.replaceSingletonsByWildcards(singletons);
        }
        if (this.term != null) {
            this.term.replaceSingletonsByWildcards(singletons);
        }
        if (this.subelements != null) {
            for (MethodDecomposition md : this.subelements) {
                md.replaceSingletonsByWildcards(singletons);
            }
        }
    }
}

