/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Function;
import ai.ahtn.domain.IntegerConstant;
import ai.ahtn.domain.Parameter;
import ai.ahtn.domain.Symbol;
import java.util.HashMap;
import rts.GameState;

public class PredefinedFunctions {
    public static int DEBUG = 0;
    static final HashMap<Symbol, FunctionEvaluator> functions = new HashMap();

    public static Parameter evaluate(Function f, GameState gs) throws Exception {
        FunctionEvaluator fe = functions.get(f.functor);
        if (fe == null) {
            System.err.println("PredefinedFunctions.evaluate: undefined function " + f);
            return null;
        }
        return fe.evaluate(f, gs);
    }

    static {
        try {
            functions.put(new Symbol("neighbor-position"), new FunctionEvaluator(){

                @Override
                public Parameter evaluate(Function f, GameState gs) throws Exception {
                    if (f.parameters.length != 2) {
                        return null;
                    }
                    if (f.parameters[0] instanceof IntegerConstant && f.parameters[1] instanceof IntegerConstant) {
                        int pos = ((IntegerConstant)f.parameters[0]).value;
                        int dir = ((IntegerConstant)f.parameters[1]).value;
                        switch (dir) {
                            case 0: {
                                return new IntegerConstant(pos - gs.getPhysicalGameState().getWidth());
                            }
                            case 1: {
                                return new IntegerConstant(pos + 1);
                            }
                            case 2: {
                                return new IntegerConstant(pos + gs.getPhysicalGameState().getWidth());
                            }
                            case 3: {
                                return new IntegerConstant(pos - 1);
                            }
                        }
                    }
                    return null;
                }
            });
            functions.put(new Symbol("+"), new FunctionEvaluator(){

                @Override
                public Parameter evaluate(Function f, GameState gs) throws Exception {
                    if (f.parameters.length != 2) {
                        return null;
                    }
                    if (f.parameters[0] instanceof IntegerConstant && f.parameters[1] instanceof IntegerConstant) {
                        int p1 = ((IntegerConstant)f.parameters[0]).value;
                        int p2 = ((IntegerConstant)f.parameters[1]).value;
                        return new IntegerConstant(p1 + p2);
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface FunctionEvaluator {
        public Parameter evaluate(Function var1, GameState var2) throws Exception;
    }
}

