/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.ahtn.domain.IntegerConstant;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.domain.Parameter;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.SymbolConstant;
import ai.ahtn.domain.Term;
import java.util.HashMap;
import rts.GameState;
import rts.PlayerAction;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import util.Pair;

public class PredefinedOperators {
    public static int DEBUG = 0;
    static PathFinding pf = new AStarPathFinding();
    static final HashMap<Symbol, OperatorExecutor> operators = new HashMap();

    public static boolean execute(MethodDecomposition state, GameState gs) throws Exception {
        OperatorExecutor oe;
        Term t = state.updatedTerm;
        if (t == null) {
            t = state.term;
        }
        if ((oe = operators.get(t.functor)) == null) {
            throw new Exception("PredefinedFunctions.evaluate: undefined operator " + t);
        }
        return oe.execute(t, state, gs, null);
    }

    public static boolean execute(MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
        OperatorExecutor oe;
        Term t = state.updatedTerm;
        if (t == null) {
            t = state.term;
        }
        if ((oe = operators.get(t.functor)) == null) {
            throw new Exception("PredefinedFunctions.evaluate: undefined operator " + t);
        }
        return oe.execute(t, state, gs, pa);
    }

    static {
        try {
            operators.put(new Symbol("!wait"), new OperatorExecutor(){

                @Override
                public boolean execute(Term t, MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
                    int time = ((IntegerConstant)t.parameters[0]).value;
                    if (state.getOperatorExecutingState() == 1) {
                        return gs.getTime() - state.getUpdatedTermCycle() >= time;
                    }
                    state.setOperatorExecutingState(1);
                    return false;
                }
            });
            operators.put(new Symbol("!wait-for-free-unit"), new OperatorExecutor(){

                @Override
                public boolean execute(Term t, MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
                    int player = ((IntegerConstant)t.parameters[0]).value;
                    for (Unit u : gs.getUnits()) {
                        if (u.getPlayer() != player || gs.getUnitAction(u) != null) continue;
                        return true;
                    }
                    return false;
                }
            });
            operators.put(new Symbol("!fill-with-idles"), new OperatorExecutor(){

                @Override
                public boolean execute(Term t, MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
                    int player = ((IntegerConstant)t.parameters[0]).value;
                    if (pa == null) {
                        pa = new PlayerAction();
                        for (Unit u : gs.getUnits()) {
                            if (u.getPlayer() != player || gs.getUnitAction(u) != null) continue;
                            pa.addUnitAction(u, new UnitAction(0, 10));
                        }
                        gs.issue(pa);
                    } else {
                        for (Unit u : gs.getUnits()) {
                            if (u.getPlayer() != player || pa.getAction(u) != null || gs.getUnitAction(u) != null) continue;
                            pa.addUnitAction(u, new UnitAction(0, 10));
                        }
                    }
                    return true;
                }
            });
            operators.put(new Symbol("!idle"), new OperatorExecutor(){

                @Override
                public boolean execute(Term t, MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
                    int uID1 = ((IntegerConstant)t.parameters[0]).value;
                    Unit u1 = gs.getUnit(uID1);
                    if (u1 == null) {
                        return true;
                    }
                    if (state.getOperatorExecutingState() == 1) {
                        return gs.getUnitAction(u1) == null;
                    }
                    if (pa == null) {
                        pa = new PlayerAction();
                        pa.addUnitAction(u1, new UnitAction(0, 10));
                        gs.issue(pa);
                    } else {
                        pa.addUnitAction(u1, new UnitAction(0, 10));
                    }
                    state.setOperatorExecutingState(1);
                    return false;
                }
            });
            operators.put(new Symbol("!attack"), new OperatorExecutor(){

                @Override
                public boolean execute(Term t, MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
                    int uID1 = ((IntegerConstant)t.parameters[0]).value;
                    Unit u1 = gs.getUnit(uID1);
                    if (u1 == null) {
                        return true;
                    }
                    if (gs.getUnitAction(u1) != null) {
                        return false;
                    }
                    if (state.getOperatorExecutingState() == 1) {
                        return gs.getUnitAction(u1) == null;
                    }
                    int uID2 = ((IntegerConstant)t.parameters[1]).value;
                    Unit u2 = gs.getUnit(uID2);
                    if (u2 == null) {
                        return true;
                    }
                    if (pa == null) {
                        pa = new PlayerAction();
                        pa.addUnitAction(u1, new UnitAction(5, u2.getX(), u2.getY()));
                        gs.issue(pa);
                    } else {
                        pa.addUnitAction(u1, new UnitAction(5, u2.getX(), u2.getY()));
                    }
                    state.setOperatorExecutingState(1);
                    return false;
                }
            });
            operators.put(new Symbol("!harvest"), new OperatorExecutor(){

                @Override
                public boolean execute(Term t, MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
                    int uID1 = ((IntegerConstant)t.parameters[0]).value;
                    Unit u1 = gs.getUnit(uID1);
                    if (u1 == null) {
                        return true;
                    }
                    if (gs.getUnitAction(u1) != null) {
                        return false;
                    }
                    if (state.getOperatorExecutingState() == 1) {
                        return gs.getUnitAction(u1) == null;
                    }
                    int uID2 = ((IntegerConstant)t.parameters[1]).value;
                    Unit u2 = gs.getUnit(uID2);
                    if (u2 == null) {
                        return true;
                    }
                    if (pa == null) {
                        pa = new PlayerAction();
                        if (u1.getX() == u2.getX() - 1) {
                            pa.addUnitAction(u1, new UnitAction(2, 1));
                        }
                        if (u1.getX() == u2.getX() + 1) {
                            pa.addUnitAction(u1, new UnitAction(2, 3));
                        }
                        if (u1.getY() == u2.getY() - 1) {
                            pa.addUnitAction(u1, new UnitAction(2, 2));
                        }
                        if (u1.getY() == u2.getY() + 1) {
                            pa.addUnitAction(u1, new UnitAction(2, 0));
                        }
                        gs.issue(pa);
                    } else {
                        if (u1.getX() == u2.getX() - 1) {
                            pa.addUnitAction(u1, new UnitAction(2, 1));
                        }
                        if (u1.getX() == u2.getX() + 1) {
                            pa.addUnitAction(u1, new UnitAction(2, 3));
                        }
                        if (u1.getY() == u2.getY() - 1) {
                            pa.addUnitAction(u1, new UnitAction(2, 2));
                        }
                        if (u1.getY() == u2.getY() + 1) {
                            pa.addUnitAction(u1, new UnitAction(2, 0));
                        }
                    }
                    state.setOperatorExecutingState(1);
                    return false;
                }
            });
            operators.put(new Symbol("!return"), new OperatorExecutor(){

                @Override
                public boolean execute(Term t, MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
                    int uID1 = ((IntegerConstant)t.parameters[0]).value;
                    Unit u1 = gs.getUnit(uID1);
                    if (u1 == null) {
                        return true;
                    }
                    if (gs.getUnitAction(u1) != null) {
                        return false;
                    }
                    if (state.getOperatorExecutingState() == 1) {
                        return gs.getUnitAction(u1) == null;
                    }
                    int uID2 = ((IntegerConstant)t.parameters[1]).value;
                    Unit u2 = gs.getUnit(uID2);
                    if (u2 == null) {
                        return true;
                    }
                    if (pa == null) {
                        pa = new PlayerAction();
                        if (u1.getX() == u2.getX() - 1) {
                            pa.addUnitAction(u1, new UnitAction(3, 1));
                        }
                        if (u1.getX() == u2.getX() + 1) {
                            pa.addUnitAction(u1, new UnitAction(3, 3));
                        }
                        if (u1.getY() == u2.getY() - 1) {
                            pa.addUnitAction(u1, new UnitAction(3, 2));
                        }
                        if (u1.getY() == u2.getY() + 1) {
                            pa.addUnitAction(u1, new UnitAction(3, 0));
                        }
                        gs.issue(pa);
                    } else {
                        if (u1.getX() == u2.getX() - 1) {
                            pa.addUnitAction(u1, new UnitAction(3, 1));
                        }
                        if (u1.getX() == u2.getX() + 1) {
                            pa.addUnitAction(u1, new UnitAction(3, 3));
                        }
                        if (u1.getY() == u2.getY() - 1) {
                            pa.addUnitAction(u1, new UnitAction(3, 2));
                        }
                        if (u1.getY() == u2.getY() + 1) {
                            pa.addUnitAction(u1, new UnitAction(3, 0));
                        }
                    }
                    state.setOperatorExecutingState(1);
                    return false;
                }
            });
            operators.put(new Symbol("!produce"), new OperatorExecutor(){

                @Override
                public boolean execute(Term t, MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
                    int uID1 = ((IntegerConstant)t.parameters[0]).value;
                    Unit u1 = gs.getUnit(uID1);
                    if (u1 == null) {
                        return true;
                    }
                    if (gs.getUnitAction(u1) != null) {
                        return false;
                    }
                    if (state.getOperatorExecutingState() == 1) {
                        return gs.getUnitAction(u1) == null;
                    }
                    int direction = ((IntegerConstant)t.parameters[1]).value;
                    String type = ((SymbolConstant)t.parameters[2]).get();
                    UnitType ut = gs.getUnitTypeTable().getUnitType(type);
                    ResourceUsage ru = gs.getResourceUsage();
                    if (pa != null) {
                        for (Pair<Unit, UnitAction> tmp : pa.getActions()) {
                            ru.merge(((UnitAction)tmp.m_b).resourceUsage((Unit)tmp.m_a, gs.getPhysicalGameState()));
                        }
                    }
                    int posx = u1.getX() + UnitAction.DIRECTION_OFFSET_X[direction];
                    int posy = u1.getY() + UnitAction.DIRECTION_OFFSET_Y[direction];
                    if (posx >= 0 && posx < gs.getPhysicalGameState().getWidth() && posy >= 0 && posy < gs.getPhysicalGameState().getHeight() && gs.free(posx, posy) && gs.getPlayer(u1.getPlayer()).getResources() - ru.getResourcesUsed(u1.getPlayer()) >= ut.cost) {
                        if (pa == null) {
                            pa = new PlayerAction();
                            pa.addUnitAction(u1, new UnitAction(4, direction, ut));
                            gs.issue(pa);
                        } else {
                            UnitAction ua = new UnitAction(4, direction, ut);
                            ResourceUsage ru2 = ua.resourceUsage(u1, gs.getPhysicalGameState());
                            pa.getResourceUsage().merge(ru2);
                            pa.addUnitAction(u1, ua);
                        }
                        state.setOperatorExecutingState(1);
                    }
                    return false;
                }
            });
            operators.put(new Symbol("!move"), new OperatorExecutor(){

                @Override
                public boolean execute(Term t, MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
                    int uID1;
                    Unit u1;
                    ResourceUsage ru = gs.getResourceUsage();
                    if (pa != null) {
                        for (Pair<Unit, UnitAction> tmp : pa.getActions()) {
                            ru.merge(((UnitAction)tmp.m_b).resourceUsage((Unit)tmp.m_a, gs.getPhysicalGameState()));
                        }
                    }
                    if ((u1 = gs.getUnit(uID1 = ((IntegerConstant)t.parameters[0]).value)) == null) {
                        return true;
                    }
                    if (gs.getUnitAction(u1) == null) {
                        Parameter p = t.parameters[1].resolveParameter(null, gs);
                        int pos2 = ((IntegerConstant)p).value;
                        UnitAction ua = pf.findPath(u1, pos2, gs, ru);
                        if (ua != null) {
                            if (pa == null) {
                                pa = new PlayerAction();
                                pa.addUnitAction(u1, ua);
                                gs.issue(pa);
                            } else {
                                ResourceUsage ru2 = ua.resourceUsage(u1, gs.getPhysicalGameState());
                                pa.getResourceUsage().merge(ru2);
                                pa.addUnitAction(u1, ua);
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            });
            operators.put(new Symbol("!move-into-attack-range"), new OperatorExecutor(){

                @Override
                public boolean execute(Term t, MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
                    int uID1;
                    Unit u1;
                    ResourceUsage ru = gs.getResourceUsage();
                    if (pa != null) {
                        for (Pair<Unit, UnitAction> tmp : pa.getActions()) {
                            ru.merge(((UnitAction)tmp.m_b).resourceUsage((Unit)tmp.m_a, gs.getPhysicalGameState()));
                        }
                    }
                    if ((u1 = gs.getUnit(uID1 = ((IntegerConstant)t.parameters[0]).value)) == null) {
                        return true;
                    }
                    if (gs.getUnitAction(u1) == null) {
                        int uID2 = ((IntegerConstant)t.parameters[1]).value;
                        Unit u2 = gs.getUnit(uID2);
                        if (u2 == null) {
                            return true;
                        }
                        UnitAction ua = pf.findPathToPositionInRange(u1, u2.getPosition(gs.getPhysicalGameState()), u1.getType().attackRange, gs, ru);
                        if (ua != null) {
                            if (pa == null) {
                                pa = new PlayerAction();
                                pa.addUnitAction(u1, ua);
                                gs.issue(pa);
                            } else {
                                ResourceUsage ru2 = ua.resourceUsage(u1, gs.getPhysicalGameState());
                                pa.getResourceUsage().merge(ru2);
                                pa.addUnitAction(u1, ua);
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            });
            operators.put(new Symbol("!move-into-harvest-range"), new OperatorExecutor(){

                @Override
                public boolean execute(Term t, MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
                    int uID1;
                    Unit u1;
                    ResourceUsage ru = gs.getResourceUsage();
                    if (pa != null) {
                        for (Pair<Unit, UnitAction> tmp : pa.getActions()) {
                            ru.merge(((UnitAction)tmp.m_b).resourceUsage((Unit)tmp.m_a, gs.getPhysicalGameState()));
                        }
                    }
                    if ((u1 = gs.getUnit(uID1 = ((IntegerConstant)t.parameters[0]).value)) == null) {
                        return true;
                    }
                    if (gs.getUnitAction(u1) == null) {
                        int uID2 = ((IntegerConstant)t.parameters[1]).value;
                        Unit u2 = gs.getUnit(uID2);
                        if (u2 == null) {
                            return true;
                        }
                        UnitAction ua = pf.findPathToPositionInRange(u1, u2.getPosition(gs.getPhysicalGameState()), 1, gs, ru);
                        if (ua != null) {
                            if (pa == null) {
                                pa = new PlayerAction();
                                pa.addUnitAction(u1, ua);
                                gs.issue(pa);
                            } else {
                                ResourceUsage ru2 = ua.resourceUsage(u1, gs.getPhysicalGameState());
                                pa.getResourceUsage().merge(ru2);
                                pa.addUnitAction(u1, ua);
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            });
            operators.put(new Symbol("!move-into-return-range"), new OperatorExecutor(){

                @Override
                public boolean execute(Term t, MethodDecomposition state, GameState gs, PlayerAction pa) throws Exception {
                    int uID1;
                    Unit u1;
                    ResourceUsage ru = gs.getResourceUsage();
                    if (pa != null) {
                        for (Pair<Unit, UnitAction> tmp : pa.getActions()) {
                            ru.merge(((UnitAction)tmp.m_b).resourceUsage((Unit)tmp.m_a, gs.getPhysicalGameState()));
                        }
                    }
                    if ((u1 = gs.getUnit(uID1 = ((IntegerConstant)t.parameters[0]).value)) == null) {
                        return true;
                    }
                    if (gs.getUnitAction(u1) == null) {
                        int uID2 = ((IntegerConstant)t.parameters[1]).value;
                        Unit u2 = gs.getUnit(uID2);
                        if (u2 == null) {
                            return true;
                        }
                        UnitAction ua = pf.findPathToPositionInRange(u1, u2.getPosition(gs.getPhysicalGameState()), 1, gs, ru);
                        if (ua != null) {
                            if (pa == null) {
                                pa = new PlayerAction();
                                pa.addUnitAction(u1, ua);
                                gs.issue(pa);
                            } else {
                                ResourceUsage ru2 = ua.resourceUsage(u1, gs.getPhysicalGameState());
                                pa.getResourceUsage().merge(ru2);
                                pa.addUnitAction(u1, ua);
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface OperatorExecutor {
        public boolean execute(Term var1, MethodDecomposition var2, GameState var3, PlayerAction var4) throws Exception;
    }
}

