/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.abstraction.pathfinding.AStarPathFinding;
import ai.abstraction.pathfinding.PathFinding;
import ai.ahtn.domain.Binding;
import ai.ahtn.domain.IntegerConstant;
import ai.ahtn.domain.Parameter;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.SymbolConstant;
import ai.ahtn.domain.Term;
import ai.ahtn.domain.Variable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;
import rts.Player;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;

public class PredefinedPredicates {
    public static int DEBUG = 0;
    static PathFinding pf = new AStarPathFinding();
    static final HashMap<Symbol, PredicateTester> predicates = new HashMap();

    public static List<Binding> firstMatch(Term term, GameState gs) throws Exception {
        PredicateTester pt = predicates.get(term.functor);
        if (pt == null) {
            System.err.println("PredefinedPredicates.firstMatch: undefined predicate " + term);
            return null;
        }
        return pt.firstMatch(term, gs);
    }

    public static List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
        PredicateTester pt = predicates.get(term.functor);
        if (pt == null) {
            System.err.println("PredefinedPredicates.allMatches: undefined predicate " + term);
            return null;
        }
        return pt.allMatches(term, gs);
    }

    static {
        try {
            predicates.put(new Symbol("="), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    LinkedList<Binding> l = new LinkedList<Binding>();
                    Parameter p1 = term.parameters[0].resolveParameter(null, gs);
                    Parameter p2 = term.parameters[1].resolveParameter(null, gs);
                    if (p1 instanceof Variable) {
                        if (!(p2 instanceof Variable && p2.equals(p1) || ((Variable)p1).ignore())) {
                            l.add(new Binding((Variable)p1, p2));
                        }
                    } else if (p2 instanceof Variable) {
                        if (!((Variable)p2).ignore()) {
                            l.add(new Binding((Variable)p2, p1));
                        }
                    } else if (!p1.equals(p2)) {
                        return null;
                    }
                    return l;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("unit"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    for (Unit u : gs.getUnits()) {
                        Parameter p;
                        List<Binding> b2;
                        List<Binding> b = term.parameters[0].match((int)u.getID());
                        if (b == null || (b2 = (p = term.parameters[1].resolveParameter(b, gs)).match(u.getType().name)) == null) continue;
                        b.addAll(b2);
                        p = term.parameters[2].resolveParameter(b, gs);
                        b2 = p.match(u.getPlayer());
                        if (b2 == null) continue;
                        b.addAll(b2);
                        p = term.parameters[3].resolveParameter(b, gs);
                        b2 = p.match(u.getResources());
                        if (b2 == null) continue;
                        b.addAll(b2);
                        p = term.parameters[4].resolveParameter(b, gs);
                        b2 = p.match(u.getPosition(gs.getPhysicalGameState()));
                        if (b2 == null) continue;
                        b.addAll(b2);
                        return b;
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    for (Unit u : gs.getUnits()) {
                        Parameter p;
                        List<Binding> b2;
                        List<Binding> b = term.parameters[0].match((int)u.getID());
                        if (b == null || (b2 = (p = term.parameters[1].resolveParameter(b, gs)).match(u.getType().name)) == null) continue;
                        b.addAll(b2);
                        p = term.parameters[2].resolveParameter(b, gs);
                        b2 = p.match(u.getPlayer());
                        if (b2 == null) continue;
                        b.addAll(b2);
                        p = term.parameters[3].resolveParameter(b, gs);
                        b2 = p.match(u.getResources());
                        if (b2 == null) continue;
                        b.addAll(b2);
                        p = term.parameters[4].resolveParameter(b, gs);
                        b2 = p.match(u.getPosition(gs.getPhysicalGameState()));
                        if (b2 == null) continue;
                        b.addAll(b2);
                        ll.add(b);
                    }
                    return ll;
                }
            });
            predicates.put(new Symbol("closest-unit-to"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    List<Binding> closest = null;
                    int distance = 0;
                    Parameter p0 = term.parameters[0];
                    Unit referenceUnit = null;
                    if (p0 instanceof IntegerConstant) {
                        referenceUnit = gs.getUnit(((IntegerConstant)p0).value);
                    }
                    if (referenceUnit == null) {
                        return null;
                    }
                    for (Unit u : gs.getUnits()) {
                        Parameter p;
                        List<Binding> b2;
                        List<Binding> b = term.parameters[1].match((int)u.getID());
                        if (b == null || (b2 = (p = term.parameters[2].resolveParameter(b, gs)).match(u.getType().name)) == null) continue;
                        b.addAll(b2);
                        p = term.parameters[3].resolveParameter(b, gs);
                        b2 = p.match(u.getPlayer());
                        if (b2 == null) continue;
                        b.addAll(b2);
                        p = term.parameters[4].resolveParameter(b, gs);
                        b2 = p.match(u.getResources());
                        if (b2 == null) continue;
                        b.addAll(b2);
                        p = term.parameters[5].resolveParameter(b, gs);
                        b2 = p.match(u.getPosition(gs.getPhysicalGameState()));
                        if (b2 == null) continue;
                        b.addAll(b2);
                        int d = Math.abs(u.getX() - referenceUnit.getX()) + Math.abs(u.getY() - referenceUnit.getY());
                        if (closest != null && d >= distance) continue;
                        closest = b;
                        distance = d;
                    }
                    return closest;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("can-move"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    UnitType ut;
                    Parameter p = term.parameters[0];
                    if (p instanceof SymbolConstant && (ut = gs.getUnitTypeTable().getUnitType(p.toString())) != null && ut.canMove) {
                        return new LinkedList<Binding>();
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("can-attack"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    UnitType ut;
                    Parameter p = term.parameters[0];
                    if (p instanceof SymbolConstant && (ut = gs.getUnitTypeTable().getUnitType(p.toString())) != null && ut.canAttack) {
                        return new LinkedList<Binding>();
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("can-harvest"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    UnitType ut;
                    Parameter p = term.parameters[0];
                    if (p instanceof SymbolConstant && (ut = gs.getUnitTypeTable().getUnitType(p.toString())) != null && ut.canHarvest) {
                        return new LinkedList<Binding>();
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("can-produce"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    block13: {
                        Parameter p2;
                        Parameter p1;
                        block14: {
                            block12: {
                                if (DEBUG >= 1) {
                                    System.out.println("can-produce.firstMatch: " + Arrays.toString(term.parameters));
                                }
                                p1 = term.parameters[0];
                                p2 = term.parameters[1];
                                if (!(p1 instanceof SymbolConstant)) break block12;
                                UnitType ut1 = gs.getUnitTypeTable().getUnitType(p1.toString());
                                if (ut1 != null) {
                                    Iterator<UnitType> ut22;
                                    if (p2 instanceof SymbolConstant) {
                                        UnitType ut22 = gs.getUnitTypeTable().getUnitType(p1.toString());
                                        if (ut1 != null && ut22 != null && ut1.produces.contains(ut22)) {
                                            return new LinkedList<Binding>();
                                        }
                                    } else if (p2 instanceof Variable && (ut22 = ut1.produces.iterator()).hasNext()) {
                                        UnitType t = ut22.next();
                                        LinkedList<Binding> l = new LinkedList<Binding>();
                                        if (!((Variable)p2).ignore()) {
                                            l.add(new Binding((Variable)p2, new SymbolConstant(t.name)));
                                        }
                                        return l;
                                    }
                                }
                                break block13;
                            }
                            if (!(p1 instanceof Variable)) break block13;
                            if (!(p2 instanceof SymbolConstant)) break block14;
                            UnitType ut2 = gs.getUnitTypeTable().getUnitType(p1.toString());
                            for (UnitType t : gs.getUnitTypeTable().getUnitTypes()) {
                                if (!t.produces.contains(ut2)) continue;
                                LinkedList<Binding> l = new LinkedList<Binding>();
                                if (!((Variable)p1).ignore()) {
                                    l.add(new Binding((Variable)p1, new SymbolConstant(t.name)));
                                }
                                return l;
                            }
                            break block13;
                        }
                        if (!(p2 instanceof Variable)) break block13;
                        for (UnitType t : gs.getUnitTypeTable().getUnitTypes()) {
                            Iterator<UnitType> iterator = t.produces.iterator();
                            if (!iterator.hasNext()) continue;
                            UnitType t2 = iterator.next();
                            LinkedList<Binding> l = new LinkedList<Binding>();
                            if (!((Variable)p1).ignore()) {
                                l.add(new Binding((Variable)p1, new SymbolConstant(t.name)));
                            }
                            if (!((Variable)p2).ignore()) {
                                l.add(new Binding((Variable)p2, new SymbolConstant(t2.name)));
                            }
                            return l;
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    LinkedList<List<Binding>> ll;
                    block14: {
                        Parameter p2;
                        Parameter p1;
                        block13: {
                            UnitType ut1;
                            block15: {
                                if (DEBUG >= 1) {
                                    System.out.println("can-produce.allMatches: " + Arrays.toString(term.parameters));
                                }
                                ll = new LinkedList<List<Binding>>();
                                p1 = term.parameters[0];
                                p2 = term.parameters[1];
                                if (!(p1 instanceof SymbolConstant)) break block13;
                                ut1 = gs.getUnitTypeTable().getUnitType(p1.toString());
                                if (ut1 == null) break block14;
                                if (!(p2 instanceof SymbolConstant)) break block15;
                                UnitType ut2 = gs.getUnitTypeTable().getUnitType(p1.toString());
                                if (ut1 == null || ut2 == null || !ut1.produces.contains(ut2)) break block14;
                                ll.add(new LinkedList());
                                break block14;
                            }
                            if (!(p2 instanceof Variable)) break block14;
                            for (UnitType t : ut1.produces) {
                                LinkedList<Binding> l = new LinkedList<Binding>();
                                if (!((Variable)p2).ignore()) {
                                    l.add(new Binding((Variable)p2, new SymbolConstant(t.name)));
                                }
                                ll.add(l);
                            }
                            break block14;
                        }
                        if (p1 instanceof Variable) {
                            if (p2 instanceof SymbolConstant) {
                                UnitType ut2 = gs.getUnitTypeTable().getUnitType(p1.toString());
                                for (UnitType t : gs.getUnitTypeTable().getUnitTypes()) {
                                    if (!t.produces.contains(ut2)) continue;
                                    LinkedList<Binding> l = new LinkedList<Binding>();
                                    if (!((Variable)p1).ignore()) {
                                        l.add(new Binding((Variable)p1, new SymbolConstant(t.name)));
                                    }
                                    ll.add(l);
                                }
                            } else if (p2 instanceof Variable) {
                                for (UnitType t : gs.getUnitTypeTable().getUnitTypes()) {
                                    for (UnitType t2 : t.produces) {
                                        LinkedList<Binding> l = new LinkedList<Binding>();
                                        if (!((Variable)p1).ignore()) {
                                            l.add(new Binding((Variable)p1, new SymbolConstant(t.name)));
                                        }
                                        if (!((Variable)p2).ignore()) {
                                            l.add(new Binding((Variable)p2, new SymbolConstant(t2.name)));
                                        }
                                        ll.add(l);
                                    }
                                }
                            }
                        }
                    }
                    return ll;
                }
            });
            predicates.put(new Symbol("in-attack-range"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    Parameter p1 = term.parameters[0];
                    Parameter p2 = term.parameters[1];
                    if (p1 instanceof IntegerConstant && p2 instanceof IntegerConstant) {
                        int dy;
                        Unit u1 = gs.getPhysicalGameState().getUnit(((IntegerConstant)p1).value);
                        Unit u2 = gs.getPhysicalGameState().getUnit(((IntegerConstant)p2).value);
                        if (u1 == null || u2 == null) {
                            return null;
                        }
                        int sq_ar = u1.getAttackRange() * u1.getAttackRange();
                        int dx = u1.getX() - u2.getX();
                        if (dx * dx + (dy = u1.getY() - u2.getY()) * dy <= sq_ar) {
                            return new LinkedList<Binding>();
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("in-harvest-range"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    Parameter p1 = term.parameters[0];
                    Parameter p2 = term.parameters[1];
                    if (p1 instanceof IntegerConstant && p2 instanceof IntegerConstant) {
                        int dy;
                        Unit u1 = gs.getPhysicalGameState().getUnit(((IntegerConstant)p1).value);
                        Unit u2 = gs.getPhysicalGameState().getUnit(((IntegerConstant)p2).value);
                        int sq_ar = 1;
                        int dx = u1.getX() - u2.getX();
                        if (dx * dx + (dy = u1.getY() - u2.getY()) * dy <= sq_ar) {
                            return new LinkedList<Binding>();
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("in-return-range"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    Parameter p1 = term.parameters[0];
                    Parameter p2 = term.parameters[1];
                    if (p1 instanceof IntegerConstant && p2 instanceof IntegerConstant) {
                        int dy;
                        Unit u1 = gs.getPhysicalGameState().getUnit(((IntegerConstant)p1).value);
                        Unit u2 = gs.getPhysicalGameState().getUnit(((IntegerConstant)p2).value);
                        int sq_ar = 1;
                        int dx = u1.getX() - u2.getX();
                        if (dx * dx + (dy = u1.getY() - u2.getY()) * dy <= sq_ar) {
                            return new LinkedList<Binding>();
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("has-resources-to-produce"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    if (DEBUG >= 1) {
                        System.out.println("has-resources-to-produce.firstMatch");
                    }
                    Parameter p1 = term.parameters[0];
                    Parameter p2 = term.parameters[1];
                    if (p1 instanceof IntegerConstant && p2 instanceof SymbolConstant) {
                        Player player1 = gs.getPlayer(((IntegerConstant)p1).value);
                        UnitType ut = gs.getUnitTypeTable().getUnitType(((SymbolConstant)p2).toString());
                        ResourceUsage ru = gs.getResourceUsage();
                        if (player1.getResources() - ru.getResourcesUsed(player1.getID()) >= ut.cost) {
                            return new LinkedList<Binding>();
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l;
                    if (DEBUG >= 1) {
                        System.out.println("has-resources-to-produce.allMatches");
                    }
                    if ((l = this.firstMatch(term, gs)) == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("direction"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    Parameter p = term.parameters[0];
                    if (p instanceof IntegerConstant) {
                        int d = ((IntegerConstant)p).value;
                        if (d == 0 || d == 1 || d == 2 || d == 3) {
                            return new LinkedList<Binding>();
                        }
                    } else {
                        LinkedList<Binding> l = new LinkedList<Binding>();
                        if (!((Variable)p).ignore()) {
                            l.add(new Binding((Variable)p, new IntegerConstant(0)));
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    Parameter p = term.parameters[0];
                    if (p instanceof IntegerConstant) {
                        int d = ((IntegerConstant)p).value;
                        if (d == 0 || d == 1 || d == 2 || d == 3) {
                            ll.add(new LinkedList());
                        }
                    } else {
                        LinkedList<Binding> l = new LinkedList<Binding>();
                        if (!((Variable)p).ignore()) {
                            l.add(new Binding((Variable)p, new IntegerConstant(0)));
                        }
                        ll.add(l);
                        l = new LinkedList();
                        if (!((Variable)p).ignore()) {
                            l.add(new Binding((Variable)p, new IntegerConstant(1)));
                        }
                        ll.add(l);
                        l = new LinkedList();
                        if (!((Variable)p).ignore()) {
                            l.add(new Binding((Variable)p, new IntegerConstant(2)));
                        }
                        ll.add(l);
                        l = new LinkedList();
                        if (!((Variable)p).ignore()) {
                            l.add(new Binding((Variable)p, new IntegerConstant(3)));
                        }
                        ll.add(l);
                    }
                    return ll;
                }
            });
            predicates.put(new Symbol("free-building-position"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    int w;
                    int pos;
                    Parameter p1 = term.parameters[0];
                    if (p1 instanceof IntegerConstant && gs.free((pos = ((IntegerConstant)p1).value) % (w = gs.getPhysicalGameState().getWidth()), pos / w)) {
                        return new LinkedList<Binding>();
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("free-producing-direction"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    Parameter p1 = term.parameters[0];
                    Parameter p2 = term.parameters[1];
                    if (p1 instanceof IntegerConstant) {
                        Unit u1 = gs.getUnit(((IntegerConstant)p1).value);
                        if (p2 instanceof IntegerConstant) {
                            int d = ((IntegerConstant)p2).value;
                            int posx = u1.getX() + UnitAction.DIRECTION_OFFSET_X[d];
                            int posy = u1.getY() + UnitAction.DIRECTION_OFFSET_Y[d];
                            if (posx >= 0 && posx < gs.getPhysicalGameState().getWidth() && posy >= 0 && posy < gs.getPhysicalGameState().getHeight() && gs.free(posx, posy)) {
                                return new LinkedList<Binding>();
                            }
                        } else if (p2 instanceof Variable) {
                            for (int d = 0; d < 4; ++d) {
                                int posx = u1.getX() + UnitAction.DIRECTION_OFFSET_X[d];
                                int posy = u1.getY() + UnitAction.DIRECTION_OFFSET_Y[d];
                                if (posx < 0 || posx >= gs.getPhysicalGameState().getWidth() || posy < 0 || posy >= gs.getPhysicalGameState().getHeight() || !gs.free(posx, posy)) continue;
                                LinkedList<Binding> l = new LinkedList<Binding>();
                                if (!((Variable)p2).ignore()) {
                                    l.add(new Binding((Variable)p2, new IntegerConstant(d)));
                                }
                                return l;
                            }
                        }
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    Parameter p1 = term.parameters[0];
                    Parameter p2 = term.parameters[1];
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    if (p1 instanceof IntegerConstant) {
                        Unit u1 = gs.getUnit(((IntegerConstant)p1).value);
                        if (p2 instanceof IntegerConstant) {
                            int d = ((IntegerConstant)p2).value;
                            int posx = u1.getX() + UnitAction.DIRECTION_OFFSET_X[d];
                            int posy = u1.getY() + UnitAction.DIRECTION_OFFSET_Y[d];
                            if (posx >= 0 && posx < gs.getPhysicalGameState().getWidth() && posy >= 0 && posy < gs.getPhysicalGameState().getHeight() && gs.free(posx, posy)) {
                                ll.add(new LinkedList());
                            }
                        } else if (p2 instanceof Variable) {
                            for (int d = 0; d < 4; ++d) {
                                int posx = u1.getX() + UnitAction.DIRECTION_OFFSET_X[d];
                                int posy = u1.getY() + UnitAction.DIRECTION_OFFSET_Y[d];
                                if (posx < 0 || posx >= gs.getPhysicalGameState().getWidth() || posy < 0 || posy >= gs.getPhysicalGameState().getHeight() || !gs.free(posx, posy)) continue;
                                LinkedList<Binding> l = new LinkedList<Binding>();
                                if (!((Variable)p2).ignore()) {
                                    l.add(new Binding((Variable)p2, new IntegerConstant(d)));
                                }
                                ll.add(l);
                            }
                        }
                    }
                    return ll;
                }
            });
            predicates.put(new Symbol("next-available-unit"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    Parameter p1 = term.parameters[0];
                    Parameter p2 = term.parameters[1];
                    Parameter p3 = term.parameters[2];
                    if (!(p1 instanceof IntegerConstant)) {
                        return null;
                    }
                    if (!(p2 instanceof IntegerConstant)) {
                        return null;
                    }
                    if (!(p3 instanceof Variable)) {
                        return null;
                    }
                    int lastunit = ((IntegerConstant)p1).value;
                    int player = ((IntegerConstant)p2).value;
                    Unit found = null;
                    for (Unit u : gs.getUnits()) {
                        if (u.getPlayer() != player || u.getID() <= (long)lastunit || gs.getUnitAction(u) != null) continue;
                        if (found == null) {
                            found = u;
                            continue;
                        }
                        if (u.getID() >= found.getID()) continue;
                        found = u;
                    }
                    if (found != null) {
                        LinkedList<Binding> l = new LinkedList<Binding>();
                        l.add(new Binding((Variable)p3, new IntegerConstant((int)found.getID())));
                        return l;
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("no-more-available-units"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    Parameter p1 = term.parameters[0];
                    Parameter p2 = term.parameters[1];
                    if (!(p1 instanceof IntegerConstant)) {
                        return null;
                    }
                    if (!(p2 instanceof IntegerConstant)) {
                        return null;
                    }
                    int lastunit = ((IntegerConstant)p1).value;
                    int player = ((IntegerConstant)p2).value;
                    for (Unit u : gs.getUnits()) {
                        if (u.getPlayer() != player || u.getID() <= (long)lastunit || gs.getUnitAction(u) != null) continue;
                        return null;
                    }
                    return new LinkedList<Binding>();
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("path"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    Parameter p1 = term.parameters[0];
                    Parameter p2 = term.parameters[1];
                    if (p1 instanceof IntegerConstant && p2 instanceof IntegerConstant) {
                        Unit u1 = gs.getPhysicalGameState().getUnit(((IntegerConstant)p1).value);
                        Unit u2 = gs.getPhysicalGameState().getUnit(((IntegerConstant)p2).value);
                        if (u1 == null || u2 == null) {
                            return null;
                        }
                        if (pf.pathToPositionInRangeExists(u1, u2.getPosition(gs.getPhysicalGameState()), 1, gs, null)) {
                            return new LinkedList<Binding>();
                        }
                        return null;
                    }
                    return null;
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
            predicates.put(new Symbol("path-to-attack"), new PredicateTester(){

                @Override
                public List<Binding> firstMatch(Term term, GameState gs) throws Exception {
                    Parameter p1 = term.parameters[0];
                    Parameter p2 = term.parameters[1];
                    if (p1 instanceof IntegerConstant && p2 instanceof IntegerConstant) {
                        Unit u1 = gs.getPhysicalGameState().getUnit(((IntegerConstant)p1).value);
                        Unit u2 = gs.getPhysicalGameState().getUnit(((IntegerConstant)p2).value);
                        if (u1 == null || u2 == null) {
                            return null;
                        }
                        if (pf.pathToPositionInRangeExists(u1, u2.getPosition(gs.getPhysicalGameState()), u1.getAttackRange(), gs, null)) {
                            return new LinkedList<Binding>();
                        }
                        return null;
                    }
                    throw new Exception("no path, invalid units: " + p1 + ", " + p2);
                }

                @Override
                public List<List<Binding>> allMatches(Term term, GameState gs) throws Exception {
                    List<Binding> l = this.firstMatch(term, gs);
                    if (l == null) {
                        return new LinkedList<List<Binding>>();
                    }
                    LinkedList<List<Binding>> ll = new LinkedList<List<Binding>>();
                    ll.add(l);
                    return ll;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static interface PredicateTester {
        public List<Binding> firstMatch(Term var1, GameState var2) throws Exception;

        public List<List<Binding>> allMatches(Term var1, GameState var2) throws Exception;
    }
}

