/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.Function;
import ai.ahtn.domain.IntegerConstant;
import ai.ahtn.domain.LispParser.LispElement;
import ai.ahtn.domain.LispParser.LispParser;
import ai.ahtn.domain.Parameter;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.SymbolConstant;
import ai.ahtn.domain.Variable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;

public class Term {
    public static int DEBUG = 0;
    Symbol functor;
    Parameter[] parameters;

    public Term() {
        this.functor = null;
        this.parameters = null;
    }

    public Term(Symbol f) {
        this.functor = f;
        this.parameters = null;
    }

    public Term(Symbol f, Parameter p) {
        this.functor = f;
        this.parameters = new Parameter[1];
        this.parameters[0] = p;
    }

    public Term(Symbol f, Parameter p1, Parameter p2) {
        this.functor = f;
        this.parameters = new Parameter[2];
        this.parameters[0] = p1;
        this.parameters[1] = p2;
    }

    public Term(Symbol f, Parameter[] p) {
        this.functor = f;
        this.parameters = p;
    }

    public Symbol getFunctor() {
        return this.functor;
    }

    public static Term fromString(String s) throws Exception {
        return Term.fromLispElement(LispParser.parseString(s).get(0));
    }

    public static Term fromLispElement(LispElement e) throws Exception {
        Term t = new Term();
        t.functor = new Symbol(e.children.get((int)0).element);
        int l = e.children.size() - 1;
        if (l == 0) {
            t.parameters = null;
        } else {
            t.parameters = new Parameter[l];
            for (int i = 0; i < l; ++i) {
                LispElement p_e = e.children.get(i + 1);
                if (p_e.children != null) {
                    t.parameters[i] = Function.fromLispElement(p_e);
                    continue;
                }
                String v = p_e.element;
                if (v.startsWith("?")) {
                    t.parameters[i] = new Variable(v);
                    continue;
                }
                try {
                    int iv = Integer.parseInt(v);
                    t.parameters[i] = new IntegerConstant(iv);
                    continue;
                }
                catch (Exception ex) {
                    t.parameters[i] = new SymbolConstant(v);
                }
            }
        }
        return t;
    }

    public void renameVariables(int r) {
        if (this.parameters != null) {
            for (Parameter p : this.parameters) {
                if (p instanceof Variable) {
                    ((Variable)p).setRenaming(r);
                    continue;
                }
                if (!(p instanceof Function)) continue;
                ((Function)p).renameVariables(r);
            }
        }
    }

    public List<Binding> simpleUnificationDestructiveNoSharedVariables(Term t, GameState gs) throws Exception {
        if (DEBUG >= 1) {
            System.out.println("simpleUnificationDestructiveNoSharedVariables: start");
        }
        if (!this.functor.equals(t.functor)) {
            return null;
        }
        if (this.parameters.length != t.parameters.length) {
            return null;
        }
        LinkedList<Binding> bindings = new LinkedList<Binding>();
        Parameter[] resolved = new Parameter[this.parameters.length];
        for (int i = 0; i < this.parameters.length; ++i) {
            Parameter p1 = this.parameters[i].resolveParameter(bindings, gs);
            Parameter p2 = t.parameters[i].resolveParameter(bindings, gs);
            if (DEBUG >= 1) {
                System.out.println("simpleUnificationDestructiveNoSharedVariables: " + i + " -> " + p1 + " U " + p2);
            }
            resolved[i] = p1;
            if (p1 instanceof Variable) {
                if (p2 instanceof Variable && p2.equals(p1) || ((Variable)p1).ignore()) continue;
                bindings.add(new Binding((Variable)p1, p2));
                continue;
            }
            if (p2 instanceof Variable) {
                if (((Variable)p2).ignore()) continue;
                bindings.add(new Binding((Variable)p2, p1));
                continue;
            }
            if (p1.equals(p2)) continue;
            return null;
        }
        this.parameters = resolved;
        return bindings;
    }

    public Term resolve(List<Binding> l, GameState gs) throws Exception {
        if (l.isEmpty()) {
            return this;
        }
        Term t = new Term();
        t.functor = this.functor;
        t.parameters = new Parameter[this.parameters.length];
        for (int i = 0; i < t.parameters.length; ++i) {
            t.parameters[i] = this.parameters[i].resolveParameter(l, gs);
        }
        return t;
    }

    public Term clone() {
        Term t = new Term(this.functor);
        if (this.parameters != null) {
            t.parameters = new Parameter[this.parameters.length];
            for (int i = 0; i < t.parameters.length; ++i) {
                t.parameters[i] = this.parameters[i].cloneParameter();
            }
        }
        return t;
    }

    public void applyBindings(List<Binding> l) throws Exception {
        if (l.isEmpty()) {
            return;
        }
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = this.parameters[i].applyBindingsParameter(l);
            }
        }
    }

    public boolean isGround() {
        for (Parameter p : this.parameters) {
            if (p instanceof Variable) {
                return false;
            }
            if (!(p instanceof Function) || ((Function)p).isGround()) continue;
            return false;
        }
        return true;
    }

    public void countVariableAppearances(HashMap<Symbol, Integer> appearances) throws Exception {
        for (Parameter p : this.parameters) {
            if (p instanceof Variable && !((Variable)p).ignore()) {
                Symbol name = ((Variable)p).getName();
                if (appearances.containsKey(name)) {
                    appearances.put(name, appearances.get(name) + 1);
                } else {
                    appearances.put(name, 1);
                }
            }
            if (!(p instanceof Function)) continue;
            ((Function)p).countVariableAppearances(appearances);
        }
    }

    public void replaceSingletonsByWildcards(List<Symbol> singletons) throws Exception {
        for (int i = 0; i < this.parameters.length; ++i) {
            Symbol name;
            Parameter p = this.parameters[i];
            if (p instanceof Variable && singletons.contains(name = ((Variable)p).getName())) {
                this.parameters[i] = new Variable(new Symbol("?_"));
            }
            if (!(p instanceof Function)) continue;
            ((Function)p).replaceSingletonsByWildcards(singletons);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Term)) {
            return false;
        }
        Term t = (Term)o;
        if (!this.functor.equals(t.functor)) {
            return false;
        }
        if (this.parameters.length != t.parameters.length) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i].equals(t.parameters[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.functor);
        if (this.parameters != null) {
            for (Parameter parameter : this.parameters) {
                sb.append(" ");
                sb.append(parameter);
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

