/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.domain;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.IntegerConstant;
import ai.ahtn.domain.Parameter;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.SymbolConstant;
import java.util.LinkedList;
import java.util.List;
import rts.GameState;

public class Variable
implements Parameter {
    static Symbol variable_to_ignore;
    Symbol name;
    int renaming = 0;

    public Variable(String sym2) throws Exception {
        this.name = new Symbol(sym2);
    }

    public Variable(Symbol sym2) {
        this.name = sym2;
    }

    public Symbol getName() {
        return this.name;
    }

    public void setRenaming(int r) {
        this.renaming = r;
    }

    public boolean ignore() throws Exception {
        if (variable_to_ignore == null) {
            variable_to_ignore = new Symbol("?_");
        }
        return this.name.equals(variable_to_ignore);
    }

    @Override
    public List<Binding> match(int v) throws Exception {
        LinkedList<Binding> l = new LinkedList<Binding>();
        if (!this.ignore()) {
            l.add(new Binding(this, new IntegerConstant(v)));
        }
        return l;
    }

    @Override
    public List<Binding> match(String s) throws Exception {
        LinkedList<Binding> l = new LinkedList<Binding>();
        if (!this.ignore()) {
            l.add(new Binding(this, new SymbolConstant(new Symbol(s))));
        }
        return l;
    }

    @Override
    public Parameter cloneParameter() {
        Variable v = new Variable(this.name);
        v.renaming = this.renaming;
        return v;
    }

    @Override
    public Parameter resolveParameter(List<Binding> l, GameState gs) throws Exception {
        if (l == null) {
            return this;
        }
        return this.applyBindingsParameter(l);
    }

    @Override
    public Parameter applyBindingsParameter(List<Binding> l) throws Exception {
        if (this.ignore()) {
            return this;
        }
        Parameter tmp = this;
        for (Binding b : l) {
            if (!b.v.equals(tmp)) continue;
            tmp = b.p;
        }
        return tmp;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Variable)) {
            return false;
        }
        Variable v = (Variable)o;
        return this.name.equals(v.name) && this.renaming == v.renaming;
    }

    public String toString() {
        if (this.renaming == 0) {
            return this.name.toString();
        }
        return this.name + "/" + this.renaming;
    }
}

