/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.planner;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.DomainDefinition;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.domain.PredefinedOperators;
import ai.ahtn.domain.Term;
import ai.ahtn.planner.AdversarialChoicePoint;
import ai.core.AI;
import ai.evaluation.EvaluationFunction;
import java.util.ArrayList;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import util.Pair;

public class AdversarialBoundedDepthPlannerAlphaBeta {
    public static int DEBUG = 0;
    public static boolean ALPHA_BETA_CUT = true;
    public static boolean SIMULATE_UNTIL_NEXT_CHOICEPOINT = true;
    MethodDecomposition maxPlanRoot;
    MethodDecomposition minPlanRoot;
    int maxPlayer;
    GameState gs;
    DomainDefinition dd;
    EvaluationFunction f;
    AI playoutAI;
    int PLAYOUT_LOOKAHEAD = 100;
    int maxDepth = 3;
    int operatorExecutionTimeout = 1000;
    static int MAX_TREE_DEPTH = 25;
    static int nPlayouts = 0;
    List<AdversarialChoicePoint> stack;
    List<Integer> trail;
    List<Binding> bindings;
    int renamingIndex = 1;
    boolean lastRunSolvedTheProblem = false;
    public static int n_iterative_deepening_runs = 0;
    public static double max_iterative_deepening_depth = 0.0;
    public static double average_iterative_deepening_depth = 0.0;
    public static int n_trees = 0;
    public static double max_tree_leaves = 0.0;
    public static double last_tree_leaves = 0.0;
    public static double average_tree_leaves = 0.0;
    public static double max_tree_nodes = 0.0;
    public static double last_tree_nodes = 0.0;
    public static double average_tree_nodes = 0.0;
    public static double max_tree_depth = 0.0;
    public static double last_tree_depth = 0.0;
    public static double average_tree_depth = 0.0;
    public static double max_time_depth = 0.0;
    public static double last_time_depth = 0.0;
    public static double average_time_depth = 0.0;

    public static void clearStatistics() {
        n_iterative_deepening_runs = 0;
        max_iterative_deepening_depth = 0.0;
        average_iterative_deepening_depth = 0.0;
        n_trees = 0;
        max_tree_leaves = 0.0;
        last_tree_leaves = 0.0;
        average_tree_leaves = 0.0;
        max_tree_nodes = 0.0;
        last_tree_nodes = 0.0;
        average_tree_nodes = 0.0;
        max_tree_depth = 0.0;
        last_tree_depth = 0.0;
        average_tree_depth = 0.0;
        max_time_depth = 0.0;
        last_time_depth = 0.0;
        average_time_depth = 0.0;
    }

    public AdversarialBoundedDepthPlannerAlphaBeta(Term goalPlayerMax, Term goalPlayerMin, int a_maxPlayer, int depth, int playoutLookahead, GameState a_gs, DomainDefinition a_dd, EvaluationFunction a_f, AI a_playoutAI) {
        this.maxPlanRoot = new MethodDecomposition(goalPlayerMax, null);
        this.minPlanRoot = new MethodDecomposition(goalPlayerMin, null);
        this.minPlanRoot.renameVariables(1);
        this.renamingIndex = 2;
        this.maxPlayer = a_maxPlayer;
        this.gs = a_gs;
        this.dd = a_dd;
        this.stack = null;
        this.maxDepth = depth;
        this.PLAYOUT_LOOKAHEAD = playoutLookahead;
        this.f = a_f;
        this.playoutAI = a_playoutAI;
    }

    public Pair<MethodDecomposition, MethodDecomposition> getBestPlan() throws Exception {
        return this.getBestPlan(-1L, -1, false);
    }

    public Pair<MethodDecomposition, MethodDecomposition> getBestPlan(long timeLimit, int maxPlayouts, boolean forceAnswer) throws Exception {
        if (DEBUG >= 1) {
            System.out.println("AdversarialBoundedDepthPlanner.getBestPlan");
        }
        if (this.stack == null) {
            if (DEBUG >= 1) {
                System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: first time, initializing stack");
            }
            this.stack = new ArrayList<AdversarialChoicePoint>();
            this.stack.add(0, new AdversarialChoicePoint(this.maxPlanRoot, this.minPlanRoot, this.maxPlanRoot, this.minPlanRoot, this.gs, 0, -1, -EvaluationFunction.VICTORY, EvaluationFunction.VICTORY, false));
            this.trail = new ArrayList<Integer>();
            this.trail.add(0, 0);
            this.bindings = new ArrayList<Binding>();
        }
        last_tree_leaves = 0.0;
        last_tree_nodes = 0.0;
        last_tree_depth = 0.0;
        last_time_depth = 0.0;
        AdversarialChoicePoint root = this.stack.get(this.stack.size() - 1);
        boolean timeout = false;
        do {
            int treedepth;
            if (timeLimit > 0L && System.currentTimeMillis() >= timeLimit || maxPlayouts > 0 && nPlayouts >= maxPlayouts) {
                if (forceAnswer) {
                    timeout = true;
                } else {
                    return null;
                }
            }
            if ((double)(treedepth = this.stack.size()) >= last_tree_depth) {
                last_tree_depth = treedepth;
            }
            AdversarialChoicePoint choicePoint = this.stack.get(0);
            choicePoint.restoreExecutionState();
            if (DEBUG >= 2) {
                System.out.println("\nAdversarialBoundedDepthPlanner.getBestPlan: stack size: " + this.stack.size() + ", bindings: " + this.bindings.size() + ", gs.time: " + choicePoint.gs.getTime() + ", operators: " + root.choicePointPlayerMin.getOperatorsBeingExecuted() + ", " + root.choicePointPlayerMax.getOperatorsBeingExecuted());
            }
            if (DEBUG >= 3) {
                System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: bindings: " + this.bindings);
                System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: trail: " + this.trail);
                System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: stack:");
                for (int i = 0; i < this.stack.size(); ++i) {
                    System.out.println(this.stack.size() - i + ": " + this.stack.get(i));
                }
                this.maxPlanRoot.printDetailed();
                this.minPlanRoot.printDetailed();
            }
            int bl = this.bindings.size();
            boolean pop = true;
            while (!timeout && choicePoint.nextExpansion(this.dd, this.bindings, this.renamingIndex, choicePoint)) {
                ++this.renamingIndex;
                AdversarialChoicePoint tmp = this.simulateUntilNextChoicePoint(this.bindings, choicePoint);
                if (tmp == null) {
                    if (DEBUG >= 2) {
                        System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: plan execution failed");
                    }
                    choicePoint.restoreExecutionState();
                    continue;
                }
                if (tmp.choicePointPlayerMax == null && tmp.choicePointPlayerMin == null) {
                    double time;
                    last_tree_nodes += 1.0;
                    if (DEBUG >= 2) {
                        System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: plan execution success or depth limit reached");
                    }
                    if (DEBUG >= 3) {
                        System.out.println(tmp.gs);
                    }
                    if (DEBUG >= 3) {
                        this.maxPlanRoot.printDetailed();
                        this.minPlanRoot.printDetailed();
                    }
                    float eval = this.playout(this.maxPlayer, tmp.gs);
                    last_tree_leaves += 1.0;
                    boolean alphaBetaTest = choicePoint.processEvaluation(eval, choicePoint.maxPlanRoot, choicePoint.minPlanRoot, true);
                    if (!ALPHA_BETA_CUT) {
                        alphaBetaTest = false;
                    }
                    if ((time = (double)(tmp.gs.getTime() - root.gs.getTime())) > last_time_depth) {
                        last_time_depth = time;
                    }
                    if (DEBUG >= 2) {
                        System.out.println("---- ---- ---- ----");
                        System.out.println(tmp.gs);
                        System.out.println("Evaluation: " + eval);
                        System.out.println("Bindings: " + this.bindings.size());
                        System.out.println("Bindings: " + this.bindings);
                        System.out.println("Max plan:");
                        List<Pair<Integer, List<Term>>> l = this.maxPlanRoot.convertToOperatorList();
                        for (Pair<Integer, List<Term>> a : l) {
                            System.out.println("  " + a.m_a + ": " + a.m_b);
                        }
                        System.out.println("Min plan:");
                        List<Pair<Integer, List<Term>>> l2 = this.minPlanRoot.convertToOperatorList();
                        for (Pair<Integer, List<Term>> a : l2) {
                            System.out.println("  " + a.m_a + ": " + a.m_b);
                        }
                    }
                    choicePoint.restoreExecutionState();
                    int n = this.bindings.size() - bl;
                    for (int i = 0; i < n; ++i) {
                        this.bindings.remove(0);
                    }
                    if (!alphaBetaTest) continue;
                    break;
                }
                last_tree_nodes += 1.0;
                if (DEBUG >= 2) {
                    System.out.println("AdversarialBoundedDepthPlanner.getBestPlan: stack push");
                }
                this.stack.add(0, tmp);
                this.trail.add(0, this.bindings.size() - bl);
                pop = false;
                break;
            }
            if (!pop) continue;
            if (!timeout && nPlayouts == 0) {
                AdversarialChoicePoint cp = this.stack.get(0);
                if (cp.choicePointPlayerMax != null && cp.choicePointPlayerMax.getType() == 2 || cp.choicePointPlayerMax == null && cp.choicePointPlayerMin != null && cp.choicePointPlayerMin.getType() == 2) {
                    System.err.println("Popping without finding any decomposition:");
                    System.err.println(cp);
                    System.err.println(this.bindings);
                    System.err.println(cp.gs);
                    throw new Error("Popping without finding any decomposition");
                }
            }
            do {
                pop = false;
                this.stackPop();
                if (DEBUG >= 2) {
                    System.out.println("AdversarialBoundedDepthPlanner.nextPlan: stack pop");
                }
                if (this.stack.isEmpty()) continue;
                if (choicePoint.minimaxType != -1) {
                    pop = this.stack.get(0).processEvaluation(choicePoint.bestEvaluation, choicePoint.bestMaxPlan, choicePoint.bestMinPlan, false);
                    if (!ALPHA_BETA_CUT) {
                        pop = false;
                    }
                }
                if (!pop) continue;
                choicePoint = this.stack.get(0);
            } while (pop && !this.stack.isEmpty());
        } while (!this.stack.isEmpty());
        if (DEBUG >= 1) {
            System.out.println(last_tree_leaves);
        }
        this.stack = null;
        if (DEBUG >= 1) {
            System.out.println("AdversarialBoundedDepthPlanner.nextPlan: options exhausted for rootPlan");
        }
        if (DEBUG >= 1) {
            System.out.println("best evaluation: " + root.bestEvaluation);
        }
        if (root.bestEvaluation == EvaluationFunction.VICTORY || root.bestEvaluation == -EvaluationFunction.VICTORY) {
            this.lastRunSolvedTheProblem = true;
        }
        if (root.bestMaxPlan == null && root.bestMinPlan == null) {
            this.lastRunSolvedTheProblem = true;
            System.out.println("No AHTN can be found for situation:");
            System.out.println(this.gs);
        }
        return new Pair<MethodDecomposition, MethodDecomposition>(root.bestMaxPlan, root.bestMinPlan);
    }

    public static Pair<MethodDecomposition, MethodDecomposition> getBestPlanIterativeDeepening(Term goalPlayerMax, Term goalPlayerMin, int a_maxPlayer, int timeout, int maxPlayouts, int a_playoutLookahead, GameState a_gs, DomainDefinition a_dd, EvaluationFunction a_f, AI a_playoutAI) throws Exception {
        long start = System.currentTimeMillis();
        long timeLimit = start + (long)timeout;
        if (timeout <= 0) {
            timeLimit = 0L;
        }
        Pair<MethodDecomposition, MethodDecomposition> bestLastDepth = null;
        double tmp_leaves = 0.0;
        double tmp_nodes = 0.0;
        double tmp_depth = 0.0;
        double tmp_time = 0.0;
        int nPlayoutsBeforeStartingLastTime = 0;
        int nPlayoutsUSedLastTime = 0;
        nPlayouts = 0;
        int depth = 1;
        while (true) {
            Pair<MethodDecomposition, MethodDecomposition> best = null;
            long currentTime = System.currentTimeMillis();
            if (DEBUG >= 1) {
                System.out.println("Iterative Deepening depth: " + depth + " (total time so far: " + (currentTime - start) + "/" + timeout + ") (total playouts so far: " + nPlayouts + "/" + maxPlayouts + ")");
            }
            AdversarialBoundedDepthPlannerAlphaBeta planner = new AdversarialBoundedDepthPlannerAlphaBeta(goalPlayerMax, goalPlayerMin, a_maxPlayer, depth, a_playoutLookahead, a_gs, a_dd, a_f, a_playoutAI);
            nPlayoutsBeforeStartingLastTime = nPlayouts;
            if (depth <= MAX_TREE_DEPTH) {
                int nPlayoutsleft = maxPlayouts - nPlayouts;
                if (maxPlayouts < 0 || nPlayoutsleft > nPlayoutsUSedLastTime) {
                    if (DEBUG >= 1) {
                        System.out.println("last time we used " + nPlayoutsUSedLastTime + ", and there are " + nPlayoutsleft + " left, trying one more depth!");
                    }
                    best = planner.getBestPlan(timeLimit, maxPlayouts, bestLastDepth == null);
                } else if (DEBUG >= 1) {
                    System.out.println("last time we used " + nPlayoutsUSedLastTime + ", and there are only " + nPlayoutsleft + " left..., canceling search");
                }
            }
            nPlayoutsUSedLastTime = nPlayouts - nPlayoutsBeforeStartingLastTime;
            if (DEBUG >= 1) {
                System.out.println("    time taken: " + (System.currentTimeMillis() - currentTime));
            }
            if (DEBUG >= 1 && best != null) {
                System.out.println("Max plan:");
                if (best.m_a != null) {
                    List<Pair<Integer, List<Term>>> l = ((MethodDecomposition)best.m_a).convertToOperatorList();
                    for (Pair<Integer, List<Term>> a : l) {
                        System.out.println("  " + a.m_a + ": " + a.m_b);
                    }
                }
                if (best.m_b != null) {
                    System.out.println("Min plan:");
                    List<Pair<Integer, List<Term>>> l2 = ((MethodDecomposition)best.m_b).convertToOperatorList();
                    for (Pair<Integer, List<Term>> a : l2) {
                        System.out.println("  " + a.m_a + ": " + a.m_b);
                    }
                }
            }
            if (best != null) {
                bestLastDepth = best;
                tmp_leaves = last_tree_leaves;
                tmp_nodes = last_tree_nodes;
                tmp_depth = last_tree_depth;
                tmp_time = last_time_depth;
                if (planner.lastRunSolvedTheProblem) {
                    ++n_trees;
                    if (tmp_leaves > max_tree_leaves) {
                        max_tree_leaves = tmp_leaves;
                    }
                    average_tree_leaves += tmp_leaves;
                    if (tmp_nodes > max_tree_nodes) {
                        max_tree_nodes = tmp_nodes;
                    }
                    average_tree_nodes += tmp_nodes;
                    average_tree_depth += tmp_depth;
                    if (tmp_depth >= max_tree_depth) {
                        max_tree_depth = tmp_depth;
                    }
                    average_time_depth += tmp_time;
                    if (tmp_time >= max_time_depth) {
                        max_time_depth = tmp_time;
                    }
                    ++n_iterative_deepening_runs;
                    average_iterative_deepening_depth += (double)depth;
                    if ((double)depth > max_iterative_deepening_depth) {
                        max_iterative_deepening_depth = depth;
                    }
                    return bestLastDepth;
                }
            } else {
                ++n_trees;
                if (tmp_leaves > max_tree_leaves) {
                    max_tree_leaves = tmp_leaves;
                }
                average_tree_leaves += tmp_leaves;
                if (tmp_nodes > max_tree_nodes) {
                    max_tree_nodes = tmp_nodes;
                }
                average_tree_nodes += tmp_nodes;
                average_tree_depth += tmp_depth;
                if (tmp_depth >= max_tree_depth) {
                    max_tree_depth = tmp_depth;
                }
                average_time_depth += tmp_time;
                if (tmp_time >= max_time_depth) {
                    max_time_depth = tmp_time;
                }
                ++n_iterative_deepening_runs;
                average_iterative_deepening_depth += (double)(depth - 1);
                if ((double)(depth - 1) > max_iterative_deepening_depth) {
                    max_iterative_deepening_depth = depth - 1;
                }
                return bestLastDepth;
            }
            ++depth;
        }
    }

    /*
     * Unable to fully structure code
     */
    public AdversarialChoicePoint simulateUntilNextChoicePoint(List<Binding> bindings, AdversarialChoicePoint previous_cp) throws Exception {
        gs = previous_cp.gs;
        gs2 = gs.clone();
        lastTimeOperatorsIssued = previous_cp.getLastTimeOperatorsIssued();
        operatorDepth = previous_cp.getOperatorDepth();
        block0: while (true) {
            if (!AdversarialBoundedDepthPlannerAlphaBeta.SIMULATE_UNTIL_NEXT_CHOICEPOINT && operatorDepth >= this.maxDepth && gs2.getTime() > lastTimeOperatorsIssued) {
                return new AdversarialChoicePoint(null, null, previous_cp.maxPlanRoot, previous_cp.minPlanRoot, gs2, operatorDepth, lastTimeOperatorsIssued, previous_cp.getAlpha(), previous_cp.getBeta(), false);
            }
            actions1 = new ArrayList<MethodDecomposition>();
            actions2 = new ArrayList<MethodDecomposition>();
            choicePoints1 = new ArrayList<MethodDecomposition>();
            choicePoints2 = new ArrayList<MethodDecomposition>();
            er1 = previous_cp.maxPlanRoot.executionCycle(gs2, actions1, choicePoints1, previous_cp);
            er2 = previous_cp.minPlanRoot.executionCycle(gs2, actions2, choicePoints2, previous_cp);
            if (AdversarialBoundedDepthPlannerAlphaBeta.SIMULATE_UNTIL_NEXT_CHOICEPOINT && operatorDepth >= this.maxDepth && gs2.getTime() > lastTimeOperatorsIssued && (er1 == 4 || er2 == 4)) {
                return new AdversarialChoicePoint(null, null, previous_cp.maxPlanRoot, previous_cp.minPlanRoot, gs2, operatorDepth, lastTimeOperatorsIssued, previous_cp.getAlpha(), previous_cp.getBeta(), false);
            }
            if (er1 == 0 && er2 == 0) {
                return new AdversarialChoicePoint(null, null, previous_cp.maxPlanRoot, previous_cp.minPlanRoot, gs2, operatorDepth, lastTimeOperatorsIssued, previous_cp.getAlpha(), previous_cp.getBeta(), false);
            }
            if (er1 == 1 || er2 == 1) {
                if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG >= 2) {
                    System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: execution failure " + er1 + ", " + er2);
                }
                return null;
            }
            if (er1 != 4 && er2 != 4) ** GOTO lbl33
            v0 = cp_md = choicePoints1.isEmpty() != false ? null : (MethodDecomposition)choicePoints1.get(0);
            if (cp_md == null) {
                v1 = cp_md = choicePoints2.isEmpty() != false ? null : (MethodDecomposition)choicePoints2.get(0);
            }
            if (cp_md.getType() == 5) {
                acp = new AdversarialChoicePoint(choicePoints1.isEmpty() != false ? null : (MethodDecomposition)choicePoints1.get(0), choicePoints2.isEmpty() != false ? null : (MethodDecomposition)choicePoints2.get(0), previous_cp.maxPlanRoot, previous_cp.minPlanRoot, gs2, operatorDepth, lastTimeOperatorsIssued, previous_cp.getAlpha(), previous_cp.getBeta(), false);
                if (!acp.nextExpansion(this.dd, bindings, this.renamingIndex, acp)) {
                    return null;
                }
                ++this.renamingIndex;
            } else {
                return new AdversarialChoicePoint(choicePoints1.isEmpty() != false ? null : (MethodDecomposition)choicePoints1.get(0), choicePoints2.isEmpty() != false ? null : (MethodDecomposition)choicePoints2.get(0), previous_cp.maxPlanRoot, previous_cp.minPlanRoot, gs2, operatorDepth, lastTimeOperatorsIssued, previous_cp.getAlpha(), previous_cp.getBeta(), false);
lbl33:
                // 1 sources

                if ((er1 == 3 || er2 == 3) && er1 != 2 && er2 != 2) {
                    gameover = gs2.cycle();
                    if (gameover) {
                        return new AdversarialChoicePoint(null, null, previous_cp.maxPlanRoot, previous_cp.minPlanRoot, gs2, operatorDepth, lastTimeOperatorsIssued, previous_cp.getAlpha(), previous_cp.getBeta(), false);
                    }
                    toDelete = null;
                    if (previous_cp.maxPlanRoot.getOperatorsBeingExecuted() != null) {
                        for (MethodDecomposition md : previous_cp.maxPlanRoot.getOperatorsBeingExecuted()) {
                            previous_cp.captureExecutionStateNonRecursive(md);
                            if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG >= 2) {
                                System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: continuing executing operator " + md.getUpdatedTerm());
                            }
                            if (PredefinedOperators.execute(md, gs2) || gs2.getTime() > md.getUpdatedTermCycle() + this.operatorExecutionTimeout) {
                                md.setExecutionState(2);
                                if (toDelete == null) {
                                    toDelete = new ArrayList<MethodDecomposition>();
                                }
                                toDelete.add(md);
                                if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG < 2) continue;
                                System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: operator complete (1).");
                                continue;
                            }
                            md.setExecutionState(1);
                        }
                        if (toDelete != null) {
                            previous_cp.maxPlanRoot.getOperatorsBeingExecuted().removeAll(toDelete);
                        }
                    }
                    if (previous_cp.minPlanRoot.getOperatorsBeingExecuted() != null) {
                        toDelete = null;
                        for (MethodDecomposition md : previous_cp.minPlanRoot.getOperatorsBeingExecuted()) {
                            previous_cp.captureExecutionStateNonRecursive(md);
                            if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG >= 2) {
                                System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: continuing executing operator " + md.getUpdatedTerm());
                            }
                            if (PredefinedOperators.execute(md, gs2) || gs2.getTime() > md.getUpdatedTermCycle() + this.operatorExecutionTimeout) {
                                md.setExecutionState(2);
                                if (toDelete == null) {
                                    toDelete = new ArrayList<E>();
                                }
                                toDelete.add(md);
                                if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG < 2) continue;
                                System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: operator complete (2).");
                                continue;
                            }
                            md.setExecutionState(1);
                        }
                        if (toDelete != null) {
                            previous_cp.minPlanRoot.getOperatorsBeingExecuted().removeAll(toDelete);
                        }
                    }
                }
            }
            if ((er1 == 2 || er2 == 2) && gs2.getTime() > lastTimeOperatorsIssued) {
                lastTimeOperatorsIssued = gs2.getTime();
                ++operatorDepth;
            }
            if (er1 == 2) {
                for (MethodDecomposition md : actions1) {
                    previous_cp.captureExecutionStateNonRecursive(md);
                    md.setUpdatedTerm(md.getTerm().clone());
                    md.getUpdatedTerm().applyBindings(bindings);
                    md.setUpdatedTermCycle(gs2.getTime());
                    if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG >= 2) {
                        System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: executing operator " + md.getUpdatedTerm());
                    }
                    md.setOperatorExecutingState(0);
                    if (PredefinedOperators.execute(md, gs2)) {
                        md.setExecutionState(2);
                        if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG < 2) continue;
                        System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: operator complete (3).");
                        continue;
                    }
                    md.setExecutionState(1);
                    if (previous_cp.maxPlanRoot.getOperatorsBeingExecuted() == null) {
                        previous_cp.maxPlanRoot.setOperatorsBeingExecuted(new ArrayList<MethodDecomposition>());
                    }
                    previous_cp.maxPlanRoot.getOperatorsBeingExecuted().add(md);
                }
            }
            if (er2 != 2) continue;
            var13_16 = actions2.iterator();
            while (true) {
                if (var13_16.hasNext()) ** break;
                continue block0;
                md = (MethodDecomposition)var13_16.next();
                previous_cp.captureExecutionStateNonRecursive(md);
                md.setUpdatedTerm(md.getTerm().clone());
                md.getUpdatedTerm().applyBindings(bindings);
                md.setUpdatedTermCycle(gs2.getTime());
                if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG >= 2) {
                    System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: executing operator " + md.getUpdatedTerm());
                }
                md.setOperatorExecutingState(0);
                if (PredefinedOperators.execute(md, gs2)) {
                    md.setExecutionState(2);
                    if (AdversarialBoundedDepthPlannerAlphaBeta.DEBUG < 2) continue;
                    System.out.println("AdversarialBoundedDepthPlanner.simulateUntilNextChoicePoint: operator complete (4).");
                    continue;
                }
                md.setExecutionState(1);
                if (previous_cp.minPlanRoot.getOperatorsBeingExecuted() == null) {
                    previous_cp.minPlanRoot.setOperatorsBeingExecuted(new ArrayList<MethodDecomposition>());
                }
                previous_cp.minPlanRoot.getOperatorsBeingExecuted().add(md);
            }
            break;
        }
    }

    public void stackPop() {
        AdversarialChoicePoint cp = this.stack.remove(0);
        cp.restoreAfterPop();
        int tmp = this.trail.remove(0);
        if (DEBUG >= 2) {
            System.out.println("StackPop! removing " + tmp + " bindings.");
        }
        for (int i = 0; i < tmp; ++i) {
            this.bindings.remove(0);
        }
        if (!this.stack.isEmpty()) {
            this.stack.get(0).restoreExecutionState();
        }
    }

    public float playout(int player, GameState gs) throws Exception {
        ++nPlayouts;
        GameState gs2 = gs;
        if (this.PLAYOUT_LOOKAHEAD > 0 && this.playoutAI != null) {
            AI ai1 = this.playoutAI.clone();
            AI ai2 = this.playoutAI.clone();
            gs2 = gs.clone();
            ai1.reset();
            ai2.reset();
            int timeLimit = gs2.getTime() + this.PLAYOUT_LOOKAHEAD;
            boolean gameover = false;
            while (!gameover && gs2.getTime() < timeLimit) {
                if (gs2.isComplete()) {
                    gameover = gs2.cycle();
                    continue;
                }
                PlayerAction pa1 = ai1.getAction(player, gs2);
                PlayerAction pa2 = ai2.getAction(1 - player, gs2);
                gs2.issue(pa1);
                gs2.issue(pa2);
            }
        }
        float e = this.f.evaluate(player, 1 - player, gs2);
        return e;
    }
}

