/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.planner;

import ai.ahtn.domain.Binding;
import ai.ahtn.domain.Clause;
import ai.ahtn.domain.DomainDefinition;
import ai.ahtn.domain.HTNMethod;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.planner.MethodDecompositionState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import rts.GameState;

public class AdversarialChoicePoint {
    public static int DEBUG = 0;
    public MethodDecomposition maxPlanRoot;
    public MethodDecomposition minPlanRoot;
    public MethodDecomposition choicePointPlayerMax;
    public MethodDecomposition choicePointPlayerMin;
    public GameState gs;
    int lastTimeOperatorsIssued = -1;
    int operatorDepth = 0;
    List<HTNMethod> possibleMethods;
    Clause updatedClause;
    boolean updatedClauseHadAnyMatches = false;
    List<Binding> lastBindings;
    HashMap<MethodDecomposition, MethodDecompositionState> executionState;
    public int minimaxType = -1;
    public float bestEvaluation = 0.0f;
    public MethodDecomposition bestMaxPlan;
    public MethodDecomposition bestMinPlan;
    float alpha = 0.0f;
    float beta = 0.0f;

    private AdversarialChoicePoint() {
        this.executionState = new HashMap();
    }

    public AdversarialChoicePoint(MethodDecomposition cpMax, MethodDecomposition cpMin, MethodDecomposition rootMax, MethodDecomposition rootMin, GameState a_gs, int nops, int ltoi) {
        this.maxPlanRoot = rootMax;
        this.minPlanRoot = rootMin;
        this.choicePointPlayerMax = cpMax;
        this.choicePointPlayerMin = cpMin;
        this.gs = a_gs;
        this.operatorDepth = nops;
        this.lastTimeOperatorsIssued = ltoi;
        this.executionState = new HashMap();
        this.captureExecutionState(rootMax);
        this.captureExecutionState(rootMin);
    }

    public AdversarialChoicePoint(MethodDecomposition cpMax, MethodDecomposition cpMin, MethodDecomposition rootMax, MethodDecomposition rootMin, GameState a_gs, int nops, int ltoi, float a, float b, boolean saveExecutionState) {
        this.maxPlanRoot = rootMax;
        this.minPlanRoot = rootMin;
        this.choicePointPlayerMax = cpMax;
        this.choicePointPlayerMin = cpMin;
        this.gs = a_gs;
        this.operatorDepth = nops;
        this.lastTimeOperatorsIssued = ltoi;
        this.alpha = a;
        this.beta = b;
        this.executionState = new HashMap();
        if (saveExecutionState) {
            this.captureExecutionState(rootMax);
            this.captureExecutionState(rootMin);
        } else {
            this.captureExecutionStateNonRecursive(rootMax);
            this.captureExecutionStateNonRecursive(rootMin);
        }
    }

    public AdversarialChoicePoint cloneForMCTS() {
        AdversarialChoicePoint acp = new AdversarialChoicePoint();
        MethodDecomposition[] in1 = new MethodDecomposition[]{this.choicePointPlayerMax};
        MethodDecomposition[] out1 = new MethodDecomposition[]{null};
        acp.maxPlanRoot = this.maxPlanRoot.cloneTrackingDescendants(in1, out1);
        MethodDecomposition[] in2 = new MethodDecomposition[]{this.choicePointPlayerMin};
        MethodDecomposition[] out2 = new MethodDecomposition[]{null};
        acp.minPlanRoot = this.minPlanRoot.cloneTrackingDescendants(in2, out2);
        acp.choicePointPlayerMax = out1[0];
        acp.choicePointPlayerMin = out2[0];
        acp.gs = this.gs.clone();
        acp.lastTimeOperatorsIssued = this.lastTimeOperatorsIssued;
        acp.operatorDepth = this.operatorDepth;
        return acp;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getBeta() {
        return this.beta;
    }

    public void setAlpha(float a) {
        this.alpha = a;
    }

    public void setBeta(float b) {
        this.beta = b;
    }

    public int getOperatorDepth() {
        return this.operatorDepth;
    }

    public int getLastTimeOperatorsIssued() {
        return this.lastTimeOperatorsIssued;
    }

    public void setLastTimeOperatorsIssued(int ltoi) {
        this.lastTimeOperatorsIssued = ltoi;
    }

    public float getBestEvaluation() {
        return this.bestEvaluation;
    }

    public void setBestEvaluation(float be) {
        this.bestEvaluation = be;
    }

    public int getMiniMaxType() {
        return this.minimaxType;
    }

    public GameState getGameState() {
        return this.gs;
    }

    public void captureExecutionState(MethodDecomposition md) {
        this.executionState.put(md, new MethodDecompositionState(md));
        if (md.getSubparts() != null) {
            for (int i = 0; i < md.getSubparts().length; ++i) {
                this.captureExecutionState(md.getSubparts()[i]);
            }
        }
        if (md.getMethod() != null) {
            this.captureExecutionState(md.getMethod().getDecomposition());
        }
    }

    public void captureExecutionStateNonRecursive(MethodDecomposition md) {
        if (this.executionState.get(md) == null) {
            this.executionState.put(md, new MethodDecompositionState(md));
        }
    }

    public void restoreExecutionState() {
        for (MethodDecomposition md : this.executionState.keySet()) {
            this.executionState.get(md).restoreState(md);
        }
    }

    public void restoreAfterPop() {
        if (this.choicePointPlayerMax != null && this.choicePointPlayerMax.getType() == 2) {
            this.choicePointPlayerMax.setMethod(null);
        }
        if (this.choicePointPlayerMin != null && this.choicePointPlayerMin.getType() == 2) {
            this.choicePointPlayerMin.setMethod(null);
        }
    }

    public boolean nextExpansion(DomainDefinition dd, List<Binding> bindings, int renamingIndex, AdversarialChoicePoint previous_cp) throws Exception {
        if (this.choicePointPlayerMax != null) {
            previous_cp.captureExecutionStateNonRecursive(this.choicePointPlayerMax);
            if (this.choicePointPlayerMax.getType() == 2) {
                return this.nextMethodExpansion(this.choicePointPlayerMax, this.gs, dd, bindings, renamingIndex);
            }
            if (this.choicePointPlayerMax.getType() == 0 || this.choicePointPlayerMax.getType() == 5) {
                return this.nextConditionExpansion(this.choicePointPlayerMax, bindings);
            }
            throw new Exception("Wrong MethodDecomposition in choicePoint!");
        }
        previous_cp.captureExecutionStateNonRecursive(this.choicePointPlayerMin);
        if (this.choicePointPlayerMin.getType() == 2) {
            return this.nextMethodExpansion(this.choicePointPlayerMin, this.gs, dd, bindings, renamingIndex);
        }
        if (this.choicePointPlayerMin.getType() == 0 || this.choicePointPlayerMin.getType() == 5) {
            return this.nextConditionExpansion(this.choicePointPlayerMin, bindings);
        }
        throw new Exception("Wrong MethodDecomposition in choicePoint!");
    }

    private boolean nextConditionExpansion(MethodDecomposition choicePoint, List<Binding> bindings) throws Exception {
        List<Binding> l;
        if (DEBUG >= 1) {
            System.out.println("AdversarialChoicePoint.nextExpansionCondition: testing " + choicePoint.getClause());
        }
        if (this.updatedClause == null) {
            this.updatedClause = choicePoint.getClause().clone();
            this.updatedClause.applyBindings(bindings);
            this.updatedClauseHadAnyMatches = false;
            this.lastBindings = null;
        }
        do {
            l = this.updatedClause.nextMatch(this.gs);
            if (DEBUG >= 1) {
                System.out.println("AdversarialChoicePoint.nextConditionExpansion: bindings: " + l);
            }
            if (l != null) continue;
            if (this.updatedClauseHadAnyMatches) {
                this.updatedClause = null;
                return false;
            }
            choicePoint.setExecutionState(2);
            this.updatedClauseHadAnyMatches = true;
            return true;
        } while (this.lastBindings != null && l.equals(this.lastBindings));
        this.lastBindings = new ArrayList<Binding>();
        this.lastBindings.addAll(l);
        this.updatedClauseHadAnyMatches = true;
        choicePoint.setExecutionState(1);
        for (Binding b : l) {
            bindings.add(0, b);
        }
        return true;
    }

    public boolean nextMethodExpansion(MethodDecomposition choicePoint, GameState gs, DomainDefinition dd, List<Binding> bindings, int renamingIndex) throws Exception {
        if (DEBUG >= 1) {
            System.out.println("AdversarialChoicePoint.nextMethodExpansion: testing " + choicePoint.getTerm());
        }
        if (this.possibleMethods == null) {
            List<HTNMethod> methods = dd.getMethodsForGoal(choicePoint.getTerm().getFunctor());
            if (methods == null) {
                throw new Exception("No methods for: " + choicePoint.getTerm().getFunctor());
            }
            this.possibleMethods = new ArrayList<HTNMethod>();
            this.possibleMethods.addAll(methods);
            if (DEBUG >= 1) {
                System.out.println("AdversarialChoicePoint.nextMethodExpansion: Goal: " + choicePoint.getTerm());
            }
            if (DEBUG >= 1) {
                System.out.println("AdversarialChoicePoint.nextMethodExpansion: Methods found: " + methods.size());
            }
        }
        if (this.possibleMethods.isEmpty()) {
            this.possibleMethods = null;
            choicePoint.setMethod(null);
            return false;
        }
        HTNMethod m = this.possibleMethods.remove(0);
        this.setMethod(choicePoint, m, gs, bindings, renamingIndex);
        return true;
    }

    public void setMethod(MethodDecomposition choicePoint, HTNMethod original, GameState gs, List<Binding> bindings, int renamingIndex) throws Exception {
        HTNMethod m = original.clone();
        choicePoint.setMethod(m);
        List<Binding> bindings2 = m.getHead().simpleUnificationDestructiveNoSharedVariables(choicePoint.getTerm(), gs);
        if (DEBUG >= 1) {
            System.out.println("AdversarialChoicePoint.setMethod: bindings2 " + bindings2);
        }
        m.applyBindings(bindings2);
        m.applyBindings(bindings);
        m.renameVariables(renamingIndex);
    }

    public boolean processEvaluation(float f, MethodDecomposition maxPlan, MethodDecomposition minPlan, boolean clone) {
        switch (this.minimaxType) {
            case -1: {
                if (this.choicePointPlayerMax != null) {
                    this.bestEvaluation = f;
                    MethodDecomposition methodDecomposition = maxPlan == null ? null : (this.bestMaxPlan = clone ? maxPlan.clone() : maxPlan);
                    this.bestMinPlan = minPlan == null ? null : (clone ? minPlan.clone() : minPlan);
                    this.minimaxType = 0;
                    break;
                }
                this.bestEvaluation = f;
                MethodDecomposition methodDecomposition = maxPlan == null ? null : (this.bestMaxPlan = clone ? maxPlan.clone() : maxPlan);
                this.bestMinPlan = minPlan == null ? null : (clone ? minPlan.clone() : minPlan);
                this.minimaxType = 1;
                break;
            }
            case 0: {
                if ((this.bestMaxPlan != null || maxPlan == null && !(f > this.bestEvaluation)) && (this.bestMaxPlan == null || minPlan == null || !(f > this.bestEvaluation))) break;
                this.bestEvaluation = f;
                MethodDecomposition methodDecomposition = maxPlan == null ? null : (this.bestMaxPlan = clone ? maxPlan.clone() : maxPlan);
                this.bestMinPlan = minPlan == null ? null : (clone ? minPlan.clone() : minPlan);
                break;
            }
            case 1: {
                if ((this.bestMinPlan != null || minPlan == null && !(f < this.bestEvaluation)) && (this.bestMinPlan == null || minPlan == null || !(f < this.bestEvaluation))) break;
                this.bestEvaluation = f;
                MethodDecomposition methodDecomposition = maxPlan == null ? null : (this.bestMaxPlan = clone ? maxPlan.clone() : maxPlan);
                MethodDecomposition methodDecomposition2 = minPlan == null ? null : (this.bestMinPlan = clone ? minPlan.clone() : minPlan);
            }
        }
        if (this.minimaxType == 0) {
            this.alpha = Math.max(this.alpha, f);
        } else if (this.minimaxType == 1) {
            this.beta = Math.min(this.beta, f);
        }
        return this.beta <= this.alpha;
    }

    public String toString() {
        String tmp = "( ";
        tmp = this.choicePointPlayerMax == null ? tmp + "null" : (this.choicePointPlayerMax.getType() == 2 ? tmp + "choicePointPlayerMax(" + this.choicePointPlayerMax.getTerm() + ")" : (this.choicePointPlayerMax.getType() == 0 ? tmp + "choicePointPlayerMax(" + this.choicePointPlayerMax.getClause() + ")" : tmp + "choicePointPlayerMax(???)"));
        tmp = tmp + " , ";
        tmp = this.choicePointPlayerMin == null ? tmp + "null" : (this.choicePointPlayerMin.getType() == 2 ? tmp + "choicePointPlayerMin(" + this.choicePointPlayerMin.getTerm() + ")" : (this.choicePointPlayerMin.getType() == 0 ? tmp + "choicePointPlayerMin(" + this.choicePointPlayerMin.getClause() + ")" : tmp + "choicePointPlayerMin(???)"));
        return tmp + ")";
    }
}

