/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.planner;

import ai.ahtn.domain.MethodDecomposition;
import java.util.ArrayList;
import java.util.List;

public class MethodDecompositionState {
    int executionState = 0;
    int operatorExecutingState = 0;
    List<MethodDecomposition> operatorsBeingExecuted;

    public MethodDecompositionState(MethodDecomposition md) {
        this.executionState = md.getExecutionState();
        this.operatorExecutingState = md.getOperatorExecutingState();
        if (md.getOperatorsBeingExecuted() != null) {
            this.operatorsBeingExecuted = new ArrayList<MethodDecomposition>();
            this.operatorsBeingExecuted.addAll(md.getOperatorsBeingExecuted());
        }
    }

    public void restoreState(MethodDecomposition md) {
        md.setExecutionState(this.executionState);
        md.setOperatorExecutingState(this.operatorExecutingState);
        if (this.operatorsBeingExecuted == null) {
            md.setOperatorsBeingExecuted(null);
        } else {
            List<MethodDecomposition> l = md.getOperatorsBeingExecuted();
            if (l == null) {
                l = new ArrayList<MethodDecomposition>();
                md.setOperatorsBeingExecuted(l);
            }
            l.clear();
            l.addAll(this.operatorsBeingExecuted);
        }
    }
}

