/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.visualization;

import ai.ahtn.domain.DomainDefinition;
import ai.ahtn.domain.HTNMethod;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.domain.Symbol;
import ai.ahtn.domain.Term;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;

public class HTNDomainVisualizer {
    public static int DEBUG = 0;
    int hpadding = 8;
    int vpadding = 4;
    int hMethodPadding = 16;
    int vMethodPadding = 16;
    Font font = new Font("Arial", 0, 10);
    FontMetrics fm;

    public static void main(String[] args) throws Exception {
        DomainDefinition dd = DomainDefinition.fromLispFile("ahtn/microrts-ahtn-definition-portfolio.lisp");
        System.out.println(dd);
        HTNDomainVisualizer v = new HTNDomainVisualizer();
        BufferedImage img = v.visualizeHTNDomain(dd, new Symbol("destroy-player"));
        ImageIO.write((RenderedImage)img, "png", new File("HTN-domain.png"));
    }

    public HTNDomainVisualizer() {
        Canvas c = new Canvas();
        this.fm = c.getFontMetrics(this.font);
    }

    public BufferedImage visualizeHTNDomain(DomainDefinition d, Symbol root) throws Exception {
        LinkedList<Symbol> alreadyProcessed = new LinkedList<Symbol>();
        return this.visualizeHTNTask(d, root, alreadyProcessed);
    }

    public BufferedImage visualizeHTNOperator(Symbol root) throws Exception {
        int textWidth = this.fm.stringWidth(root.get());
        BufferedImage img = new BufferedImage(this.hpadding * 2 + textWidth, this.vpadding * 2 + this.fm.getHeight(), 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(this.font);
        g2d.setColor(new Color(0, 127, 0));
        g2d.fillRect(0, 0, img.getWidth(), img.getHeight());
        g2d.setColor(Color.WHITE);
        g2d.drawString(root.get(), this.hpadding, this.vpadding + this.fm.getHeight());
        return img;
    }

    public BufferedImage visualizeHTNOperator(Term t) throws Exception {
        String name = t.toString();
        int textWidth = this.fm.stringWidth(name);
        BufferedImage img = new BufferedImage(this.hpadding * 2 + textWidth, this.vpadding * 2 + this.fm.getHeight(), 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(this.font);
        g2d.setColor(new Color(0, 127, 0));
        g2d.fillRect(0, 0, img.getWidth(), img.getHeight());
        g2d.setColor(Color.WHITE);
        g2d.drawString(name, this.hpadding, this.vpadding + this.fm.getHeight());
        return img;
    }

    public BufferedImage visualizeHTNTask(DomainDefinition d, Symbol root, List<Symbol> alreadyProcessed) throws Exception {
        if (alreadyProcessed.contains(root)) {
            if (DEBUG >= 1) {
                System.out.println("visualizeHTNTask (already processed): " + root);
            }
            int textWidth = this.fm.stringWidth(root.get());
            BufferedImage img = new BufferedImage(this.hpadding * 2 + textWidth, this.vpadding * 2 + this.fm.getHeight(), 2);
            Graphics2D g2d = img.createGraphics();
            g2d.setFont(this.font);
            g2d.setColor(Color.RED);
            g2d.fillRect(0, 0, img.getWidth(), img.getHeight());
            g2d.setColor(Color.WHITE);
            g2d.drawString(root.get(), this.hpadding, this.vpadding + this.fm.getHeight());
            return img;
        }
        if (DEBUG >= 1) {
            System.out.println("visualizeHTNTask: " + root);
        }
        alreadyProcessed.add(root);
        List<HTNMethod> methods = d.getMethodsForGoal(new Symbol(root));
        int textWidth = this.fm.stringWidth(root.get());
        int methodWidth = 0;
        int methodHeight = 0;
        LinkedList<BufferedImage> images = new LinkedList<BufferedImage>();
        for (HTNMethod m : methods) {
            BufferedImage img2 = this.visualizeHTNMethod(d, m, alreadyProcessed);
            images.add(img2);
            methodWidth += img2.getWidth();
            methodHeight = Math.max(methodHeight, img2.getHeight());
        }
        int width = Math.max(textWidth + 2 * this.hpadding, methodWidth += methods.size() * this.hMethodPadding);
        BufferedImage img = new BufferedImage(width, this.fm.getHeight() + 2 * this.vpadding + this.vMethodPadding + methodHeight, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(this.font);
        if (DEBUG >= 1) {
            System.out.println("  visualizeHTNTask img: " + img.getWidth() + " x " + img.getHeight() + " (methodHeight: " + methodHeight + ")");
        }
        int x = 0;
        for (BufferedImage img2 : images) {
            g2d.setColor(Color.BLACK);
            g2d.drawLine(width / 2, this.fm.getHeight() + this.vpadding * 2, x + img2.getWidth() / 2, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding);
            g2d.drawImage((Image)img2, x, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding, null);
            x += img2.getWidth() + this.hMethodPadding;
        }
        g2d.setColor(Color.BLACK);
        g2d.fillRect(width / 2 - (textWidth + 2 * this.hpadding) / 2, 0, textWidth + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        g2d.setColor(Color.WHITE);
        g2d.drawString(root.get(), width / 2 - (textWidth + 2 * this.hpadding) / 2 + this.hpadding, this.vpadding + this.fm.getHeight());
        return img;
    }

    public BufferedImage visualizeHTNMethod(DomainDefinition d, HTNMethod m, List<Symbol> alreadyProcessed) throws Exception {
        LinkedList<Symbol> children = new LinkedList<Symbol>();
        LinkedList<BufferedImage> images = new LinkedList<BufferedImage>();
        if (DEBUG >= 1) {
            System.out.println("visualizeHTNMethod: " + m.getName());
        }
        LinkedList<MethodDecomposition> stack = new LinkedList<MethodDecomposition>();
        stack.add(m.getDecomposition());
        while (!stack.isEmpty()) {
            MethodDecomposition md = (MethodDecomposition)stack.remove(0);
            switch (md.getType()) {
                case 1: {
                    children.add(md.getTerm().getFunctor());
                    break;
                }
                case 2: {
                    children.add(md.getTerm().getFunctor());
                    break;
                }
                case 3: {
                    stack.addAll(Arrays.asList(md.getSubparts()));
                    break;
                }
                case 4: {
                    stack.addAll(Arrays.asList(md.getSubparts()));
                    break;
                }
            }
        }
        int textWidth = this.fm.stringWidth(m.getName());
        int childrenWidth = 0;
        int childrenHeight = 0;
        for (Symbol c : children) {
            BufferedImage img;
            if (c.get().startsWith("!")) {
                img = this.visualizeHTNOperator(c);
                images.add(img);
                childrenWidth += img.getWidth();
                childrenHeight = Math.max(childrenHeight, img.getHeight());
                continue;
            }
            img = this.visualizeHTNTask(d, c, alreadyProcessed);
            images.add(img);
            childrenWidth += img.getWidth();
            childrenHeight = Math.max(childrenHeight, img.getHeight());
        }
        int width = Math.max(textWidth + 2 * this.hpadding, childrenWidth += children.size() * this.hMethodPadding);
        BufferedImage img = new BufferedImage(width, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding + childrenHeight, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(this.font);
        if (DEBUG >= 1) {
            System.out.println("  visualizeHTNMethod img: " + img.getWidth() + " x " + img.getHeight());
        }
        int x = 0;
        for (BufferedImage img2 : images) {
            g2d.setColor(Color.BLACK);
            g2d.drawLine(width / 2, this.fm.getHeight() + this.vpadding * 2, x + img2.getWidth() / 2, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding);
            g2d.drawImage((Image)img2, x, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding, null);
            x += img2.getWidth() + this.hMethodPadding;
        }
        g2d.setColor(Color.GRAY);
        g2d.fillRect(width / 2 - (textWidth + 2 * this.hpadding) / 2, 0, textWidth + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        g2d.setColor(Color.BLACK);
        g2d.drawString(m.getName(), width / 2 - (textWidth + 2 * this.hpadding) / 2 + this.hpadding, this.vpadding + this.fm.getHeight());
        return img;
    }

    public BufferedImage visualizeHTNPlan(HTNMethod m) throws Exception {
        LinkedList<BufferedImage> images = new LinkedList<BufferedImage>();
        String m_head_name = m.getHead().toString();
        String m_name = m.getName();
        int textWidth = Math.max(this.fm.stringWidth(m_name), this.fm.stringWidth(m_head_name));
        int childrenWidth = 0;
        int childrenHeight = 0;
        if (DEBUG >= 1) {
            System.out.println("visualizeHTNPlan: " + m_name);
        }
        LinkedList<MethodDecomposition> stack = new LinkedList<MethodDecomposition>();
        if (m.getDecomposition() != null) {
            stack.add(m.getDecomposition());
        }
        while (!stack.isEmpty()) {
            MethodDecomposition md = (MethodDecomposition)stack.remove(0);
            switch (md.getType()) {
                case 1: {
                    BufferedImage img2 = this.visualizeHTNOperator(md.getTerm());
                    images.add(img2);
                    childrenWidth += img2.getWidth();
                    childrenHeight = Math.max(childrenHeight, img2.getHeight());
                    break;
                }
                case 2: {
                    BufferedImage img2 = this.visualizeHTNPlan(md);
                    images.add(img2);
                    childrenWidth += img2.getWidth();
                    childrenHeight = Math.max(childrenHeight, img2.getHeight());
                    break;
                }
                case 3: {
                    stack.addAll(Arrays.asList(md.getSubparts()));
                    break;
                }
                case 4: {
                    stack.addAll(Arrays.asList(md.getSubparts()));
                    break;
                }
            }
        }
        int width = Math.max(textWidth + 2 * this.hpadding, childrenWidth += images.size() * this.hMethodPadding);
        BufferedImage img = new BufferedImage(width, (this.fm.getHeight() + this.vpadding * 2) * 2 + this.vMethodPadding + childrenHeight, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(this.font);
        if (DEBUG >= 1) {
            System.out.println("  visualizeHTNMethod img: " + img.getWidth() + " x " + img.getHeight());
        }
        int x = 0;
        for (BufferedImage img2 : images) {
            g2d.setColor(Color.BLACK);
            g2d.drawLine(width / 2, (this.fm.getHeight() + this.vpadding * 2) * 2, x + img2.getWidth() / 2, (this.fm.getHeight() + this.vpadding * 2) * 2 + this.vMethodPadding);
            g2d.drawImage((Image)img2, x, (this.fm.getHeight() + this.vpadding * 2) * 2 + this.vMethodPadding, null);
            x += img2.getWidth() + this.hMethodPadding;
        }
        g2d.setColor(Color.GRAY);
        g2d.fillRect(width / 2 - (textWidth + 2 * this.hpadding) / 2, 0, textWidth + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        g2d.setColor(Color.BLACK);
        g2d.drawString(m_head_name, width / 2 - (textWidth + 2 * this.hpadding) / 2 + this.hpadding, this.vpadding + this.fm.getHeight());
        g2d.setColor(Color.BLACK);
        g2d.fillRect(width / 2 - (textWidth + 2 * this.hpadding) / 2, this.fm.getHeight() + this.vpadding * 2, textWidth + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        g2d.setColor(Color.WHITE);
        g2d.drawString(m_name, width / 2 - (textWidth + 2 * this.hpadding) / 2 + this.hpadding, this.fm.getHeight() + this.vpadding * 2 + this.vpadding + this.fm.getHeight());
        return img;
    }

    public BufferedImage visualizeHTNPlan(MethodDecomposition m) throws Exception {
        if (m.getType() == 2 && m.getMethod() != null) {
            return this.visualizeHTNPlan(m.getMethod());
        }
        LinkedList<BufferedImage> images = new LinkedList<BufferedImage>();
        String m_name = "-";
        if (m.getTerm() != null) {
            m_name = m.getTerm().toString();
        }
        int textWidth = this.fm.stringWidth(m_name);
        int childrenWidth = 0;
        int childrenHeight = 0;
        if (DEBUG >= 1) {
            System.out.println("visualizeHTNPlan: " + m_name);
        }
        LinkedList<MethodDecomposition> stack = new LinkedList<MethodDecomposition>();
        stack.add(m);
        while (!stack.isEmpty()) {
            MethodDecomposition md = (MethodDecomposition)stack.remove(0);
            switch (md.getType()) {
                case 1: {
                    BufferedImage img2 = this.visualizeHTNOperator(md.getTerm());
                    images.add(img2);
                    childrenWidth += img2.getWidth();
                    childrenHeight = Math.max(childrenHeight, img2.getHeight());
                    break;
                }
                case 2: {
                    BufferedImage img2;
                    if (md.getMethod() != null) {
                        img2 = this.visualizeHTNPlan(md.getMethod());
                        images.add(img2);
                        childrenWidth += img2.getWidth();
                        childrenHeight = Math.max(childrenHeight, img2.getHeight());
                        break;
                    }
                    if (md == m) break;
                    img2 = this.visualizeHTNPlan(md);
                    images.add(img2);
                    childrenWidth += img2.getWidth();
                    childrenHeight = Math.max(childrenHeight, img2.getHeight());
                    break;
                }
                case 3: {
                    stack.addAll(Arrays.asList(md.getSubparts()));
                    break;
                }
                case 4: {
                    stack.addAll(Arrays.asList(md.getSubparts()));
                    break;
                }
            }
        }
        int width = Math.max(textWidth + 2 * this.hpadding, childrenWidth += images.size() * this.hMethodPadding);
        BufferedImage img = new BufferedImage(width, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding + childrenHeight, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(this.font);
        if (DEBUG >= 1) {
            System.out.println("  visualizeHTNMethod img: " + img.getWidth() + " x " + img.getHeight());
        }
        int x = 0;
        for (BufferedImage img2 : images) {
            g2d.setColor(Color.BLACK);
            g2d.drawLine(width / 2, this.fm.getHeight() + this.vpadding * 2, x + img2.getWidth() / 2, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding);
            g2d.drawImage((Image)img2, x, this.fm.getHeight() + this.vpadding * 2 + this.vMethodPadding, null);
            x += img2.getWidth() + this.hMethodPadding;
        }
        g2d.setColor(Color.GRAY);
        g2d.fillRect(width / 2 - (textWidth + 2 * this.hpadding) / 2, 0, textWidth + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        g2d.setColor(Color.BLACK);
        g2d.drawString(m_name, width / 2 - (textWidth + 2 * this.hpadding) / 2 + this.hpadding, this.vpadding + this.fm.getHeight());
        return img;
    }
}

