/*
 * Decompiled with CFR 0.152.
 */
package ai.ahtn.visualization;

import ai.ahtn.domain.DomainDefinition;
import ai.ahtn.domain.HTNMethod;
import ai.ahtn.domain.MethodDecomposition;
import ai.ahtn.domain.Symbol;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;

public class HTNDomainVisualizerVertical {
    int hpadding = 8;
    int vpadding = 4;
    int hMethodPadding = 32;
    int vMethodPadding = 8;
    Font font = new Font("Arial", 0, 16);
    FontMetrics fm;

    public static void main(String[] args) throws Exception {
        DomainDefinition dd = DomainDefinition.fromLispFile("ahtn/microrts-ahtn-definition-lowest-level.lisp");
        HTNDomainVisualizerVertical v = new HTNDomainVisualizerVertical();
        BufferedImage img = v.visualizeHTNDomain(dd, new Symbol("destroy-player"));
        ImageIO.write((RenderedImage)img, "png", new File("HTN-domain-lowest-level.png"));
        dd = DomainDefinition.fromLispFile("ahtn/microrts-ahtn-definition-low-level.lisp");
        v = new HTNDomainVisualizerVertical();
        img = v.visualizeHTNDomain(dd, new Symbol("destroy-player"));
        ImageIO.write((RenderedImage)img, "png", new File("HTN-domain-low-level.png"));
        dd = DomainDefinition.fromLispFile("ahtn/microrts-ahtn-definition-portfolio.lisp");
        v = new HTNDomainVisualizerVertical();
        img = v.visualizeHTNDomain(dd, new Symbol("destroy-player"));
        ImageIO.write((RenderedImage)img, "png", new File("HTN-domain-portfolio.png"));
        dd = DomainDefinition.fromLispFile("ahtn/microrts-ahtn-definition-flexible-portfolio.lisp");
        v = new HTNDomainVisualizerVertical();
        img = v.visualizeHTNDomain(dd, new Symbol("destroy-player"));
        ImageIO.write((RenderedImage)img, "png", new File("HTN-domain-flexible-portfolio.png"));
        dd = DomainDefinition.fromLispFile("ahtn/microrts-ahtn-definition-flexible-single-target-portfolio.lisp");
        v = new HTNDomainVisualizerVertical();
        img = v.visualizeHTNDomain(dd, new Symbol("destroy-player"));
        ImageIO.write((RenderedImage)img, "png", new File("HTN-domain-flexible-single-target-portfolio.png"));
    }

    public HTNDomainVisualizerVertical() {
        Canvas c = new Canvas();
        this.fm = c.getFontMetrics(this.font);
    }

    public BufferedImage visualizeHTNDomain(DomainDefinition d, Symbol root) throws Exception {
        LinkedList<Symbol> alreadyProcessed = new LinkedList<Symbol>();
        return this.visualizeHTNTask(d, root, alreadyProcessed);
    }

    public BufferedImage visualizeHTNOperator(Symbol root) throws Exception {
        int textWidth = this.fm.stringWidth(root.get());
        BufferedImage img = new BufferedImage(this.hpadding * 2 + textWidth, this.vpadding * 2 + this.fm.getHeight(), 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(this.font);
        g2d.setColor(new Color(0, 127, 0));
        g2d.fillRect(0, 0, img.getWidth(), img.getHeight());
        g2d.setColor(Color.WHITE);
        g2d.drawString(root.get(), this.hpadding, this.vpadding + this.fm.getHeight() - 2);
        return img;
    }

    public BufferedImage visualizeHTNTask(DomainDefinition d, Symbol root, List<Symbol> alreadyProcessed) throws Exception {
        if (alreadyProcessed.contains(root)) {
            System.out.println("visualizeHTNTask (already processed): " + root);
            int textWidth = this.fm.stringWidth(root.get());
            BufferedImage img = new BufferedImage(this.hpadding * 2 + textWidth, this.vpadding * 2 + this.fm.getHeight(), 2);
            Graphics2D g2d = img.createGraphics();
            g2d.setFont(this.font);
            g2d.setColor(Color.RED);
            g2d.fillRect(0, 0, img.getWidth(), img.getHeight());
            g2d.setColor(Color.WHITE);
            g2d.drawString(root.get(), this.hpadding, this.vpadding + this.fm.getHeight() - 2);
            return img;
        }
        System.out.println("visualizeHTNTask: " + root);
        alreadyProcessed.add(root);
        List<HTNMethod> methods = d.getMethodsForGoal(new Symbol(root));
        int textWidth = this.fm.stringWidth(root.get());
        int methodWidth = 0;
        int methodHeight = 0;
        LinkedList<BufferedImage> images = new LinkedList<BufferedImage>();
        for (HTNMethod m : methods) {
            BufferedImage img2 = this.visualizeHTNMethod(d, m, alreadyProcessed);
            images.add(img2);
            methodWidth = Math.max(methodWidth, img2.getWidth());
            methodHeight += img2.getHeight();
        }
        int width = textWidth + 2 * this.hpadding + this.hMethodPadding + methodWidth;
        int height = Math.max(this.fm.getHeight() + 2 * this.vpadding, methodHeight += (methods.size() - 1) * this.vMethodPadding);
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(this.font);
        System.out.println("  visualizeHTNTask img: " + img.getWidth() + " x " + img.getHeight() + " (methodHeight: " + methodHeight + ")");
        int y = 0;
        for (BufferedImage img2 : images) {
            g2d.setColor(Color.BLACK);
            g2d.drawLine(textWidth + 2 * this.hpadding, height / 2, textWidth + 2 * this.hpadding + this.hMethodPadding, y + img2.getHeight() / 2);
            System.out.println("  drawing image at: " + (textWidth + 2 * this.hpadding + this.hMethodPadding) + ", " + y);
            g2d.drawImage((Image)img2, textWidth + 2 * this.hpadding + this.hMethodPadding, y, null);
            y += img2.getHeight() + this.vMethodPadding;
        }
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, height / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2, textWidth + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        g2d.setColor(Color.WHITE);
        g2d.drawString(root.get(), this.hpadding, height / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2 + this.fm.getHeight() + this.vpadding - 2);
        return img;
    }

    public BufferedImage visualizeHTNMethod(DomainDefinition d, HTNMethod m, List<Symbol> alreadyProcessed) throws Exception {
        LinkedList<Symbol> children = new LinkedList<Symbol>();
        LinkedList<BufferedImage> images = new LinkedList<BufferedImage>();
        System.out.println("visualizeHTNMethod: " + m.getName());
        LinkedList<MethodDecomposition> stack = new LinkedList<MethodDecomposition>();
        stack.add(m.getDecomposition());
        while (!stack.isEmpty()) {
            MethodDecomposition md = (MethodDecomposition)stack.remove(0);
            switch (md.getType()) {
                case 1: {
                    children.add(md.getTerm().getFunctor());
                    break;
                }
                case 2: {
                    children.add(md.getTerm().getFunctor());
                    break;
                }
                case 3: {
                    stack.addAll(Arrays.asList(md.getSubparts()));
                    break;
                }
                case 4: {
                    stack.addAll(Arrays.asList(md.getSubparts()));
                    break;
                }
            }
        }
        int textWidth = this.fm.stringWidth(m.getName());
        int childrenWidth = 0;
        int childrenHeight = 0;
        for (Symbol c : children) {
            BufferedImage img2;
            if (c.get().startsWith("!")) {
                img2 = this.visualizeHTNOperator(c);
                images.add(img2);
                childrenWidth = Math.max(childrenWidth, img2.getWidth());
                childrenHeight += img2.getHeight();
                continue;
            }
            img2 = this.visualizeHTNTask(d, c, alreadyProcessed);
            images.add(img2);
            childrenWidth = Math.max(childrenWidth, img2.getWidth());
            childrenHeight += img2.getHeight();
        }
        int width = textWidth + 2 * this.hpadding + this.hMethodPadding + childrenWidth;
        int height = Math.max(this.fm.getHeight() + 2 * this.vpadding, childrenHeight += (children.size() - 1) * this.vMethodPadding);
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(this.font);
        System.out.println("  visualizeHTNMethod img: " + img.getWidth() + " x " + img.getHeight());
        int y = 0;
        for (BufferedImage img2 : images) {
            g2d.setColor(Color.BLACK);
            g2d.drawLine(textWidth + 2 * this.hpadding, height / 2, textWidth + 2 * this.hpadding + this.hMethodPadding, y + img2.getHeight() / 2);
            g2d.drawImage((Image)img2, textWidth + 2 * this.hpadding + this.hMethodPadding, y, null);
            y += img2.getHeight() + this.vMethodPadding;
        }
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fillRect(0, height / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2, textWidth + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        g2d.setColor(Color.BLACK);
        g2d.drawString(m.getName(), this.hpadding, height / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2 + this.fm.getHeight() + this.vpadding - 2);
        return img;
    }

    public BufferedImage visualizeHTNPlan(HTNMethod m) throws Exception {
        LinkedList<BufferedImage> images = new LinkedList<BufferedImage>();
        String m_name = m.getName();
        int textWidth = this.fm.stringWidth(m_name);
        int childrenWidth = 0;
        int childrenHeight = 0;
        System.out.println("visualizeHTNPlan: " + m_name);
        LinkedList<MethodDecomposition> stack = new LinkedList<MethodDecomposition>();
        stack.add(m.getDecomposition());
        while (!stack.isEmpty()) {
            MethodDecomposition md = (MethodDecomposition)stack.remove(0);
            switch (md.getType()) {
                case 1: {
                    BufferedImage img2 = this.visualizeHTNOperator(md.getTerm().getFunctor());
                    images.add(img2);
                    childrenWidth = Math.max(childrenWidth, img2.getWidth());
                    childrenHeight += img2.getHeight();
                    break;
                }
                case 2: {
                    if (md.getMethod() == null) break;
                    BufferedImage img2 = this.visualizeHTNPlan(md.getMethod());
                    images.add(img2);
                    childrenWidth = Math.max(childrenWidth, img2.getWidth());
                    childrenHeight += img2.getHeight();
                    break;
                }
                case 3: {
                    stack.addAll(Arrays.asList(md.getSubparts()));
                    break;
                }
                case 4: {
                    stack.addAll(Arrays.asList(md.getSubparts()));
                    break;
                }
            }
        }
        int width = textWidth + 2 * this.hpadding + this.hMethodPadding + childrenWidth;
        int height = Math.max(this.fm.getHeight() + 2 * this.vpadding, childrenHeight += (images.size() - 1) * this.vMethodPadding);
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(this.font);
        System.out.println("  visualizeHTNPlan img: " + img.getWidth() + " x " + img.getHeight());
        int y = 0;
        for (BufferedImage img2 : images) {
            g2d.setColor(Color.BLACK);
            g2d.drawLine(textWidth + 2 * this.hpadding, height / 2, textWidth + 2 * this.hpadding + this.hMethodPadding, y + img2.getHeight() / 2);
            g2d.drawImage((Image)img2, textWidth + 2 * this.hpadding + this.hMethodPadding, y, null);
            y += img2.getHeight() + this.vMethodPadding;
        }
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fillRect(0, height / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2, textWidth + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        g2d.setColor(Color.BLACK);
        g2d.drawString(m_name, this.hpadding, height / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2 + this.fm.getHeight() + this.vpadding - 2);
        return img;
    }

    public BufferedImage visualizeHTNPlan(MethodDecomposition m) throws Exception {
        LinkedList<BufferedImage> images = new LinkedList<BufferedImage>();
        String m_name = "-";
        if (m.getTerm() != null) {
            m_name = m.getTerm().toString();
        }
        int textWidth = this.fm.stringWidth(m_name);
        int childrenWidth = 0;
        int childrenHeight = 0;
        System.out.println("visualizeHTNPlan: " + m_name);
        LinkedList<MethodDecomposition> stack = new LinkedList<MethodDecomposition>();
        stack.add(m);
        while (!stack.isEmpty()) {
            MethodDecomposition md = (MethodDecomposition)stack.remove(0);
            switch (md.getType()) {
                case 1: {
                    BufferedImage img2 = this.visualizeHTNOperator(md.getTerm().getFunctor());
                    images.add(img2);
                    childrenWidth = Math.max(childrenWidth, img2.getWidth());
                    childrenHeight += img2.getHeight();
                    break;
                }
                case 2: {
                    if (md.getMethod() == null) break;
                    BufferedImage img2 = this.visualizeHTNPlan(md.getMethod());
                    images.add(img2);
                    childrenWidth = Math.max(childrenWidth, img2.getWidth());
                    childrenHeight += img2.getHeight();
                    break;
                }
                case 3: {
                    stack.addAll(Arrays.asList(md.getSubparts()));
                    break;
                }
                case 4: {
                    stack.addAll(Arrays.asList(md.getSubparts()));
                    break;
                }
            }
        }
        int width = textWidth + 2 * this.hpadding + this.hMethodPadding + childrenWidth;
        int height = Math.max(this.fm.getHeight() + 2 * this.vpadding, childrenHeight += (images.size() - 1) * this.vMethodPadding);
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(this.font);
        System.out.println("  visualizeHTNPlan img: " + img.getWidth() + " x " + img.getHeight());
        int y = 0;
        for (BufferedImage img2 : images) {
            g2d.setColor(Color.BLACK);
            g2d.drawLine(textWidth + 2 * this.hpadding, height / 2, textWidth + 2 * this.hpadding + this.hMethodPadding, y + img2.getHeight() / 2);
            g2d.drawImage((Image)img2, textWidth + 2 * this.hpadding + this.hMethodPadding, y, null);
            y += img2.getHeight() + this.vMethodPadding;
        }
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fillRect(0, height / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2, textWidth + 2 * this.hpadding, this.fm.getHeight() + this.vpadding * 2);
        g2d.setColor(Color.BLACK);
        g2d.drawString(m_name, this.hpadding, height / 2 - (this.fm.getHeight() + 2 * this.vpadding) / 2 + this.fm.getHeight() + this.vpadding - 2);
        return img;
    }
}

