/*
 * Decompiled with CFR 0.152.
 */
package ai.coac;

import ai.abstraction.AbstractAction;
import rts.GameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.XMLWriter;

public class AttackPosition
extends AbstractAction {
    private final int targetX;
    private final int targetY;
    Unit unit;

    public AttackPosition(Unit u, int x, int y) {
        super(u);
        this.unit = u;
        this.targetX = x;
        this.targetY = y;
    }

    @Override
    public boolean completed(GameState gs) {
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AttackPosition)) {
            return false;
        }
        AttackPosition a = (AttackPosition)o;
        return this.targetX == a.targetX && this.targetY == a.targetY;
    }

    @Override
    public void toxml(XMLWriter w) {
        w.tagWithAttributes("Attack", "unitID=\"" + this.unit.getID() + "\" target=\"" + this.targetX + this.targetY);
        w.tag("/Attack");
    }

    @Override
    public UnitAction execute(GameState gs, ResourceUsage ru) {
        int dy;
        int dx = this.targetX - this.unit.getX();
        double d = Math.sqrt(dx * dx + (dy = this.targetY - this.unit.getY()) * dy);
        if (d <= (double)this.unit.getAttackRange()) {
            return new UnitAction(5, this.targetX, this.targetY);
        }
        return null;
    }
}

