/*
 * Decompiled with CFR 0.152.
 */
package ai.coac;

import ai.abstraction.AbstractAction;
import ai.abstraction.pathfinding.PathFinding;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import util.XMLWriter;

public class BuildModified
extends AbstractAction {
    UnitType type;
    Unit unit;
    int x;
    int y;
    PathFinding pf;

    public BuildModified(Unit u, UnitType a_type, int a_x, int a_y, PathFinding a_pf) {
        super(u);
        this.unit = u;
        this.type = a_type;
        this.x = a_x;
        this.y = a_y;
        this.pf = a_pf;
    }

    @Override
    public boolean completed(GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        Unit u = pgs.getUnitAt(this.x, this.y);
        return u != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildModified)) {
            return false;
        }
        BuildModified a = (BuildModified)o;
        return this.type == a.type && this.x == a.x && this.y == a.y && this.pf.getClass() == a.pf.getClass();
    }

    @Override
    public void toxml(XMLWriter w) {
        w.tagWithAttributes("Build", "unitID=\"" + this.unit.getID() + "\" type=\"" + this.type.name + "\" x=\"" + this.x + "\" y=\"" + this.y + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\"");
        w.tag("/Build");
    }

    @Override
    public UnitAction execute(GameState gs, ResourceUsage ru) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        UnitAction move = this.pf.findPathToAdjacentPosition(this.unit, this.x + this.y * pgs.getWidth(), gs, ru);
        if (move != null) {
            if (gs.isUnitActionAllowed(this.unit, move)) {
                return move;
            }
            return new UnitAction(0, 1);
        }
        UnitAction ua = null;
        if (this.x == this.unit.getX() && this.y == this.unit.getY() - 1) {
            ua = new UnitAction(4, 0, this.type);
        }
        if (this.x == this.unit.getX() + 1 && this.y == this.unit.getY()) {
            ua = new UnitAction(4, 1, this.type);
        }
        if (this.x == this.unit.getX() && this.y == this.unit.getY() + 1) {
            ua = new UnitAction(4, 2, this.type);
        }
        if (this.x == this.unit.getX() - 1 && this.y == this.unit.getY()) {
            ua = new UnitAction(4, 3, this.type);
        }
        if (ua != null && gs.isUnitActionAllowed(this.unit, ua)) {
            return ua;
        }
        System.err.println("Build.execute: something weird just happened " + this.unit + " builds at " + this.x + "," + this.y);
        return new UnitAction(0, 1);
    }
}

