/*
 * Decompiled with CFR 0.152.
 */
package ai.coac;

import ai.abstraction.AbstractionLayerAIWait1;
import ai.abstraction.pathfinding.AStarPathFinding;
import ai.coac.BuildModified;
import ai.coac.CoacAttack;
import ai.coac.HarvestReturn;
import ai.coac.TrainDirection;
import ai.coac.TrueIdle;
import ai.core.AI;
import ai.core.ParameterSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import rts.GameState;
import rts.PhysicalGameState;
import rts.Player;
import rts.PlayerAction;
import rts.UnitAction;
import rts.UnitActionAssignment;
import rts.units.Unit;
import rts.units.UnitType;
import rts.units.UnitTypeTable;

public class CoacAI
extends AbstractionLayerAIWait1 {
    protected UnitTypeTable utt;
    UnitType workerType;
    UnitType baseType;
    UnitType barracksType;
    UnitType rangedType;
    UnitType heavyType;
    UnitType lightType;
    AStarPathFinding astar;
    Player p;
    Player enemyPlayer;
    List<Unit> resources;
    List<Unit> myClosestResources;
    List<Unit> enemyBases;
    List<Unit> allBases;
    List<Unit> myBases;
    List<Unit> myWorkers;
    List<Unit> myWorkersBusy;
    List<Unit> enemies;
    List<Unit> myUnits;
    List<Unit> aliveEnemies;
    List<Unit> myCombatUnits;
    List<Unit> enemyCombatUnits;
    List<Unit> myCombatUnitsBusy;
    List<Unit> myBarracks;
    List<Unit> enemyBarracks;
    List<Unit> myWorkersCombat;
    String map;
    private GameState gs;
    private PhysicalGameState pgs;
    private int defenseBaseDistance = 2;
    Map<Long, List<Integer>> baseDefensePositions;
    Map<Long, List<Integer>> baseDefensePositionsRanged;
    private Map<Long, Integer> damages;
    private Map<Long, Long> harvesting = new HashMap<Long, Long>();
    private HashMap<Long, Boolean> constructingBarracksForBase;
    private HashMap<Long, Boolean> baseSeparated;
    private boolean debug = false;
    private int resourceUsed;
    private boolean attackAll = false;
    private boolean attackWithCombat = false;
    private int MAXCYCLES;
    private boolean wasSeparated = false;

    public CoacAI(UnitTypeTable a_utt) {
        this(a_utt, new AStarPathFinding());
    }

    public CoacAI(UnitTypeTable a_utt, AStarPathFinding a_pf) {
        super(a_pf);
        this.astar = a_pf;
        this.reset(a_utt);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void reset(UnitTypeTable a_utt) {
        this.utt = a_utt;
        this.workerType = this.utt.getUnitType("Worker");
        this.baseType = this.utt.getUnitType("Base");
        this.barracksType = this.utt.getUnitType("Barracks");
        this.rangedType = this.utt.getUnitType("Ranged");
        this.heavyType = this.utt.getUnitType("Heavy");
        this.lightType = this.utt.getUnitType("Light");
    }

    @Override
    public AI clone() {
        return new CoacAI(this.utt, this.astar);
    }

    private void init() {
        if (this.pgs.getWidth() <= 8) {
            this.defenseBaseDistance = 2;
        } else if (this.pgs.getWidth() <= 16) {
            this.defenseBaseDistance = 3;
        } else if (this.pgs.getWidth() <= 24) {
            this.defenseBaseDistance = 4;
        } else if (this.pgs.getWidth() <= 32) {
            this.defenseBaseDistance = 5;
        } else if (this.pgs.getWidth() <= 64) {
            this.defenseBaseDistance = 7;
        }
        this.MAXCYCLES = 12000;
        if (this.pgs.getWidth() <= 8) {
            this.MAXCYCLES = 3000;
        } else if (this.pgs.getWidth() <= 16) {
            this.MAXCYCLES = 4000;
        } else if (this.pgs.getWidth() <= 24) {
            this.MAXCYCLES = 5000;
        } else if (this.pgs.getWidth() <= 32) {
            this.MAXCYCLES = 6000;
        } else if (this.pgs.getWidth() <= 64) {
            this.MAXCYCLES = 8000;
        }
        this.resourceUsed = 0;
        this.myWorkersCombat = new ArrayList<Unit>();
        this.resources = new ArrayList<Unit>();
        this.allBases = new ArrayList<Unit>();
        this.enemyBases = new ArrayList<Unit>();
        this.myBases = new ArrayList<Unit>();
        this.myWorkers = new ArrayList<Unit>();
        this.myWorkersBusy = new ArrayList<Unit>();
        this.enemyCombatUnits = new ArrayList<Unit>();
        this.myCombatUnits = new ArrayList<Unit>();
        this.myCombatUnitsBusy = new ArrayList<Unit>();
        this.myBarracks = new ArrayList<Unit>();
        this.enemyBarracks = new ArrayList<Unit>();
        this.enemies = new ArrayList<Unit>();
        this.myUnits = new ArrayList<Unit>();
        this.aliveEnemies = new ArrayList<Unit>();
        for (Unit unit : this.pgs.getUnits()) {
            if (unit.getType().isResource) {
                this.resources.add(unit);
            } else if (unit.getType().isStockpile) {
                if (this.isEnemyUnit(unit)) {
                    this.enemyBases.add(unit);
                } else {
                    this.myBases.add(unit);
                }
                this.allBases.add(unit);
            } else if (unit.getType().canHarvest && this.isAllyUnit(unit)) {
                if (this.gs.getActionAssignment(unit) == null) {
                    this.myWorkers.add(unit);
                } else {
                    this.myWorkersBusy.add(unit);
                }
            } else if (!unit.getType().canHarvest && unit.getType().canAttack) {
                if (this.isAllyUnit(unit)) {
                    if (this.gs.getActionAssignment(unit) == null) {
                        this.myCombatUnits.add(unit);
                    } else {
                        this.myCombatUnitsBusy.add(unit);
                    }
                } else {
                    this.enemyCombatUnits.add(unit);
                }
            } else if (unit.getType().equals(this.barracksType)) {
                if (this.isAllyUnit(unit)) {
                    this.myBarracks.add(unit);
                } else {
                    this.enemyBarracks.add(unit);
                }
            }
            if (this.isEnemyUnit(unit)) {
                this.enemies.add(unit);
                this.aliveEnemies.add(unit);
                continue;
            }
            this.myUnits.add(unit);
        }
        this.myClosestResources = new ArrayList<Unit>();
        for (Unit unit : this.resources) {
            Unit base = this.closestUnit(unit, this.allBases);
            if (base == null || !this.isAllyUnit(base)) continue;
            this.myClosestResources.add(unit);
        }
        this.baseDefensePositions = new HashMap<Long, List<Integer>>();
        this.baseDefensePositionsRanged = new HashMap<Long, List<Integer>>();
        for (Unit unit : this.myBases) {
            this.baseDefensePositions.put(unit.getID(), this.getDefensePositions(unit, this.defenseBaseDistance));
            this.baseDefensePositionsRanged.put(unit.getID(), this.getDefensePositions(unit, this.defenseBaseDistance - 1));
        }
        this.damages = new HashMap<Long, Integer>();
        LinkedList<Unit> myUnitsBusy = new LinkedList<Unit>();
        myUnitsBusy.addAll(this.myCombatUnitsBusy);
        myUnitsBusy.addAll(this.myWorkersBusy);
        for (Unit unit : myUnitsBusy) {
            UnitAction action = this.gs.getUnitAction(unit);
            this.printDebug(unit + " is doing " + action);
            if (action == null || action.getType() != 5) continue;
            Unit enemy = this.pgs.getUnitAt(action.getLocationX(), action.getLocationY());
            if (enemy == null) {
                if (!this.debug) continue;
                throw new RuntimeException("Problem: we attack only sure hit enemy but " + unit + " attacking empty cell " + action);
            }
            this.registerAttackDamage(unit, enemy);
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        LinkedList<Unit> myWorkersBusyAndFree = new LinkedList<Unit>();
        myWorkersBusyAndFree.addAll(this.myWorkers);
        myWorkersBusyAndFree.addAll(this.myWorkersBusy);
        for (Map.Entry<Long, Long> entry : this.harvesting.entrySet()) {
            long harvesterID = entry.getKey();
            Optional<Unit> worker = myWorkersBusyAndFree.stream().filter(u -> u.getID() == harvesterID).findAny();
            if (!worker.isPresent()) {
                arrayList.add(harvesterID);
                continue;
            }
            long baseID = entry.getValue();
            Optional<Unit> base = this.myBases.stream().filter(u -> u.getID() == baseID).findAny();
            if (base.isPresent()) continue;
            arrayList.add(harvesterID);
        }
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            long id = (Long)((Object)iterator.next());
            this.harvesting.remove(id);
        }
        this.constructingBarracksForBase = new HashMap();
        for (Unit worker : this.myWorkersBusy) {
            Unit base;
            UnitAction action = this.gs.getUnitAction(worker);
            if (action.getType() != 4 || action.getUnitType() != this.barracksType || (base = this.closestUnit(worker, this.myBases)) == null) continue;
            this.constructingBarracksForBase.put(base.getID(), true);
        }
        this.baseSeparated = new HashMap();
        for (Unit base : this.myBases) {
            this.baseSeparated.put(base.getID(), this.isBaseSeparated(base));
        }
    }

    private List<Integer> getDefensePositions(Unit base, int defenseBaseDistance) {
        ArrayList<Integer> defensePositions = new ArrayList<Integer>();
        for (int x = 0; x < this.pgs.getWidth(); ++x) {
            for (int y = 0; y < this.pgs.getHeight(); ++y) {
                if (CoacAI.distanceChebyshev(base, x, y) != defenseBaseDistance || this.isThereResourceAdjacent(x, y, 1)) continue;
                int pos = this.pgsPos(x, y);
                defensePositions.add(pos);
            }
        }
        return defensePositions;
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) {
        long start_time = System.currentTimeMillis();
        this.gs = gs;
        this.pgs = gs.getPhysicalGameState();
        this.p = gs.getPlayer(player);
        this.enemyPlayer = gs.getPlayer(player == 0 ? 1 : 0);
        if (this.myWorkersCombat == null) {
            int hash = this.pgs.toString().hashCode();
            this.printDebug("Map hash: " + hash);
            this.map = hash == 1835166811 ? "maps/16x16/basesWorkers16x16A.xml" : "";
        }
        this.init();
        if (this.p.getResources() == 0 && this.resources.size() == 0) {
            this.attackAll = true;
            this.attackWithCombat = true;
        }
        int enemyCombatScore = this.enemyCombatUnits.stream().mapToInt(Unit::getCost).sum();
        int myCombatScore = this.myCombatUnits.stream().mapToInt(Unit::getCost).sum() + this.myCombatUnitsBusy.stream().mapToInt(Unit::getCost).sum();
        this.attackWithCombat = myCombatScore - 4 > enemyCombatScore;
        this.computeWorkersAction();
        if (this.map.equals("maps/16x16/basesWorkers16x16A.xml")) {
            this.computeBarracksActionBasesWorkers16x16A();
        } else {
            this.computeBarracksAction();
        }
        this.computeBasesAction();
        this.computeCombatUnitsAction();
        this.printDebug("attackWithCombat " + this.attackWithCombat + " resources:" + this.p.getResources());
        long elapsedTime = System.currentTimeMillis() - start_time;
        this.printDebug(elapsedTime + "ms");
        if (this.TIME_BUDGET > 0 && elapsedTime >= (long)this.TIME_BUDGET) {
            this.printDebug("TIMEOUT");
        }
        PlayerAction pa = this.translateActions(player, gs);
        this.printDebug("actions: " + pa);
        return pa;
    }

    private boolean isBaseSeparated(Unit base) {
        if (this.pgs.getWidth() >= 10) {
            return false;
        }
        LinkedList<Position> stack = new LinkedList<Position>();
        LinkedList<Position> visited = new LinkedList<Position>();
        stack.add(new Position(base.getX(), base.getY()));
        int visitedPos = 0;
        while (!stack.isEmpty()) {
            ++visitedPos;
            Position pos = (Position)stack.remove(0);
            Unit unit = this.pgs.getUnitAt(pos.getX(), pos.getY());
            if (unit != null && this.isEnemyUnit(unit)) {
                return false;
            }
            List validAdjacentPos = pos.adjacentPos().stream().filter(this::isValidPos).filter(p -> !visited.contains(p)).filter(p -> !stack.contains(p)).filter(p -> {
                if (this.pgs.getTerrain(pos.getX(), pos.getY()) == 1) {
                    return false;
                }
                Unit unitAtPos = this.pgs.getUnitAt(pos.getX(), pos.getY());
                if (unitAtPos == null) {
                    return true;
                }
                return !unitAtPos.getType().isResource;
            }).collect(Collectors.toList());
            stack.addAll(validAdjacentPos);
            visited.add(pos);
        }
        this.printDebug("visited " + visitedPos);
        this.wasSeparated = true;
        return true;
    }

    private void computeBarracksAction() {
        long heavyCount = this.myCombatUnits.stream().filter(u -> u.getType() == this.heavyType).count() + this.myCombatUnitsBusy.stream().filter(u -> u.getType() == this.heavyType).count();
        for (Unit barrack : this.myBarracks) {
            if (heavyCount > 3L) {
                this.train(barrack, this.rangedType);
                continue;
            }
            if (this.wasSeparated) {
                this.train(barrack, this.rangedType);
                continue;
            }
            this.train(barrack, this.heavyType);
        }
    }

    private void computeBarracksActionBasesWorkers16x16A() {
        long heavyCount = this.myCombatUnits.stream().filter(u -> u.getType() == this.heavyType).count() + this.myCombatUnitsBusy.stream().filter(u -> u.getType() == this.heavyType).count();
        for (Unit barrack : this.myBarracks) {
            if (heavyCount > 0L) {
                this.train(barrack, this.rangedType);
                continue;
            }
            if (this.wasSeparated) {
                this.train(barrack, this.rangedType);
                continue;
            }
            this.train(barrack, this.heavyType);
        }
    }

    private void computeCombatAction(Unit unit) {
        List<Unit> aliveEnemies = this.aliveEnemies;
        if (aliveEnemies.isEmpty()) {
            this.printDebug(unit + " no enemies, idling");
            this.actions.put(unit, new TrueIdle(unit));
            return;
        }
        List<Unit> enemiesInRange = aliveEnemies.stream().filter(e -> CoacAI.enemyIsInRangeAttack(unit, e)).collect(Collectors.toList());
        List<Unit> attackableEnemies = enemiesInRange.stream().filter(e -> !this.willBeMoveBeforeAttack(unit, (Unit)e)).collect(Collectors.toList());
        if (!attackableEnemies.isEmpty()) {
            Unit closestEnemy = this.bestToAttack(unit, attackableEnemies);
            this.printDebug(unit + " attacking " + closestEnemy + " damageBeforeAttack:" + this.damages.getOrDefault(closestEnemy.getID(), 0) + " enemyAction:" + this.gs.getActionAssignment(closestEnemy));
            this.attackAndRegisterDamage(unit, closestEnemy);
            return;
        }
        if (!enemiesInRange.isEmpty()) {
            if (unit.getAttackRange() > 1) {
                Unit movingEnemy = this.closestUnitAfterMoveAction(unit, enemiesInRange);
                if (CoacAI.squareDist(unit, CoacAI.nextPos(movingEnemy, this.gs)) > (double)movingEnemy.getAttackRange()) {
                    this.printDebug("ranged flee safe");
                    this.moveAwayFrom(unit, movingEnemy);
                    return;
                }
                if (this.gs.getActionAssignment((Unit)movingEnemy).time - this.gs.getTime() + movingEnemy.getAttackTime() >= unit.getMoveTime()) {
                    this.printDebug("ranged flee adjacent");
                    this.moveAwayFrom(unit, movingEnemy);
                }
            }
            this.printDebug(unit + " wait for moving unit");
            this.actions.put(unit, new TrueIdle(unit));
            return;
        }
        Unit closestEnemy = this.closestUnitAfterMoveAction(unit, aliveEnemies);
        if (this.attackWithCombat || this.distance(unit, closestEnemy) <= 5) {
            this.printDebug(unit + " chasing <=5 " + closestEnemy);
            this.chaseToAttack(unit, closestEnemy);
            return;
        }
        ArrayList<Unit> myUnits = new ArrayList<Unit>();
        myUnits.addAll(this.myCombatUnits);
        myUnits.addAll(this.myCombatUnitsBusy);
        myUnits.addAll(this.myWorkersCombat);
        if (myUnits.isEmpty()) {
            if (this.gs.getTime() > this.MAXCYCLES / 2) {
                this.printDebug(unit + " chasing " + closestEnemy);
                this.chaseToAttack(unit, closestEnemy);
                return;
            }
            this.printDebug(unit + " waiting for more unit ");
            this.actions.put(unit, new TrueIdle(unit));
            return;
        }
        Position centroid = CoacAI.centroid(myUnits);
        if (this.gs.getTime() > this.MAXCYCLES / 2 || CoacAI.distance(unit, centroid) <= 3) {
            this.printDebug(unit + " chasing " + closestEnemy);
            this.chaseToAttack(unit, closestEnemy);
        } else {
            this.printDebug(unit + " moving to centroid " + centroid);
            this.move(unit, centroid.getX(), centroid.getY());
        }
    }

    private void moveAwayFrom(Unit unit, Unit movingEnemy) {
        Position newPos;
        Position enemyPos = CoacAI.nextPos(movingEnemy, this.gs);
        int currentDist = CoacAI.distance(unit, enemyPos);
        Position posUp = new Position(unit.getX(), unit.getY() - 1);
        Position posRight = new Position(unit.getX() + 1, unit.getY());
        Position posLeft = new Position(unit.getX() - 1, unit.getY());
        Position posDown = new Position(unit.getX(), unit.getY() + 1);
        if (this.isValidPos(posUp) && this.isFreePos(posUp) && CoacAI.distance(enemyPos, posUp) > currentDist) {
            newPos = posUp;
        } else if (this.isValidPos(posDown) && this.isFreePos(posDown) && CoacAI.distance(enemyPos, posDown) > currentDist) {
            newPos = posDown;
        } else if (this.isValidPos(posRight) && this.isFreePos(posRight) && CoacAI.distance(enemyPos, posRight) > currentDist) {
            newPos = posRight;
        } else if (this.isValidPos(posLeft) && this.isFreePos(posLeft) && CoacAI.distance(enemyPos, posLeft) > currentDist) {
            newPos = posLeft;
        } else {
            this.printDebug(unit + " cant flee, blocked, waiting");
            this.actions.put(unit, new TrueIdle(unit));
            return;
        }
        if (enemyPos.x == unit.getX()) {
            if (this.isValidPos(posUp) && this.isFreePos(posUp) && CoacAI.distance(enemyPos, posUp) > currentDist) {
                newPos = posUp;
            } else if (this.isValidPos(posDown) && this.isFreePos(posDown) && CoacAI.distance(enemyPos, posDown) > currentDist) {
                newPos = posDown;
            }
        } else if (enemyPos.y == unit.getY()) {
            if (this.isValidPos(posRight) && this.isFreePos(posRight) && CoacAI.distance(enemyPos, posRight) > currentDist) {
                newPos = posRight;
            } else if (this.isValidPos(posLeft) && this.isFreePos(posLeft) && CoacAI.distance(enemyPos, posLeft) > currentDist) {
                newPos = posLeft;
            }
        }
        this.printDebug(unit + " fleeing away from " + movingEnemy + " going to " + newPos);
        this.move(unit, newPos.x, newPos.y);
    }

    private int sumDistanceFromEnemy(Position pos) {
        return this.aliveEnemies.stream().mapToInt(e -> CoacAI.distance(pos, CoacAI.nextPos(e, this.gs))).sum();
    }

    private void computeCombatUnitsAction() {
        for (Unit unit : this.myCombatUnits) {
            this.computeCombatAction(unit);
        }
    }

    private void computeBasesAction() {
        for (Unit base : this.myBases) {
            if (this.baseSeparated.getOrDefault(base.getID(), false).booleanValue() || this.pgs.getWidth() > 8) continue;
            this.train(base, this.workerType);
        }
        int workerPerBase = 2;
        int producingWorker = 0;
        long producingCount = this.myBases.stream().filter(b -> this.gs.getActionAssignment((Unit)b) != null).count();
        for (Unit base : this.myBases) {
            if ((long)(this.myWorkers.size() + this.myWorkersBusy.size() + producingWorker) + producingCount >= (long)(2 * this.myBases.size()) && this.p.getResources() - this.resourceUsed < 15) {
                return;
            }
            this.train(base, this.workerType);
            ++producingWorker;
        }
    }

    private void computeWorkersAction() {
        if (this.attackAll) {
            for (Unit worker : this.myWorkers) {
                this.computeCombatAction(worker);
            }
            return;
        }
        this.buildBarracks();
        if (!(this.myWorkers.isEmpty() || this.myBases.isEmpty() || this.resources.isEmpty())) {
            for (int i = 0; i < this.myBases.size(); ++i) {
                Optional<Unit> optionalUnit = this.myWorkers.stream().filter(w -> !this.harvesting.containsKey(w.getID())).min(Comparator.comparingInt(this::harvestScore));
                Unit harvesterWorker = null;
                if (optionalUnit.isPresent()) {
                    harvesterWorker = optionalUnit.get();
                }
                if (harvesterWorker == null || this.harvestScore(harvesterWorker) == Integer.MAX_VALUE) break;
                this.harvestClosest(harvesterWorker);
            }
        }
        for (Unit worker : this.myWorkers) {
            boolean isHarvester = this.harvesting.containsKey(worker.getID());
            Unit closestEnemy = this.closestUnit(worker, this.aliveEnemies);
            if (isHarvester) {
                if (closestEnemy != null && this.distance(closestEnemy, worker) <= 2) {
                    this.harvesting.remove(worker.getID());
                    this.myWorkersCombat.add(worker);
                    this.computeCombatAction(worker);
                    continue;
                }
                long baseID = this.harvesting.get(worker.getID());
                Unit assignedBase = this.gs.getUnit(baseID);
                Unit closestResource = this.closestUnit(worker, this.resources);
                this.printDebug(worker + " new assigned harvest " + closestResource);
                this.actions.put(worker, new HarvestReturn(worker, closestResource, assignedBase, this.pf));
                continue;
            }
            this.myWorkersCombat.add(worker);
            this.computeCombatAction(worker);
        }
    }

    private void buildBarracks() {
        if (this.myBarracks.size() == 0 && this.p.getResources() - this.resourceUsed >= this.barracksType.cost + 1) {
            for (Unit base : this.myBases) {
                if (this.constructingBarracksForBase.containsKey(base.getID())) continue;
                boolean safeDistanceToBuild = true;
                if (!this.baseSeparated.getOrDefault(base.getID(), false).booleanValue()) {
                    Unit enemy = this.closestUnit(base, this.aliveEnemies);
                    if (enemy != null) {
                        boolean bl = safeDistanceToBuild = this.distance(enemy, base) * this.workerType.moveTime > this.barracksType.produceTime;
                    }
                    if (this.p.getResources() > 10 && this.p.getResources() >= this.enemyPlayer.getResources()) {
                        safeDistanceToBuild = true;
                    }
                }
                if (!safeDistanceToBuild) continue;
                Unit closestWorker = this.closestUnit(base, this.myWorkers);
                if (closestWorker == null) break;
                Unit enemy = this.closestUnit(closestWorker, this.aliveEnemies);
                if (enemy != null && this.distance(closestWorker, enemy) <= 2 || this.distance(closestWorker, base) > 2) continue;
                Position workerPos = new Position(closestWorker.getX(), closestWorker.getY());
                List<Position> adjacentPos = workerPos.adjacentPos();
                Position bestPos = null;
                int closestDist = this.wasSeparated ? 9999999 : 0;
                for (Position pos : adjacentPos) {
                    if (!this.isValidPos(pos) || this.isThereResourceAdjacent(pos.getX(), pos.getY(), 1) || this.pgs.getUnitAt(pos.x, pos.y) != null) continue;
                    if (enemy == null) break;
                    int dist = CoacAI.distance(enemy, pos);
                    if ((!this.wasSeparated || dist >= closestDist) && (this.wasSeparated || dist <= closestDist)) continue;
                    bestPos = pos;
                    closestDist = dist;
                }
                if (bestPos == null) continue;
                this.actions.put(closestWorker, new BuildModified(closestWorker, this.barracksType, bestPos.x, bestPos.y, this.pf));
                this.printDebug(closestWorker + " BUILDING at " + bestPos);
                this.myWorkers.remove(closestWorker);
                this.myWorkersBusy.add(closestWorker);
                this.resourceUsed += this.barracksType.cost;
            }
        }
    }

    private void printDebug(String string) {
        if (!this.debug) {
            return;
        }
        System.out.println(string);
    }

    private boolean isThereResourceAdjacent(int x, int y, int distance) {
        Collection<Unit> unitsAround = this.pgs.getUnitsAround(x, y, distance, distance);
        Optional<Unit> resource = unitsAround.stream().filter(unit -> unit.getType().isResource).findAny();
        return resource.isPresent();
    }

    private boolean isThereBaseAdjacent(int x, int y, int distance) {
        Collection<Unit> unitsAround = this.pgs.getUnitsAround(x, y, distance, distance);
        Optional<Unit> resource = unitsAround.stream().filter(unit -> unit.getType().isStockpile).findAny();
        return resource.isPresent();
    }

    private void chaseToAttack(Unit worker, Unit closestEnemy) {
        this.attackAndRegisterDamage(worker, closestEnemy);
    }

    private void attackAndRegisterDamage(Unit worker, Unit closestEnemy) {
        if (CoacAI.enemyIsInRangeAttack(worker, closestEnemy)) {
            this.registerAttackDamage(worker, closestEnemy);
        }
        this.actions.put(worker, new CoacAttack(worker, closestEnemy, this.pf));
    }

    private void registerAttackDamage(Unit worker, Unit closestEnemy) {
        int damage = (worker.getMinDamage() + worker.getMaxDamage()) / 2;
        long enemyID = closestEnemy.getID();
        this.damages.put(enemyID, damage + this.damages.getOrDefault(enemyID, 0));
        if (this.damages.get(enemyID) >= closestEnemy.getHitPoints()) {
            this.aliveEnemies.remove(closestEnemy);
        }
    }

    private void defendRangedUnit(Unit unit) {
        List<Unit> myRanged = this.myUnits.stream().filter(u -> u.getAttackRange() > 1).collect(Collectors.toList());
        Unit closestRanged = this.closestUnitAfterMoveAction(unit, myRanged);
    }

    private boolean moveDefensePosition(Unit warrior) {
        Map<Long, List<Integer>> baseDefensePositions = warrior.getAttackRange() > 1 ? this.baseDefensePositionsRanged : this.baseDefensePositions;
        Unit closestBase = this.closestUnit(warrior, this.myBases);
        if (closestBase == null) {
            return false;
        }
        Unit closestEnemyFromBase = this.closestUnit(closestBase, this.aliveEnemies);
        if (closestEnemyFromBase == null) {
            return false;
        }
        List<Integer> defensePositions = baseDefensePositions.get(closestBase.getID());
        int bestPos = -1;
        int minDist = Integer.MAX_VALUE;
        for (Integer defensePos : defensePositions) {
            Unit existingUnit = this.pgs.getUnitAt(this.pgsIntToPosX(defensePos), this.pgsIntToPosY(defensePos));
            if (existingUnit != null && this.isAllyUnit(existingUnit)) continue;
            int dist = this.astar.findDistToPositionInRange(warrior, defensePos, 0, this.gs, this.gs.getResourceUsage());
            int enemyDist = CoacAI.distance(closestEnemyFromBase, this.pgsIntToPosX(defensePos), this.pgsIntToPosY(defensePos));
            if (dist == -1 || enemyDist >= minDist) continue;
            minDist = enemyDist;
            bestPos = defensePos;
        }
        if (bestPos == -1) {
            return false;
        }
        int workerPos = warrior.getPosition(this.pgs);
        if (defensePositions.contains(workerPos) && minDist <= CoacAI.distance(closestEnemyFromBase, this.pgsIntToPosX(workerPos), this.pgsIntToPosY(workerPos))) {
            return false;
        }
        this.move(warrior, this.pgsIntToPosX(bestPos), this.pgsIntToPosY(bestPos));
        return true;
    }

    private int pgsPos(int x, int y) {
        return x + this.pgs.getWidth() * y;
    }

    private int pgsIntToPosX(int pos) {
        return pos % this.pgs.getWidth();
    }

    private Position pgsIntToPos(int pos) {
        return new Position(this.pgsIntToPosX(pos), this.pgsIntToPosY(pos));
    }

    private int pgsIntToPosY(int pos) {
        return pos / this.pgs.getWidth();
    }

    private void harvestClosest(Unit worker) {
        Unit closestResource = this.closestUnit(worker, this.myClosestResources);
        Unit closestBase = this.closestUnit(worker, this.myBases.stream().filter(base -> !this.baseHasEnoughHarvester((Unit)base)).collect(Collectors.toList()));
        this.printDebug(worker + " harvesting " + closestResource);
        this.harvesting.put(worker.getID(), closestBase.getID());
        this.harvest(worker, closestResource, closestBase);
    }

    private int harvestScore(Unit worker) {
        Unit closestResource = this.closestUnit(worker, this.myClosestResources);
        Unit closestBase = this.closestUnit(worker, this.myBases.stream().filter(base -> !this.baseHasEnoughHarvester((Unit)base)).collect(Collectors.toList()));
        if (closestBase == null || closestResource == null) {
            return Integer.MAX_VALUE;
        }
        return this.distance(worker, closestBase) + this.distance(worker, closestResource);
    }

    private boolean baseHasEnoughHarvester(Unit base) {
        return this.harvesting.values().stream().filter(b -> b.longValue() == base.getID()).count() >= 2L;
    }

    private Unit closestUnit(Unit worker, List<Unit> enemies) {
        Unit closestEnemy = null;
        if (!enemies.isEmpty()) {
            closestEnemy = enemies.stream().min(Comparator.comparing(u -> this.distance(worker, (Unit)u))).get();
        }
        return closestEnemy;
    }

    private Unit bestToAttack(Unit worker, List<Unit> enemies) {
        Unit closestEnemy = null;
        if (!enemies.isEmpty()) {
            closestEnemy = (Unit)enemies.stream().max((a, b) -> {
                int aRemainingHP = a.getHitPoints() - this.damages.getOrDefault(a.getID(), 0) - worker.getMinDamage();
                int bRemainingHP = b.getHitPoints() - this.damages.getOrDefault(b.getID(), 0) - worker.getMinDamage();
                if (aRemainingHP <= 0 && bRemainingHP <= 0) {
                    return aRemainingHP - bRemainingHP;
                }
                if (aRemainingHP <= 0) {
                    return 1;
                }
                if (bRemainingHP <= 0) {
                    return -1;
                }
                return -this.distance(worker, (Unit)a) + this.distance(worker, (Unit)b);
            }).get();
        }
        return closestEnemy;
    }

    private Unit closestUnitAfterMoveAction(Unit worker, List<Unit> enemies) {
        Unit closestEnemy = null;
        if (!enemies.isEmpty()) {
            closestEnemy = enemies.stream().min(Comparator.comparing(u -> CoacAI.distance(worker, CoacAI.nextPos(u, this.gs)))).get();
        }
        return closestEnemy;
    }

    private boolean isEnemyUnit(Unit u) {
        return u.getPlayer() >= 0 && u.getPlayer() != this.p.getID();
    }

    private boolean isAllyUnit(Unit u) {
        return u.getPlayer() == this.p.getID();
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return new ArrayList<ParameterSpecification>();
    }

    private boolean willBeMoveBeforeAttack(Unit unit, Unit closestEnemy) {
        UnitActionAssignment aa = this.gs.getActionAssignment(closestEnemy);
        if (aa == null) {
            return false;
        }
        if (aa.action.getType() != 1) {
            return false;
        }
        int eta = aa.action.ETA(closestEnemy) - (this.gs.getTime() - aa.time);
        return eta <= unit.getAttackTime();
    }

    @Override
    public void train(Unit u, UnitType unit_type) {
        if (this.gs.getActionAssignment(u) != null) {
            return;
        }
        if (this.p.getResources() - this.resourceUsed < unit_type.cost) {
            return;
        }
        this.resourceUsed += unit_type.cost;
        ArrayList<Integer> directions = new ArrayList<Integer>();
        directions.add(0);
        directions.add(2);
        directions.add(3);
        directions.add(1);
        int bestDirection = directions.stream().max(Comparator.comparingInt(d -> this.scoreTrainDirection(u, (int)d))).get();
        if (this.scoreTrainDirection(u, bestDirection) == Integer.MIN_VALUE) {
            this.printDebug(u + " failed to train");
            return;
        }
        this.actions.put(u, new TrainDirection(u, unit_type, bestDirection));
    }

    int scoreTrainDirection(Unit u, int direction) {
        int newPosY;
        int newPosX = u.getX() + UnitAction.DIRECTION_OFFSET_X[direction];
        Position pos = new Position(newPosX, newPosY = u.getY() + UnitAction.DIRECTION_OFFSET_Y[direction]);
        if (!this.isValidPos(pos) || !this.gs.free(newPosX, newPosY)) {
            return Integer.MIN_VALUE;
        }
        Unit enemy = this.closestUnit(u, this.enemies);
        return -CoacAI.distance(enemy, pos);
    }

    public static Position nextPos(Unit target, GameState gs) {
        UnitAction targetAction = gs.getUnitAction(target);
        if (targetAction != null && targetAction.getType() == 1 && targetAction.getDirection() != -1) {
            int newPosX = target.getX() + UnitAction.DIRECTION_OFFSET_X[targetAction.getDirection()];
            int newPosY = target.getY() + UnitAction.DIRECTION_OFFSET_Y[targetAction.getDirection()];
            return new Position(newPosX, newPosY);
        }
        return new Position(target.getX(), target.getY());
    }

    private boolean isValidPos(Position pos) {
        return pos.x < this.pgs.getWidth() && pos.x >= 0 && pos.y < this.pgs.getHeight() && pos.y >= 0;
    }

    private boolean isFreePos(Position pos) {
        if (this.pgs.getTerrain(pos.getX(), pos.getY()) == 1) {
            return false;
        }
        Unit unitAtPos = this.pgs.getUnitAt(pos.getX(), pos.getY());
        return unitAtPos == null;
    }

    public static boolean enemyIsInRangeAttack(Unit ourUnit, Unit closestUnit) {
        return CoacAI.squareDist(ourUnit, closestUnit) <= (double)ourUnit.getAttackRange();
    }

    static double squareDist(Unit ourUnit, Unit closestUnit) {
        int dx = closestUnit.getX() - ourUnit.getX();
        int dy = closestUnit.getY() - ourUnit.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    public static double squareDist(Unit ourUnit, Position pos2) {
        int dx = pos2.getX() - ourUnit.getX();
        int dy = pos2.getY() - ourUnit.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }

    int distance(Unit u1, Unit u2) {
        return Math.abs(u1.getX() - u2.getX()) + Math.abs(u1.getY() - u2.getY());
    }

    static int distance(Unit u1, Position pos2) {
        return Math.abs(u1.getX() - pos2.getX()) + Math.abs(u1.getY() - pos2.getY());
    }

    static int distance(Position u1, Position pos2) {
        return Math.abs(u1.getX() - pos2.getX()) + Math.abs(u1.getY() - pos2.getY());
    }

    static int distance(Unit u1, int x, int y) {
        return Math.abs(u1.getX() - x) + Math.abs(u1.getY() - y);
    }

    static int distanceChebyshev(Unit u1, int x2, int y2) {
        return Math.max(Math.abs(x2 - u1.getX()), Math.abs(y2 - u1.getY()));
    }

    static Position centroid(List<Unit> units) {
        int centroidX = 0;
        int centroidY = 0;
        for (Unit unit : units) {
            centroidX += unit.getX();
            centroidY += unit.getY();
        }
        return new Position(centroidX / units.size(), centroidY / units.size());
    }

    static int oppositeDirection(int direction) {
        if (direction == 0) {
            return 2;
        }
        if (direction == 2) {
            return 0;
        }
        if (direction == 3) {
            return 1;
        }
        if (direction == 1) {
            return 3;
        }
        throw new RuntimeException("direction not recognized");
    }

    public static class Position {
        int x;
        int y;

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public List<Position> adjacentPos() {
            return Stream.of(new Position(this.x, this.y + 1), new Position(this.x, this.y - 1), new Position(this.x + 1, this.y), new Position(this.x - 1, this.y)).collect(Collectors.toList());
        }

        public String toString() {
            return "Position{x=" + this.x + ", y=" + this.y + '}';
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position position = (Position)o;
            return this.x == position.x && this.y == position.y;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y);
        }
    }
}

