/*
 * Decompiled with CFR 0.152.
 */
package ai.coac;

import ai.abstraction.AbstractAction;
import ai.abstraction.pathfinding.PathFinding;
import ai.coac.CoacAI;
import java.util.Random;
import rts.GameState;
import rts.PhysicalGameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import util.XMLWriter;

public class CoacAttack
extends AbstractAction {
    Unit target;
    Unit unit;
    PathFinding pf;

    public CoacAttack(Unit u, Unit a_target, PathFinding a_pf) {
        super(u);
        this.unit = u;
        this.target = a_target;
        this.pf = a_pf;
    }

    @Override
    public boolean completed(GameState gs) {
        PhysicalGameState pgs = gs.getPhysicalGameState();
        return !pgs.getUnits().contains(this.target);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CoacAttack)) {
            return false;
        }
        CoacAttack a = (CoacAttack)o;
        return this.target.getID() == a.target.getID() && this.pf.getClass() == a.pf.getClass();
    }

    @Override
    public void toxml(XMLWriter w) {
        w.tagWithAttributes("Attack", "unitID=\"" + this.unit.getID() + "\" target=\"" + this.target.getID() + "\" pathfinding=\"" + this.pf.getClass().getSimpleName() + "\"");
        w.tag("/Attack");
    }

    @Override
    public UnitAction execute(GameState gs, ResourceUsage ru) {
        if (CoacAI.enemyIsInRangeAttack(this.unit, this.target)) {
            return new UnitAction(5, this.target.getX(), this.target.getY());
        }
        CoacAI.Position newPosition = CoacAI.nextPos(this.target, gs);
        if (CoacAI.squareDist(this.unit, newPosition) <= (double)this.unit.getAttackRange()) {
            return new UnitAction(0, 1);
        }
        UnitAction move = this.pf.findPathToPositionInRange(this.unit, this.target.getX() + this.target.getY() * gs.getPhysicalGameState().getWidth(), this.unit.getAttackRange(), gs, ru);
        if (move != null && gs.isUnitActionAllowed(this.unit, move)) {
            return move;
        }
        int m = new Random().nextInt(4);
        UnitAction m1 = new UnitAction(1, m);
        UnitAction m2 = new UnitAction(1, (m + 1) % 4);
        UnitAction m3 = new UnitAction(1, (m + 2) % 4);
        UnitAction m4 = new UnitAction(1, (m + 3) % 4);
        if (gs.isUnitActionAllowed(this.unit, m1)) {
            return m1;
        }
        if (gs.isUnitActionAllowed(this.unit, m2)) {
            return m2;
        }
        if (gs.isUnitActionAllowed(this.unit, m3)) {
            return m3;
        }
        if (gs.isUnitActionAllowed(this.unit, m4)) {
            return m4;
        }
        return new UnitAction(0, 1);
    }
}

