/*
 * Decompiled with CFR 0.152.
 */
package ai.coac;

import ai.abstraction.AbstractAction;
import java.util.Objects;
import rts.GameState;
import rts.ResourceUsage;
import rts.UnitAction;
import rts.units.Unit;
import rts.units.UnitType;
import util.XMLWriter;

public class TrainDirection
extends AbstractAction {
    UnitType type;
    Unit unit;
    int direction;
    boolean completed = false;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainDirection that = (TrainDirection)o;
        return this.direction == that.direction && this.completed == that.completed && Objects.equals(this.type, that.type);
    }

    public TrainDirection(Unit u, UnitType a_type, int direction) {
        super(u);
        this.unit = u;
        this.direction = direction;
        this.type = a_type;
    }

    @Override
    public boolean completed(GameState pgs) {
        return this.completed;
    }

    @Override
    public void toxml(XMLWriter w) {
        w.tagWithAttributes("Train", "unitID=\"" + this.unit.getID() + "\" type=\"" + this.type.name + "\"");
        w.tag("/Train");
    }

    @Override
    public UnitAction execute(GameState gs, ResourceUsage ru) {
        this.completed = true;
        UnitAction ua = new UnitAction(4, this.direction, this.type);
        if (gs.isUnitActionAllowed(this.unit, ua)) {
            return ua;
        }
        System.out.println("WARNING: TrainDirection invalid direction");
        return new UnitAction(0, 1);
    }
}

