/*
 * Decompiled with CFR 0.152.
 */
package ai.core;

import ai.core.ParameterSpecification;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;
import rts.units.UnitTypeTable;

public abstract class AI {
    public abstract void reset();

    public void reset(UnitTypeTable utt) {
        this.reset();
    }

    public abstract PlayerAction getAction(int var1, GameState var2) throws Exception;

    public abstract AI clone();

    public abstract List<ParameterSpecification> getParameters();

    public String statisticsString() {
        return null;
    }

    public void printStats() {
        String stats = this.statisticsString();
        if (stats != null) {
            System.out.println(stats);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public void preGameAnalysis(GameState gs, long milliseconds) throws Exception {
    }

    public void preGameAnalysis(GameState gs, long milliseconds, String readWriteFolder) throws Exception {
        this.preGameAnalysis(gs, milliseconds);
    }

    public void gameOver(int winner) throws Exception {
    }
}

