/*
 * Decompiled with CFR 0.152.
 */
package ai.core;

import ai.core.AI;
import ai.core.AIWithComputationBudget;
import ai.core.ParameterSpecification;
import java.util.List;
import rts.GameState;
import rts.PlayerAction;

public class PseudoContinuingAI
extends AI {
    public static int DEBUG = 0;
    protected AIWithComputationBudget m_AI;
    protected int n_cycles_to_think = 1;
    protected GameState m_farecastedGameState;

    public PseudoContinuingAI(AIWithComputationBudget ai) {
        this.m_AI = ai;
    }

    @Override
    public PlayerAction getAction(int player, GameState gs) throws Exception {
        if (gs.canExecuteAnyAction(player)) {
            if (this.m_farecastedGameState != null && !this.m_farecastedGameState.equals(gs)) {
                if (DEBUG >= 1) {
                    System.out.println("The game state is different from the predicted one (this can happen in non-deterministic games), restarring search.");
                }
                this.n_cycles_to_think = 1;
                this.m_farecastedGameState = null;
            }
            if (DEBUG >= 1) {
                System.out.println("PseudoContinuingAI: n_cycles_to_think = " + this.n_cycles_to_think);
            }
            int MT = this.m_AI.TIME_BUDGET;
            int MI = this.m_AI.ITERATIONS_BUDGET;
            if (MT > 0) {
                this.m_AI.TIME_BUDGET = MT * this.n_cycles_to_think;
            }
            if (MI > 0) {
                this.m_AI.ITERATIONS_BUDGET = MI * this.n_cycles_to_think;
            }
            PlayerAction action = this.m_AI.getAction(player, gs);
            this.m_AI.TIME_BUDGET = MT;
            this.m_AI.ITERATIONS_BUDGET = MI;
            this.n_cycles_to_think = 1;
            this.m_farecastedGameState = null;
            return action;
        }
        if (this.n_cycles_to_think == 1) {
            GameState gs2 = gs.clone();
            while (!(gs2.winner() != -1 || gs2.gameover() || gs2.canExecuteAnyAction(0) || gs2.canExecuteAnyAction(1))) {
                gs2.cycle();
            }
            if (gs2.winner() == -1 && !gs2.gameover() && gs2.canExecuteAnyAction(player)) {
                ++this.n_cycles_to_think;
                this.m_farecastedGameState = gs2;
            }
        } else {
            ++this.n_cycles_to_think;
        }
        return new PlayerAction();
    }

    @Override
    public void reset() {
        this.n_cycles_to_think = 1;
        this.m_AI.reset();
    }

    @Override
    public AI clone() {
        return new PseudoContinuingAI((AIWithComputationBudget)this.m_AI.clone());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.m_AI + ")";
    }

    @Override
    public String statisticsString() {
        return this.m_AI.statisticsString();
    }

    @Override
    public List<ParameterSpecification> getParameters() {
        return this.m_AI.getParameters();
    }

    public AIWithComputationBudget getbaseAI() {
        return this.m_AI;
    }
}

